/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.servlet.taglib.util;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.display.page.util.AssetDisplayPageHelper;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.web.asset.model.JournalArticleAssetRenderer;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.journal.web.util.JournalUtil;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import com.liferay.trash.TrashHelper;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalArticleActionDropdownItemsProvider {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleActionDropdownItemsProvider.class);
    private final JournalArticle _article;
    private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private final HttpServletRequest _httpServletRequest;
    private final JournalWebConfiguration _journalWebConfiguration;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _redirect;
    private String _referringPortletResource;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public JournalArticleActionDropdownItemsProvider(JournalArticle article, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, TrashHelper trashHelper) {
        this._article = article;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._trashHelper = trashHelper;
        this._journalWebConfiguration = (JournalWebConfiguration)this._liferayPortletRequest.getAttribute(JournalWebConfiguration.class.getName());
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "UPDATE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getEditArticleActionUnsafeConsumer());
                    this.add(JournalArticleActionDropdownItemsProvider.this._getMoveArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "PERMISSIONS")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getPermissionsArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "VIEW")) {
                    UnsafeConsumer previewContentArticleAction;
                    UnsafeConsumer viewContentArticleAction;
                    if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "SUBSCRIBE")) {
                        this.add(JournalArticleActionDropdownItemsProvider.this._getSubscribeArticleActionUnsafeConsumer());
                    }
                    if ((viewContentArticleAction = JournalArticleActionDropdownItemsProvider.this._getViewContentArticleActionUnsafeConsumer()) != null) {
                        this.add(viewContentArticleAction);
                    }
                    if ((previewContentArticleAction = JournalArticleActionDropdownItemsProvider.this._getPreviewArticleActionUnsafeConsumer()) != null) {
                        this.add(previewContentArticleAction);
                    }
                    if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "UPDATE")) {
                        this.add(JournalArticleActionDropdownItemsProvider.this._getViewHistoryArticleActionUnsafeConsumer());
                    }
                }
                this.add(JournalArticleActionDropdownItemsProvider.this._getViewUsagesArticleActionUnsafeConsumer());
                if (JournalFolderPermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._themeDisplay.getScopeGroupId(), JournalArticleActionDropdownItemsProvider.this._article.getFolderId(), "ADD_ARTICLE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getCopyArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "EXPIRE") && JournalArticleActionDropdownItemsProvider.this._article.hasApprovedVersion()) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getExpireArticleActionConsumer(JournalArticleActionDropdownItemsProvider.this._article.getArticleId()));
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "DELETE")) {
                    if (JournalArticleActionDropdownItemsProvider.this._trashHelper.isTrashEnabled(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getScopeGroupId())) {
                        this.add(JournalArticleActionDropdownItemsProvider.this._getMoveToTrashArticleActionUnsafeConsumer());
                    } else {
                        this.add(JournalArticleActionDropdownItemsProvider.this._getDeleteArticleAction(JournalArticleActionDropdownItemsProvider.this._article.getArticleId()));
                    }
                }
                Group group = JournalArticleActionDropdownItemsProvider.this._themeDisplay.getScopeGroup();
                if (JournalArticleActionDropdownItemsProvider.this._isShowPublishArticleAction() && !group.isLayout()) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getPublishToLiveArticleActionUnsafeConsumer());
                }
            }
        };
    }

    public List<DropdownItem> getArticleHistoryActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                UnsafeConsumer previewContentArticleAction;
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "VIEW") && (previewContentArticleAction = JournalArticleActionDropdownItemsProvider.this._getPreviewArticleActionUnsafeConsumer()) != null) {
                    this.add(previewContentArticleAction);
                }
                if (JournalFolderPermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._themeDisplay.getScopeGroupId(), JournalArticleActionDropdownItemsProvider.this._article.getFolderId(), "ADD_ARTICLE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getAutoCopyArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "EXPIRE") && JournalArticleActionDropdownItemsProvider.this._article.getStatus() == 0) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getExpireArticleActionConsumer(JournalArticleActionDropdownItemsProvider.this._article.getArticleId() + "_version_" + JournalArticleActionDropdownItemsProvider.this._article.getVersion()));
                }
                this.add(JournalArticleActionDropdownItemsProvider.this._getCompareArticleVersionsActionUnsafeConsumer());
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "DELETE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getDeleteArticleAction(JournalArticleActionDropdownItemsProvider.this._article.getArticleId() + "_version_" + JournalArticleActionDropdownItemsProvider.this._article.getVersion()));
                }
            }
        };
    }

    public List<DropdownItem> getArticleVersionActionDropdownItems() throws Exception {
        return new DropdownItemList(){
            {
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "UPDATE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getEditArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "VIEW")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getPreviewArticleActionUnsafeConsumer());
                }
                if (JournalFolderPermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._themeDisplay.getScopeGroupId(), JournalArticleActionDropdownItemsProvider.this._article.getFolderId(), "ADD_ARTICLE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getAutoCopyArticleActionUnsafeConsumer());
                }
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "EXPIRE") && JournalArticleActionDropdownItemsProvider.this._article.getStatus() == 0) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getExpireArticleActionConsumer(JournalArticleActionDropdownItemsProvider.this._article.getArticleId() + "_version_" + JournalArticleActionDropdownItemsProvider.this._article.getVersion()));
                }
                this.add(JournalArticleActionDropdownItemsProvider.this._getCompareArticleVersionsActionUnsafeConsumer());
                if (JournalArticlePermission.contains(JournalArticleActionDropdownItemsProvider.this._themeDisplay.getPermissionChecker(), JournalArticleActionDropdownItemsProvider.this._article, "DELETE")) {
                    this.add(JournalArticleActionDropdownItemsProvider.this._getDeleteArticleAction(JournalArticleActionDropdownItemsProvider.this._article.getArticleId() + "_version_" + JournalArticleActionDropdownItemsProvider.this._article.getVersion()));
                }
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getAutoCopyArticleActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/copy_article.jsp", "redirect", this._getRedirect(), "groupId", this._article.getGroupId(), "oldArticleId", this._article.getArticleId(), "version", this._article.getVersion()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"copy"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getCompareArticleVersionsActionUnsafeConsumer() throws Exception {
        PortletURL compareVersionsURL = this._liferayPortletResponse.createRenderURL();
        compareVersionsURL.setParameter("mvcPath", "/select_version.jsp");
        compareVersionsURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        compareVersionsURL.setParameter("articleId", this._article.getArticleId());
        compareVersionsURL.setParameter("sourceVersion", String.valueOf(this._article.getVersion()));
        compareVersionsURL.setWindowState(LiferayWindowState.POP_UP);
        PortletURL redirectURL = this._liferayPortletResponse.createRenderURL();
        redirectURL.setParameter("mvcPath", "/compare_versions.jsp");
        redirectURL.setParameter("redirect", this._getRedirect());
        redirectURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        redirectURL.setParameter("articleId", this._article.getArticleId());
        return dropdownItem -> {
            dropdownItem.putData("action", "compareVersions");
            dropdownItem.putData("compareVersionsURL", compareVersionsURL.toString());
            dropdownItem.putData("redirectURL", redirectURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"compare-to"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getCopyArticleActionUnsafeConsumer() {
        if (this._journalWebConfiguration.journalArticleForceAutogenerateId()) {
            PortletURL copyArticleURL = this._liferayPortletResponse.createActionURL();
            copyArticleURL.setParameter("javax.portlet.action", "copyArticle");
            copyArticleURL.setParameter("redirect", this._getRedirect());
            copyArticleURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
            copyArticleURL.setParameter("oldArticleId", this._article.getArticleId());
            copyArticleURL.setParameter("version", String.valueOf(this._article.getVersion()));
            copyArticleURL.setParameter("autoArticleId", Boolean.TRUE.toString());
            return dropdownItem -> {
                dropdownItem.putData("action", "copyArticle");
                dropdownItem.putData("copyArticleURL", copyArticleURL.toString());
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"copy"));
            };
        }
        return this._getAutoCopyArticleActionUnsafeConsumer();
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteArticleAction(String articleId) {
        PortletURL deleteURL = this._liferayPortletResponse.createActionURL();
        deleteURL.setParameter("javax.portlet.action", "deleteArticle");
        deleteURL.setParameter("redirect", this._getRedirect());
        deleteURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        deleteURL.setParameter("articleId", articleId);
        return dropdownItem -> {
            dropdownItem.putData("action", "delete");
            dropdownItem.putData("deleteURL", deleteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getEditArticleActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_article.jsp", "redirect", this._getRedirect(), "referringPortletResource", this._getReferringPortletResource(), "groupId", this._article.getGroupId(), "folderId", this._article.getFolderId(), "articleId", this._article.getArticleId(), "version", this._article.getVersion()});
            dropdownItem.setIcon("edit");
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"edit"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getExpireArticleActionConsumer(String articleId) {
        PortletURL expireURL = this._liferayPortletResponse.createActionURL();
        expireURL.setParameter("javax.portlet.action", "expireArticles");
        expireURL.setParameter("redirect", this._getRedirect());
        expireURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        expireURL.setParameter("articleId", articleId);
        return dropdownItem -> {
            dropdownItem.putData("action", "expireArticles");
            dropdownItem.putData("expireURL", expireURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"expire"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getMoveArticleActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/move_entries.jsp", "redirect", this._getRedirect(), "referringPortletResource", this._getReferringPortletResource(), "rowIdsJournalArticle", this._article.getArticleId()});
            dropdownItem.setIcon("move");
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"move"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getMoveToTrashArticleActionUnsafeConsumer() {
        PortletURL deleteURL = this._liferayPortletResponse.createActionURL();
        deleteURL.setParameter("javax.portlet.action", "moveToTrash");
        deleteURL.setParameter("redirect", this._getRedirect());
        deleteURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        deleteURL.setParameter("articleId", this._article.getArticleId());
        return dropdownItem -> {
            dropdownItem.putData("action", "delete");
            dropdownItem.putData("deleteURL", deleteURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"move-to-recycle-bin"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPermissionsArticleActionUnsafeConsumer() throws Exception {
        String permissionsURL = PermissionsURLTag.doTag((String)"", (String)JournalArticle.class.getName(), (String)HtmlUtil.escape((String)this._article.getTitle(this._themeDisplay.getLocale())), null, (String)String.valueOf(this._article.getResourcePrimKey()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        return dropdownItem -> {
            dropdownItem.putData("action", "permissions");
            dropdownItem.putData("permissionsURL", permissionsURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"permissions"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPreviewArticleActionUnsafeConsumer() throws Exception {
        String previewURL = this._getPreviewURL();
        if (Validator.isNull((String)previewURL)) {
            return null;
        }
        return dropdownItem -> {
            dropdownItem.putData("action", "preview");
            dropdownItem.putData("title", HtmlUtil.escape((String)this._article.getTitle(this._themeDisplay.getLocale())));
            dropdownItem.putData("previewURL", previewURL);
            String status = "preview";
            if (this._article.isDraft()) {
                status = "preview-draft";
            }
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)status));
        };
    }

    private String _getPreviewURL() throws Exception {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(JournalArticle.class.getName(), this._article.getResourcePrimKey());
        if (AssetDisplayPageHelper.hasAssetDisplayPage((long)this._themeDisplay.getScopeGroupId(), (AssetEntry)assetEntry)) {
            StringBundler sb = new StringBundler(3);
            sb.append(this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(assetEntry.getClassName(), assetEntry.getClassPK(), this._themeDisplay));
            sb.append("/");
            sb.append(this._article.getId());
            return HttpUtil.addParameter((String)sb.toString(), (String)"p_l_mode", (String)"preview");
        }
        if (Validator.isNull((String)this._article.getDDMTemplateKey())) {
            return "";
        }
        LiferayPortletURL portletURL = this._liferayPortletResponse.createLiferayPortletURL(JournalUtil.getPreviewPlid(this._article, this._themeDisplay), "com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("articleId", new String[]{this._article.getArticleId()});
        parameters.put("groupId", new String[]{String.valueOf(this._article.getGroupId())});
        parameters.put("mvcPath", new String[]{"/preview_article_content.jsp"});
        parameters.put("version", new String[]{String.valueOf(this._article.getVersion())});
        portletURL.setParameters(parameters);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL.toString();
    }

    private UnsafeConsumer<DropdownItem, Exception> _getPublishToLiveArticleActionUnsafeConsumer() {
        PortletURL publishArticleURL = this._liferayPortletResponse.createActionURL();
        publishArticleURL.setParameter("javax.portlet.action", "/journal/publish_article");
        publishArticleURL.setParameter("backURL", this._getRedirect());
        publishArticleURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        publishArticleURL.setParameter("articleId", this._article.getArticleId());
        return dropdownItem -> {
            dropdownItem.putData("action", "publishToLive");
            dropdownItem.putData("publishArticleURL", publishArticleURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"publish-to-live"));
        };
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect", (String)this._themeDisplay.getURLCurrent());
        return this._redirect;
    }

    private String _getReferringPortletResource() {
        if (this._referringPortletResource != null) {
            return this._referringPortletResource;
        }
        this._referringPortletResource = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"referringPortletResource");
        return this._referringPortletResource;
    }

    private UnsafeConsumer<DropdownItem, Exception> _getSubscribeArticleActionUnsafeConsumer() {
        if (JournalUtil.isSubscribedToArticle(this._article.getCompanyId(), this._themeDisplay.getScopeGroupId(), this._themeDisplay.getUserId(), this._article.getResourcePrimKey())) {
            PortletURL unsubscribeArticleURL = this._liferayPortletResponse.createActionURL();
            unsubscribeArticleURL.setParameter("javax.portlet.action", "unsubscribeArticle");
            unsubscribeArticleURL.setParameter("redirect", this._getRedirect());
            unsubscribeArticleURL.setParameter("articleId", String.valueOf(this._article.getResourcePrimKey()));
            return dropdownItem -> {
                dropdownItem.putData("action", "unsubscribeArticle");
                dropdownItem.putData("unsubscribeArticleURL", unsubscribeArticleURL.toString());
                dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"unsubscribe"));
            };
        }
        PortletURL subscribeArticleURL = this._liferayPortletResponse.createActionURL();
        subscribeArticleURL.setParameter("javax.portlet.action", "subscribeArticle");
        subscribeArticleURL.setParameter("redirect", this._getRedirect());
        subscribeArticleURL.setParameter("articleId", String.valueOf(this._article.getResourcePrimKey()));
        return dropdownItem -> {
            dropdownItem.putData("action", "subscribeArticle");
            dropdownItem.putData("subscribeArticleURL", subscribeArticleURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"subscribe"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewContentArticleActionUnsafeConsumer() throws Exception {
        String viewContentURL = this._getViewContentURL();
        if (Validator.isNull((String)viewContentURL)) {
            return null;
        }
        return dropdownItem -> {
            dropdownItem.setHref((Object)viewContentURL);
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"view-content"));
        };
    }

    private String _getViewContentURL() throws PortalException {
        String viewContentURL;
        block3: {
            if (!this._isShowViewContentURL()) {
                return "";
            }
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(this._article.getResourcePrimKey());
            viewContentURL = "";
            try {
                viewContentURL = assetRenderer.getURLViewInContext(this._liferayPortletRequest, this._liferayPortletResponse, this._getRedirect());
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e, (Throwable)e);
            }
        }
        return viewContentURL;
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewHistoryArticleActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/view_article_history.jsp", "redirect", this._getRedirect(), "backURL", this._getRedirect(), "referringPortletResource", this._getReferringPortletResource(), "articleId", this._article.getArticleId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"view-history"));
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getViewUsagesArticleActionUnsafeConsumer() {
        return dropdownItem -> {
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/view_asset_entry_usages.jsp", "redirect", this._getRedirect(), "groupId", this._article.getGroupId(), "articleId", this._article.getArticleId()});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"view-usages"));
        };
    }

    private boolean _isShowPublishAction() {
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        long scopeGroupId = this._themeDisplay.getScopeGroupId();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        try {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO") && stagingGroupHelper.isStagingGroup(scopeGroupId) && stagingGroupHelper.isStagedPortlet(scopeGroupId, "com_liferay_journal_web_portlet_JournalPortlet");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"An exception occured when checking if the publish action should be displayed", (Throwable)pe);
            }
            return false;
        }
    }

    private boolean _isShowPublishArticleAction() {
        if (this._article == null) {
            return false;
        }
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)JournalArticle.class.getName());
        return this._isShowPublishAction() && ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)this._article.getStatus());
    }

    private boolean _isShowViewContentURL() throws PortalException {
        if (this._article == null) {
            return false;
        }
        if (!this._article.hasApprovedVersion()) {
            return false;
        }
        JournalArticle curArticle = this._article;
        if (!this._article.isApproved()) {
            curArticle = JournalArticleLocalServiceUtil.getPreviousApprovedArticle((JournalArticle)this._article);
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)JournalArticle.class.getName(), (long)JournalArticleAssetRenderer.getClassPK(curArticle));
        return AssetDisplayPageHelper.hasAssetDisplayPage((long)this._themeDisplay.getScopeGroupId(), (AssetEntry)assetEntry);
    }
}

