/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.servlet.taglib.clay;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.VerticalCard;
import com.liferay.journal.web.internal.display.context.JournalSelectDDMTemplateDisplayContext;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class JournalSelectDDMTemplateVerticalCard
implements VerticalCard {
    private final DDMTemplate _ddmTemplate;
    private final HttpServletRequest _httpServletRequest;
    private final JournalSelectDDMTemplateDisplayContext _journalSelectDDMTemplateDisplayContext;

    public JournalSelectDDMTemplateVerticalCard(BaseModel<?> baseModel, RenderRequest renderRequest, JournalSelectDDMTemplateDisplayContext journalSelectDDMTemplateDisplayContext) {
        this._ddmTemplate = (DDMTemplate)baseModel;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._journalSelectDDMTemplateDisplayContext = journalSelectDDMTemplateDisplayContext;
    }

    public Map<String, String> getData() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ddmtemplateid", String.valueOf(this._ddmTemplate.getTemplateId()));
        data.put("ddmtemplatekey", this._ddmTemplate.getTemplateKey());
        data.put("description", this._ddmTemplate.getDescription(themeDisplay.getLocale()));
        data.put("imageurl", this._ddmTemplate.getTemplateImageURL(themeDisplay));
        data.put("name", this._ddmTemplate.getName(themeDisplay.getLocale()));
        return data;
    }

    public String getElementClasses() {
        if (this._ddmTemplate.getTemplateId() != this._journalSelectDDMTemplateDisplayContext.getDDMTemplateId()) {
            return "card-interactive card-interactive-secondary selector-button";
        }
        return "";
    }

    public String getIcon() {
        return "page-template";
    }

    public String getImageSrc() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return HtmlUtil.escapeAttribute((String)this._ddmTemplate.getTemplateImageURL(themeDisplay));
    }

    public String getSubtitle() {
        Date createDate = this._ddmTemplate.getModifiedDate();
        String modifiedDateDescription = LanguageUtil.getTimeDescription((HttpServletRequest)this._httpServletRequest, (long)(System.currentTimeMillis() - createDate.getTime()), (boolean)true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"modified-x-ago", (Object)modifiedDateDescription);
    }

    public String getTitle() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return HtmlUtil.escape((String)this._ddmTemplate.getName(themeDisplay.getLocale()));
    }

    public boolean isSelectable() {
        return false;
    }
}

