/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.servlet.taglib.clay;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseVerticalCard;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.servlet.taglib.util.JournalArticleActionDropdownItemsProvider;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalArticleVerticalCard
extends BaseVerticalCard {
    private final JournalArticle _article;
    private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private final HttpServletRequest _httpServletRequest;
    private final RenderResponse _renderResponse;
    private final TrashHelper _trashHelper;

    public JournalArticleVerticalCard(BaseModel<?> baseModel, RenderRequest renderRequest, RenderResponse renderResponse, RowChecker rowChecker, AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, TrashHelper trashHelper) {
        super(baseModel, renderRequest, rowChecker);
        this._renderResponse = renderResponse;
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._trashHelper = trashHelper;
        this._article = (JournalArticle)baseModel;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public List<DropdownItem> getActionDropdownItems() {
        LiferayPortletRequest liferayPortletRequest = PortalUtil.getLiferayPortletRequest((PortletRequest)this.renderRequest);
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)this._renderResponse);
        JournalArticleActionDropdownItemsProvider articleActionDropdownItemsProvider = new JournalArticleActionDropdownItemsProvider(this._article, liferayPortletRequest, liferayPortletResponse, this._assetDisplayPageFriendlyURLProvider, this._trashHelper);
        try {
            return articleActionDropdownItemsProvider.getActionDropdownItems();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getDefaultEventHandler() {
        return "JOURNAL_ELEMENTS_DEFAULT_EVENT_HANDLER";
    }

    public String getHref() {
        try {
            if (!JournalArticlePermission.contains(this.themeDisplay.getPermissionChecker(), this._article, "UPDATE")) {
                return "";
            }
            String referringPortletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"referringPortletResource");
            PortletURL editArticleURL = this._renderResponse.createRenderURL();
            editArticleURL.setParameter("mvcPath", "/edit_article.jsp");
            editArticleURL.setParameter("redirect", this.themeDisplay.getURLCurrent());
            editArticleURL.setParameter("referringPortletResource", referringPortletResource);
            editArticleURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
            editArticleURL.setParameter("folderId", String.valueOf(this._article.getFolderId()));
            editArticleURL.setParameter("articleId", this._article.getArticleId());
            editArticleURL.setParameter("version", String.valueOf(this._article.getVersion()));
            return editArticleURL.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getIcon() {
        return "web-content";
    }

    public String getImageSrc() {
        return HtmlUtil.escape((String)this._article.getArticleImageURL(this.themeDisplay));
    }

    public String getInputName() {
        return this.rowChecker.getRowIds() + JournalArticle.class.getSimpleName();
    }

    public String getInputValue() {
        return HtmlUtil.escape((String)this._article.getArticleId());
    }

    public List<LabelItem> getLabels() {
        return new LabelItemList(){
            {
                if (!JournalArticleVerticalCard.this._article.isApproved() && JournalArticleVerticalCard.this._article.hasApprovedVersion()) {
                    this.add(labelItem -> labelItem.setStatus(0));
                }
                this.add(labelItem -> labelItem.setStatus(JournalArticleVerticalCard.this._article.getStatus()));
            }
        };
    }

    public String getSubtitle() {
        Date createDate = this._article.getModifiedDate();
        String modifiedDateDescription = LanguageUtil.getTimeDescription((HttpServletRequest)this._httpServletRequest, (long)(System.currentTimeMillis() - createDate.getTime()), (boolean)true);
        return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"modified-x-ago", (Object)modifiedDateDescription);
    }

    public String getTitle() {
        String title = this._article.getTitle(this.themeDisplay.getLocale());
        if (Validator.isNotNull((String)title)) {
            return HtmlUtil.escape((String)title);
        }
        Locale defaultLanguage = LocaleUtil.fromLanguageId((String)this._article.getDefaultLanguageId());
        return HtmlUtil.escape((String)this._article.getTitle(defaultLanguage));
    }
}

