/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.search;

import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.util.comparator.FeedIDComparator;
import com.liferay.journal.util.comparator.FeedNameComparator;
import com.liferay.journal.web.internal.search.FeedDisplayTerms;
import com.liferay.journal.web.internal.search.FeedSearchTerms;
import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class FeedSearch
extends SearchContainer<JournalFeed> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-feeds-were-found";
    public static List<String> headerNames = new ArrayList<String>(){
        {
            this.add("id");
            this.add("description");
        }
    };

    public FeedSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new FeedDisplayTerms(portletRequest), (DisplayTerms)new FeedSearchTerms(portletRequest), "cur", DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        FeedDisplayTerms displayTerms = (FeedDisplayTerms)this.getDisplayTerms();
        iteratorURL.setParameter("description", displayTerms.getDescription());
        iteratorURL.setParameter("searchFeedId", displayTerms.getFeedId());
        iteratorURL.setParameter("name", displayTerms.getName());
        iteratorURL.setParameter("groupId", String.valueOf(displayTerms.getGroupId()));
        String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol", (String)"name");
        String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType", (String)"asc");
        OrderByComparator<JournalFeed> orderByComparator = this.getOrganizationOrderByComparator(orderByCol, orderByType);
        this.setOrderByCol(orderByCol);
        this.setOrderByType(orderByType);
        this.setOrderByComparator(orderByComparator);
    }

    protected OrderByComparator<JournalFeed> getOrganizationOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new FeedNameComparator(orderByAsc) : new FeedIDComparator(orderByAsc);
        return orderByComparator;
    }
}

