/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet.action;

import com.liferay.journal.exception.ExportArticleTargetExtensionException;
import com.liferay.journal.util.ExportArticleHelper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "mvc.command.name=exportArticle"}, service={MVCResourceCommand.class})
public class ExportArticleMVCResourceCommand
extends BaseMVCResourceCommand {
    private static final Log _log = LogFactoryUtil.getLog(ExportArticleMVCResourceCommand.class);
    private ExportArticleHelper _exportArticleHelper;
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        try {
            Object[] allowedExtensions;
            long plid;
            Layout layout;
            String targetExtension = ParamUtil.getString((PortletRequest)resourceRequest, (String)"targetExtension");
            PortletPreferences portletPreferences = resourceRequest.getPreferences();
            String porletResource = ParamUtil.getString((PortletRequest)resourceRequest, (String)"portletResource");
            if (Validator.isNotNull((String)porletResource) && (layout = this._layoutLocalService.fetchLayout(plid = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"plid"))) != null) {
                portletPreferences = PortletPreferencesFactoryUtil.getExistingPortletSetup((Layout)layout, (String)porletResource);
            }
            if (ArrayUtil.isNotEmpty((Object[])(allowedExtensions = portletPreferences.getValues("extensions", null))) && allowedExtensions.length == 1) {
                allowedExtensions = StringUtil.split((String)portletPreferences.getValue("extensions", null));
            }
            if (!ArrayUtil.contains((String[])allowedExtensions, (String)targetExtension, (boolean)true)) {
                throw new ExportArticleTargetExtensionException("Target extension " + targetExtension + " is not allowed");
            }
            this._exportArticleHelper.sendFile(targetExtension, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to export article", (Throwable)e);
            this._portal.sendError(e, this._portal.getHttpServletRequest((PortletRequest)resourceRequest), this._portal.getHttpServletResponse((PortletResponse)resourceResponse));
        }
    }

    @Reference(unbind="-")
    protected void setExportArticleHelper(ExportArticleHelper exportArticleHelper) {
        this._exportArticleHelper = exportArticleHelper;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

