/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet.action;

import com.liferay.journal.exception.ArticleIdException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "mvc.command.name=copyArticle"}, service={MVCActionCommand.class})
public class CopyArticleMVCActionCommand
extends BaseMVCActionCommand {
    private JournalArticleService _journalArticleService;

    protected void copyArticle(ActionRequest actionRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String oldArticleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"oldArticleId");
        String newArticleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"newArticleId");
        boolean autoArticleId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
        this._journalArticleService.copyArticle(groupId, oldArticleId, newArticleId, autoArticleId, version);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.copyArticle(actionRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchArticleException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                PortletSession portletSession = actionRequest.getPortletSession();
                PortletContext portletContext = portletSession.getPortletContext();
                PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/error.jsp");
                portletRequestDispatcher.include((PortletRequest)actionRequest, (PortletResponse)actionResponse);
            }
            if (e instanceof ArticleIdException || e instanceof DuplicateArticleIdException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setJournalArticleService(JournalArticleService journalArticleService) {
        this._journalArticleService = journalArticleService;
    }
}

