/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet.action;

import com.liferay.dynamic.data.mapping.exception.TemplateScriptException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureServiceUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.service.JournalFeedServiceUtil;
import com.liferay.journal.service.JournalFolderServiceUtil;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.journal.web.internal.security.permission.resource.JournalPermission;
import com.liferay.journal.web.internal.util.JournalHelperUtil;
import com.liferay.journal.web.util.JournalUtil;
import com.liferay.portal.kernel.diff.CompareVersionsException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static void compareVersions(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"articleId");
        String sourceArticleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"sourceVersion");
        int index = sourceArticleId.lastIndexOf("_version_");
        if (index != -1) {
            sourceArticleId = sourceArticleId.substring(index + "_version_".length());
        }
        double sourceVersion = GetterUtil.getDouble((String)sourceArticleId);
        String targetArticleId = ParamUtil.getString((PortletRequest)renderRequest, (String)"targetVersion");
        index = targetArticleId.lastIndexOf("_version_");
        if (index != -1) {
            targetArticleId = targetArticleId.substring(index + "_version_".length());
        }
        double targetVersion = GetterUtil.getDouble((String)targetArticleId);
        if (sourceVersion == 0.0 && targetVersion == 0.0) {
            List sourceArticles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)0, (int)1, (OrderByComparator)new ArticleVersionComparator(false));
            JournalArticle sourceArticle = (JournalArticle)sourceArticles.get(0);
            sourceVersion = sourceArticle.getVersion();
            List targetArticles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)0, (int)1, (OrderByComparator)new ArticleVersionComparator(true));
            JournalArticle targetArticle = (JournalArticle)targetArticles.get(0);
            targetVersion = targetArticle.getVersion();
        }
        if (sourceVersion > targetVersion) {
            double tempVersion = targetVersion;
            targetVersion = sourceVersion;
            sourceVersion = tempVersion;
        }
        String languageId = ActionUtil.getLanguageId(renderRequest, groupId, articleId, sourceVersion, targetVersion);
        String diffHtmlResults = null;
        try {
            diffHtmlResults = JournalHelperUtil.diffHtml(groupId, articleId, sourceVersion, targetVersion, languageId, new PortletRequestModel((PortletRequest)renderRequest, (PortletResponse)renderResponse), themeDisplay);
        }
        catch (CompareVersionsException cve) {
            renderRequest.setAttribute("DIFF_VERSION", (Object)cve.getVersion());
        }
        renderRequest.setAttribute("DIFF_HTML_RESULTS", diffHtmlResults);
        renderRequest.setAttribute("SOURCE_VERSION", (Object)sourceVersion);
        renderRequest.setAttribute("TARGET_VERSION", (Object)targetVersion);
    }

    public static void deleteArticle(ActionRequest actionRequest, String deleteArticleId) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = deleteArticleId;
        String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
        double version = 0.0;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        int pos = deleteArticleId.lastIndexOf("_version_");
        if (pos == -1) {
            JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
        } else {
            articleId = articleId.substring(0, pos);
            version = GetterUtil.getDouble((String)deleteArticleId.substring(pos + "_version_".length()));
            JournalArticleServiceUtil.deleteArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
        }
        JournalUtil.removeRecentArticle((PortletRequest)actionRequest, articleId, version);
    }

    public static void expireArticle(ActionRequest actionRequest, String expireArticleId) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = expireArticleId;
        String articleURL = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleURL");
        double version = 0.0;
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        int pos = expireArticleId.lastIndexOf("_version_");
        if (pos == -1) {
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (String)articleURL, (ServiceContext)serviceContext);
        } else {
            articleId = articleId.substring(0, pos);
            version = GetterUtil.getDouble((String)expireArticleId.substring(pos + "_version_".length()));
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)articleId, (double)version, (String)articleURL, (ServiceContext)serviceContext);
        }
        JournalUtil.removeRecentArticle((PortletRequest)actionRequest, articleId, version);
    }

    public static void expireFolder(long groupId, long parentFolderId, ServiceContext serviceContext) throws Exception {
        List folders = JournalFolderServiceUtil.getFolders((long)groupId, (long)parentFolderId);
        for (JournalFolder folder : folders) {
            ActionUtil.expireFolder(groupId, folder.getFolderId(), serviceContext);
        }
        List articles = JournalArticleServiceUtil.getArticles((long)groupId, (long)parentFolderId, (Locale)LocaleUtil.getMostRelevantLocale());
        for (JournalArticle article : articles) {
            JournalArticleServiceUtil.expireArticle((long)groupId, (String)article.getArticleId(), null, (ServiceContext)serviceContext);
        }
    }

    public static JournalArticle getArticle(HttpServletRequest httpServletRequest) throws PortalException {
        String actionName = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"javax.portlet.action");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"resourcePrimKey");
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        long classNameId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"articleId");
        String ddmStructureKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ddmStructureKey");
        int status = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"status", (int)-1);
        JournalArticle article = null;
        if (actionName.equals("addArticle") && resourcePrimKey != 0L) {
            article = JournalArticleLocalServiceUtil.getLatestArticle((long)resourcePrimKey, (int)status, (boolean)false);
        } else if (!actionName.equals("addArticle") && Validator.isNotNull((String)articleId)) {
            article = JournalArticleServiceUtil.getLatestArticle((long)groupId, (String)articleId, (int)status);
        } else {
            if (classNameId > 0L && classPK > 0L) {
                String className = PortalUtil.getClassName((long)classNameId);
                try {
                    article = JournalArticleServiceUtil.getLatestArticle((long)groupId, (String)className, (long)classPK);
                }
                catch (NoSuchArticleException nsae) {
                    return null;
                }
            }
            DDMStructure ddmStructure = DDMStructureServiceUtil.fetchStructure((long)groupId, (long)PortalUtil.getClassNameId(JournalArticle.class), (String)ddmStructureKey, (boolean)true);
            if (ddmStructure == null) {
                return null;
            }
            try {
                article = JournalArticleServiceUtil.getArticle((long)ddmStructure.getGroupId(), (String)DDMStructure.class.getName(), (long)ddmStructure.getStructureId());
                article.getTitleMap();
                article.getDescriptionMap();
                article.setNew(true);
                article.setId(0L);
                article.setGroupId(groupId);
                article.setClassNameId(0L);
                article.setClassPK(0L);
                article.setArticleId(null);
                article.setVersion(0.0);
            }
            catch (NoSuchArticleException nsae) {
                return null;
            }
        }
        return article;
    }

    public static JournalArticle getArticle(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        JournalArticle article = ActionUtil.getArticle(httpServletRequest);
        JournalUtil.addRecentArticle(portletRequest, article);
        return article;
    }

    public static List<JournalArticle> getArticles(ResourceRequest request) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)request, (String)"groupId");
        String[] articleIds = ParamUtil.getStringValues((PortletRequest)request, (String)"rowIdsJournalArticle");
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        for (String articleId : articleIds) {
            JournalArticle article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId);
            articles.add(article);
        }
        return articles;
    }

    public static JournalFeed getFeed(HttpServletRequest httpServletRequest) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        String feedId = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"feedId");
        JournalFeed feed = null;
        if (Validator.isNotNull((String)feedId)) {
            feed = JournalFeedServiceUtil.getFeed((long)groupId, (String)feedId);
        }
        return feed;
    }

    public static JournalFeed getFeed(PortletRequest portletRequest) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFeed(httpServletRequest);
    }

    public static JournalFolder getFolder(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"folderId");
        JournalFolder folder = null;
        if (folderId > 0L && folderId != 0L) {
            folder = JournalFolderServiceUtil.fetchFolder((long)folderId);
        } else {
            JournalPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup(), "VIEW");
        }
        return folder;
    }

    public static JournalFolder getFolder(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolder(httpServletRequest);
    }

    public static List<JournalFolder> getFolders(ResourceRequest request) throws Exception {
        long[] folderIds = ParamUtil.getLongValues((PortletRequest)request, (String)"rowIdsJournalFolder");
        ArrayList<JournalFolder> folders = new ArrayList<JournalFolder>();
        for (long folderId : folderIds) {
            JournalFolder folder = JournalFolderServiceUtil.getFolder((long)folderId);
            folders.add(folder);
        }
        return folders;
    }

    public static JournalArticle getPreviewArticle(PortletRequest portletRequest) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)portletRequest, (String)"articleId");
        double version = ParamUtil.getDouble((PortletRequest)portletRequest, (String)"version", (double)1.0);
        JournalArticle article = JournalArticleServiceUtil.getArticle((long)groupId, (String)articleId, (double)version);
        JournalUtil.addRecentArticle(portletRequest, article);
        return article;
    }

    public static String getScript(UploadPortletRequest uploadPortletRequest) throws Exception {
        String fileScriptContent = ActionUtil._getFileScriptContent(uploadPortletRequest);
        if (Validator.isNotNull((String)fileScriptContent)) {
            return fileScriptContent;
        }
        return ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"scriptContent");
    }

    public static boolean hasArticle(ActionRequest actionRequest) throws Exception {
        JournalArticle article;
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        if (Validator.isNull((String)articleId)) {
            String[] articleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"rowIds"));
            if (articleIds.length <= 0) {
                return false;
            }
            articleId = articleIds[0];
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int pos = articleId.lastIndexOf("_version_");
        if (pos != -1) {
            articleId = articleId.substring(0, pos);
        }
        return (article = JournalArticleLocalServiceUtil.fetchArticle((long)themeDisplay.getScopeGroupId(), (String)articleId)) != null;
    }

    protected static String getElementInstanceId(String content, String fieldName, int index) throws Exception {
        Document document = SAXReaderUtil.read((String)content);
        String xPathExpression = "//dynamic-element[@name = " + HtmlUtil.escapeXPathAttribute((String)fieldName) + "]";
        XPath xPath = SAXReaderUtil.createXPath((String)xPathExpression);
        List nodes = xPath.selectNodes((Object)document);
        if (index > nodes.size()) {
            return "";
        }
        Element dynamicElementElement = (Element)nodes.get(index);
        return dynamicElementElement.attributeValue("instance-id");
    }

    protected static String getLanguageId(RenderRequest renderRequest, long groupId, String articleId, double sourceVersion, double targetVersion) throws Exception {
        JournalArticle sourceArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)sourceVersion);
        JournalArticle targetArticle = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)targetVersion);
        HashSet<Locale> locales = new HashSet<Locale>();
        for (String locale : sourceArticle.getAvailableLanguageIds()) {
            locales.add(LocaleUtil.fromLanguageId((String)locale));
        }
        for (String locale : targetArticle.getAvailableLanguageIds()) {
            locales.add(LocaleUtil.fromLanguageId((String)locale));
        }
        String languageId = ParamUtil.get((PortletRequest)renderRequest, (String)"languageId", (String)targetArticle.getDefaultLanguageId());
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        if (!locales.contains(locale)) {
            languageId = targetArticle.getDefaultLanguageId();
        }
        renderRequest.setAttribute("AVAILABLE_LOCALES", locales);
        renderRequest.setAttribute("LANGUAGE_ID", (Object)languageId);
        return languageId;
    }

    private static String _getFileScriptContent(UploadPortletRequest uploadPortletRequest) throws Exception {
        File file = uploadPortletRequest.getFile("script");
        if (file == null) {
            return null;
        }
        String fileScriptContent = FileUtil.read((File)file);
        String contentType = MimeTypesUtil.getContentType((File)file);
        if (Validator.isNotNull((String)fileScriptContent) && !ActionUtil._isValidContentType(contentType)) {
            throw new TemplateScriptException("Invalid contentType " + contentType);
        }
        return fileScriptContent;
    }

    private static boolean _isValidContentType(String contentType) {
        return contentType.equals("application/xslt+xml") || contentType.startsWith("text");
    }
}

