/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet;

import com.liferay.asset.display.page.portlet.AssetDisplayPageEntryFormProcessor;
import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.service.AssetEntryUsageLocalService;
import com.liferay.document.library.kernel.exception.DuplicateFileEntryException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.dynamic.data.mapping.exception.NoSuchStructureException;
import com.liferay.dynamic.data.mapping.exception.NoSuchTemplateException;
import com.liferay.dynamic.data.mapping.exception.StorageFieldRequiredException;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMTemplateHelper;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.exportimport.kernel.exception.ExportImportContentValidationException;
import com.liferay.item.selector.ItemSelector;
import com.liferay.journal.configuration.JournalFileUploadsConfiguration;
import com.liferay.journal.exception.ArticleContentException;
import com.liferay.journal.exception.ArticleContentSizeException;
import com.liferay.journal.exception.ArticleDisplayDateException;
import com.liferay.journal.exception.ArticleExpirationDateException;
import com.liferay.journal.exception.ArticleIdException;
import com.liferay.journal.exception.ArticleSmallImageNameException;
import com.liferay.journal.exception.ArticleSmallImageSizeException;
import com.liferay.journal.exception.ArticleTitleException;
import com.liferay.journal.exception.ArticleVersionException;
import com.liferay.journal.exception.DuplicateArticleIdException;
import com.liferay.journal.exception.DuplicateFeedIdException;
import com.liferay.journal.exception.DuplicateFolderNameException;
import com.liferay.journal.exception.FeedContentFieldException;
import com.liferay.journal.exception.FeedIdException;
import com.liferay.journal.exception.FeedNameException;
import com.liferay.journal.exception.FeedTargetLayoutFriendlyUrlException;
import com.liferay.journal.exception.FeedTargetPortletIdException;
import com.liferay.journal.exception.FolderNameException;
import com.liferay.journal.exception.InvalidDDMStructureException;
import com.liferay.journal.exception.MaxAddMenuFavItemsException;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.exception.NoSuchFeedException;
import com.liferay.journal.exception.NoSuchFolderException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.journal.service.JournalFeedService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.JournalHelper;
import com.liferay.journal.web.asset.model.JournalArticleAssetRenderer;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.portlet.action.ActionUtil;
import com.liferay.journal.web.internal.util.JournalDDMTemplateUtil;
import com.liferay.journal.web.util.JournalPortletUtil;
import com.liferay.journal.web.util.JournalUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.diff.CompareVersionsException;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.MultiSessionMessages;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.LiferayFileItemException;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.rss.util.RSSUtil;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.kernel.service.TrashEntryService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.journal.web.configuration.JournalWebConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-journal", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.header-portlet-css=/css/ddm_form.css", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.header-portlet-css=/css/tree.css", "com.liferay.portlet.icon=/icons/journal.png", "com.liferay.portlet.layout-cacheable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.preferences-unique-per-layout=false", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "com.liferay.portlet.webdav-storage-token=journal", "javax.portlet.display-name=Web Content", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.mvc-action-command-package-prefix=com.liferay.journal.web.portlet.action", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={JournalPortlet.class, Portlet.class})
public class JournalPortlet
extends MVCPortlet {
    public static final String VERSION_SEPARATOR = "_version_";
    private static final Log _log = LogFactoryUtil.getLog(JournalPortlet.class);
    @Reference
    private AssetDisplayPageEntryFormProcessor _assetDisplayPageEntryFormProcessor;
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetEntryUsageLocalService _assetEntryUsageLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateHelper _ddmTemplateHelper;
    @Reference
    private Http _http;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private JournalArticleService _journalArticleService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalContentSearchLocalService _journalContentSearchLocalService;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private JournalDDMTemplateUtil _journalDDMTemplateUtil;
    @Reference
    private JournalFeedService _journalFeedService;
    private volatile JournalFileUploadsConfiguration _journalFileUploadsConfiguration;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private JournalHelper _journalHelper;
    private volatile JournalWebConfiguration _journalWebConfiguration;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private TrashEntryService _trashEntryService;
    @Reference
    private TrashHelper _trashHelper;

    public void addAddMenuFavItem(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String key;
        String ddmStructureKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructureKey");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)actionRequest);
        Object[] addMenuFavItems = portalPreferences.getValues("com_liferay_journal_web_portlet_JournalPortlet", key = JournalPortletUtil.getAddMenuFavItemKey((PortletRequest)actionRequest, (PortletResponse)actionResponse), new String[0]);
        if (addMenuFavItems.length >= this._journalWebConfiguration.maxAddMenuItems()) {
            this.hideDefaultErrorMessage((PortletRequest)actionRequest);
            throw new MaxAddMenuFavItemsException();
        }
        portalPreferences.setValues("com_liferay_journal_web_portlet_JournalPortlet", key, (String[])ArrayUtil.append((Object[])addMenuFavItems, (Object)ddmStructureKey));
    }

    public void addArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateArticle(actionRequest, actionResponse);
    }

    public void addFeed(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateFeed(actionRequest, actionResponse);
    }

    public void addFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateFolder(actionRequest, actionResponse);
    }

    public void deleteArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteArticles(actionRequest, actionResponse, false);
    }

    public void deleteArticles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteArticles(actionRequest, actionResponse, false);
    }

    public void deleteEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteEntries(actionRequest, actionResponse, false);
    }

    public void deleteFeeds(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] deleteFeedIds = null;
        long deleteFeedId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"deleteFeedId");
        deleteFeedIds = deleteFeedId > 0L ? new long[]{deleteFeedId} : ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIds");
        for (long curDeleteFeedId : deleteFeedIds) {
            this._journalFeedService.deleteFeed(themeDisplay.getScopeGroupId(), String.valueOf(curDeleteFeedId));
        }
    }

    public void deleteFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteFolder(actionRequest, actionResponse, false);
    }

    public void expireArticles(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        if (Validator.isNotNull((String)articleId)) {
            ActionUtil.expireArticle(actionRequest, articleId);
        } else {
            String[] expireArticleIds;
            for (String expireArticleId : expireArticleIds = ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"rowIds")) {
                ActionUtil.expireArticle(actionRequest, HtmlUtil.unescape((String)expireArticleId));
            }
        }
        this.sendEditArticleRedirect(actionRequest, actionResponse);
    }

    public void expireEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] expireArticleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long[] expireFolderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsJournalFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (long expireFolderId : expireFolderIds) {
            ActionUtil.expireFolder(themeDisplay.getScopeGroupId(), expireFolderId, serviceContext);
        }
        for (String expireArticleId : expireArticleIds = ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"rowIdsJournalArticle")) {
            ActionUtil.expireArticle(actionRequest, HtmlUtil.unescape((String)expireArticleId));
        }
        this.sendEditEntryRedirect(actionRequest, actionResponse);
    }

    public void moveEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String[] articleIds;
        long newFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"newFolderId");
        long[] folderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsJournalFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (PortletRequest)actionRequest);
        for (long folderId : folderIds) {
            this._journalFolderService.moveFolder(folderId, newFolderId, serviceContext);
        }
        ArrayList<String> invalidArticleIds = new ArrayList<String>();
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        for (String articleId : articleIds = ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"rowIdsJournalArticle")) {
            try {
                this._journalArticleService.moveArticle(themeDisplay.getScopeGroupId(), HtmlUtil.unescape((String)articleId), newFolderId, serviceContext);
            }
            catch (InvalidDDMStructureException iddmse) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)iddmse.getMessage());
                }
                invalidArticleIds.add(articleId);
            }
        }
        if (!invalidArticleIds.isEmpty()) {
            StringBundler sb = new StringBundler(4);
            sb.append("Folder ");
            sb.append(newFolderId);
            sb.append(" does not allow the structures for articles: ");
            sb.append(StringUtil.merge(invalidArticleIds));
            throw new InvalidDDMStructureException(sb.toString());
        }
        this.sendEditEntryRedirect(actionRequest, actionResponse);
    }

    public void moveEntriesToTrash(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteEntries(actionRequest, actionResponse, true);
    }

    public void moveFolderToTrash(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteFolder(actionRequest, actionResponse, true);
    }

    public void moveToTrash(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.deleteArticles(actionRequest, actionResponse, true);
    }

    public void previewArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.updateArticle(actionRequest, actionResponse);
    }

    public void removeAddMenuFavItem(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String ddmStructureKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructureKey");
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)actionRequest);
        String key = JournalPortletUtil.getAddMenuFavItemKey((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        String[] addMenuFavItems = portalPreferences.getValues("com_liferay_journal_web_portlet_JournalPortlet", key);
        portalPreferences.setValues("com_liferay_journal_web_portlet_JournalPortlet", key, ArrayUtil.remove((String[])addMenuFavItems, (String)ddmStructureKey));
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        renderRequest.setAttribute(AssetDisplayPageFriendlyURLProvider.class.getName(), (Object)this._assetDisplayPageFriendlyURLProvider);
        renderRequest.setAttribute("TRASH_HELPER", (Object)this._trashHelper);
        String path = this.getPath((PortletRequest)renderRequest, (PortletResponse)renderResponse);
        if (Objects.equals(path, "/edit_article.jsp")) {
            renderRequest.setAttribute("ITEM_SELECTOR", (Object)this._itemSelector);
        }
        if (Objects.equals(path, "/edit_ddm_template.jsp")) {
            renderRequest.setAttribute(DDMTemplateHelper.class.getName(), (Object)this._ddmTemplateHelper);
            renderRequest.setAttribute(JournalDDMTemplateUtil.class.getName(), (Object)this._journalDDMTemplateUtil);
        }
        renderRequest.setAttribute(JournalFileUploadsConfiguration.class.getName(), (Object)this._journalFileUploadsConfiguration);
        renderRequest.setAttribute(JournalWebConfiguration.class.getName(), (Object)this._journalWebConfiguration);
        renderRequest.setAttribute("JOURNAL_CONTENT", (Object)this._journalContent);
        renderRequest.setAttribute("JOURNAL_CONVERTER", (Object)this._journalConverter);
        super.render(renderRequest, renderResponse);
    }

    public void restoreTrashEntries(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] restoreTrashEntryIds;
        for (long restoreTrashEntryId : restoreTrashEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreTrashEntryIds"), (long)0L)) {
            this._trashEntryService.restoreEntry(restoreTrashEntryId);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        resourceRequest.setAttribute(AssetDisplayPageFriendlyURLProvider.class.getName(), (Object)this._assetDisplayPageFriendlyURLProvider);
        resourceRequest.setAttribute(DDMTemplateHelper.class.getName(), (Object)this._ddmTemplateHelper);
        resourceRequest.setAttribute("TRASH_HELPER", (Object)this._trashHelper);
        resourceRequest.setAttribute(JournalWebConfiguration.class.getName(), (Object)this._journalWebConfiguration);
        String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)resourceResponse);
        if (resourceID.equals("compareVersions")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"groupId");
            String articleId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"articleId");
            double sourceVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterSourceVersion");
            double targetVersion = ParamUtil.getDouble((PortletRequest)resourceRequest, (String)"filterTargetVersion");
            String languageId = ParamUtil.getString((PortletRequest)resourceRequest, (String)"languageId");
            String diffHtmlResults = null;
            try {
                diffHtmlResults = this._journalHelper.diffHtml(groupId, articleId, sourceVersion, targetVersion, languageId, new PortletRequestModel((PortletRequest)resourceRequest, (PortletResponse)resourceResponse), themeDisplay);
            }
            catch (CompareVersionsException cve) {
                resourceRequest.setAttribute("DIFF_VERSION", (Object)cve.getVersion());
            }
            catch (Exception e) {
                try {
                    this._portal.sendError(e, httpServletRequest, httpServletResponse);
                }
                catch (ServletException servletException) {
                    // empty catch block
                }
            }
            resourceRequest.setAttribute("DIFF_HTML_RESULTS", diffHtmlResults);
            PortletSession portletSession = resourceRequest.getPortletSession();
            PortletContext portletContext = portletSession.getPortletContext();
            PortletRequestDispatcher portletRequestDispatcher = portletContext.getRequestDispatcher("/compare_versions_diff_html.jsp");
            portletRequestDispatcher.include((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        } else {
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    public void subscribeArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long articleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleId");
        this._journalArticleService.subscribe(themeDisplay.getScopeGroupId(), articleId);
    }

    public void subscribeFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._journalFolderService.subscribe(themeDisplay.getScopeGroupId(), folderId);
    }

    public void subscribeStructure(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        this._journalArticleService.subscribeStructure(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), ddmStructureId);
        this.sendEditArticleRedirect(actionRequest, actionResponse);
    }

    public void unsubscribeArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long articleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"articleId");
        this._journalArticleService.unsubscribe(themeDisplay.getScopeGroupId(), articleId);
    }

    public void unsubscribeFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        this._journalFolderService.unsubscribe(themeDisplay.getScopeGroupId(), folderId);
    }

    public void unsubscribeStructure(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long ddmStructureId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"ddmStructureId");
        this._journalArticleService.unsubscribeStructure(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), ddmStructureId);
        this.sendEditArticleRedirect(actionRequest, actionResponse);
    }

    public void updateArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
        if (uploadException != null) {
            Throwable cause = uploadException.getCause();
            if (uploadException.isExceededLiferayFileItemSizeLimit()) {
                throw new LiferayFileItemException(cause);
            }
            if (uploadException.isExceededFileSizeLimit() || uploadException.isExceededUploadRequestSizeLimit()) {
                throw new ArticleContentSizeException(cause);
            }
            throw new PortalException(cause);
        }
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating article " + MapUtil.toString((Map)uploadPortletRequest.getParameterMap())));
        }
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        long groupId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"groupId");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        long classNameId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classNameId");
        long classPK = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"classPK");
        String articleId = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleId");
        boolean autoArticleId = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"autoArticleId");
        double version = ParamUtil.getDouble((HttpServletRequest)uploadPortletRequest, (String)"version");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"titleMapAsXML");
        String ddmStructureKey = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"ddmStructureKey");
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._portal.getSiteGroupId(groupId), this._portal.getClassNameId(JournalArticle.class), ddmStructureKey, true);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalArticle.class.getName(), (UploadPortletRequest)uploadPortletRequest);
        Fields fields = DDMUtil.getFields((long)ddmStructure.getStructureId(), (ServiceContext)serviceContext);
        String content = this._journalConverter.getContent(ddmStructure, fields);
        Locale articleDefaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)content));
        if (classNameId == 0L && !this._hasDefaultLocale(titleMap, articleDefaultLocale)) {
            titleMap.put(articleDefaultLocale, LanguageUtil.format((HttpServletRequest)this._portal.getHttpServletRequest((PortletRequest)actionRequest), (String)"untitled-x", (Object)HtmlUtil.escape((String)ddmStructure.getName(themeDisplay.getLocale()))));
        }
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"descriptionMapAsXML");
        Map friendlyURLMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"friendlyURL");
        String ddmTemplateKey = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"ddmTemplateKey");
        int displayPageType = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayPageType");
        String layoutUuid = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"layoutUuid");
        if (displayPageType == 1 || displayPageType == 2) {
            Layout targetLayout = this._journalHelper.getArticleLayout(layoutUuid, groupId);
            JournalArticle latestArticle = this._journalArticleService.fetchArticle(groupId, articleId);
            if (displayPageType == 2 && targetLayout == null && latestArticle != null && Validator.isNotNull((String)latestArticle.getLayoutUuid())) {
                Layout latestTargetLayout = this._journalHelper.getArticleLayout(latestArticle.getLayoutUuid(), groupId);
                if (latestTargetLayout == null) {
                    layoutUuid = latestArticle.getLayoutUuid();
                }
            } else if (targetLayout == null) {
                layoutUuid = null;
            }
        } else {
            layoutUuid = null;
        }
        int displayDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        int expirationDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"expirationDateAmPm");
        boolean neverExpire = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverExpire", (displayDateYear == 0 ? 1 : 0) != 0);
        if (!PropsValues.SCHEDULER_ENABLED) {
            neverExpire = true;
        }
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int reviewDateMonth = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMonth");
        int reviewDateDay = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateDay");
        int reviewDateYear = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateYear");
        int reviewDateHour = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateHour");
        int reviewDateMinute = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateMinute");
        int reviewDateAmPm = ParamUtil.getInteger((HttpServletRequest)uploadPortletRequest, (String)"reviewDateAmPm");
        boolean neverReview = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"neverReview", (displayDateYear == 0 ? 1 : 0) != 0);
        if (!PropsValues.SCHEDULER_ENABLED) {
            neverReview = true;
        }
        if (reviewDateAmPm == 1) {
            reviewDateHour += 12;
        }
        boolean indexable = ParamUtil.getBoolean((HttpServletRequest)uploadPortletRequest, (String)"indexable");
        String smallImageSource = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageSource", (String)"none");
        boolean smallImage = !Objects.equals(smallImageSource, "none");
        String smallImageURL = "";
        File smallFile = null;
        if (Objects.equals(smallImageSource, "url")) {
            smallImageURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"smallImageURL");
        } else if (Objects.equals(smallImageSource, "file")) {
            smallFile = uploadPortletRequest.getFile("smallFile");
        }
        String articleURL = ParamUtil.getString((HttpServletRequest)uploadPortletRequest, (String)"articleURL");
        JournalArticle article = null;
        String oldUrlTitle = "";
        if (actionName.equals("addArticle")) {
            article = this._journalArticleService.addArticle(groupId, folderId, classNameId, classPK, articleId, autoArticleId, titleMap, descriptionMap, friendlyURLMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, null, articleURL, serviceContext);
        } else {
            article = this._journalArticleService.getArticle(groupId, articleId, version);
            String tempOldUrlTitle = article.getUrlTitle();
            if (actionName.equals("previewArticle") || actionName.equals("updateArticle")) {
                article = this._journalArticleService.updateArticle(groupId, folderId, articleId, version, titleMap, descriptionMap, friendlyURLMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, smallImage, smallImageURL, smallFile, null, articleURL, serviceContext);
            }
            if (!tempOldUrlTitle.equals(article.getUrlTitle())) {
                oldUrlTitle = tempOldUrlTitle;
            }
        }
        JournalUtil.addRecentArticle((PortletRequest)actionRequest, article);
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        long refererPlid = ParamUtil.getLong((PortletRequest)actionRequest, (String)"refererPlid");
        if (Validator.isNotNull((String)portletResource) && refererPlid > 0L) {
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), article.getResourcePrimKey());
            Layout layout = this._layoutLocalService.getLayout(refererPlid);
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getStrictPortletSetup((Layout)layout, (String)portletResource);
            if (portletPreferences != null) {
                portletPreferences.setValue("groupId", String.valueOf(article.getGroupId()));
                portletPreferences.setValue("articleId", article.getArticleId());
                if (assetEntry != null) {
                    portletPreferences.setValue("assetEntryId", String.valueOf(assetEntry.getEntryId()));
                }
                portletPreferences.store();
                this.updateContentSearch(refererPlid, portletResource, article.getArticleId());
            }
            if (assetEntry != null) {
                this._updateAssetEntryUsage(groupId, assetEntry, portletResource, refererPlid, serviceContext);
            }
        }
        this._assetDisplayPageEntryFormProcessor.process(JournalArticle.class.getName(), article.getResourcePrimKey(), (PortletRequest)actionRequest);
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        if (Validator.isNotNull((String)portletResource) && workflowAction != 2) {
            MultiSessionMessages.add((PortletRequest)actionRequest, (String)(portletResource + "requestProcessed"));
        }
        this.sendEditArticleRedirect(actionRequest, actionResponse, article, oldUrlTitle);
        boolean hideDefaultSuccessMessage = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"hideDefaultSuccessMessage");
        if (hideDefaultSuccessMessage) {
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    public void updateFeed(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String feedId = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        String ddmStructureKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructureKey");
        String ddmTemplateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmTemplateKey");
        String ddmRendererTemplateKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmRendererTemplateKey");
        int delta = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"delta");
        String orderByCol = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByCol");
        String orderByType = ParamUtil.getString((PortletRequest)actionRequest, (String)"orderByType");
        String targetLayoutFriendlyUrl = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetLayoutFriendlyUrl");
        String targetPortletId = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetPortletId");
        String contentField = ParamUtil.getString((PortletRequest)actionRequest, (String)"contentField");
        String feedType = ParamUtil.getString((PortletRequest)actionRequest, (String)"feedType", (String)RSSUtil.FEED_TYPE_DEFAULT);
        String feedFormat = RSSUtil.getFeedTypeFormat((String)feedType);
        double feedVersion = RSSUtil.getFeedTypeVersion((String)feedType);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFeed.class.getName(), (PortletRequest)actionRequest);
        if (actionName.equals("addFeed")) {
            boolean autoFeedId = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"autoFeedId");
            this._journalFeedService.addFeed(groupId, feedId, autoFeedId, name, description, ddmStructureKey, ddmTemplateKey, ddmRendererTemplateKey, delta, orderByCol, orderByType, targetLayoutFriendlyUrl, targetPortletId, contentField, feedFormat, feedVersion, serviceContext);
        } else {
            this._journalFeedService.updateFeed(groupId, feedId, name, description, ddmStructureKey, ddmTemplateKey, ddmRendererTemplateKey, delta, orderByCol, orderByType, targetLayoutFriendlyUrl, targetPortletId, contentField, feedFormat, feedVersion, serviceContext);
        }
    }

    public void updateFolder(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            this._journalFolderService.addFolder(serviceContext.getScopeGroupId(), parentFolderId, name, description, serviceContext);
        } else {
            long[] ddmStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructuresSearchContainerPrimaryKeys"), (long)0L);
            int restrinctionType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"restrictionType");
            boolean mergeWithParentFolder = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentFolder");
            this._journalFolderService.updateFolder(serviceContext.getScopeGroupId(), folderId, parentFolderId, name, description, ddmStructureIds, restrinctionType, mergeWithParentFolder, serviceContext);
        }
    }

    public void updateWorkflowDefinitions(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long[] ddmStructureIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"ddmStructuresSearchContainerPrimaryKeys"), (long)0L);
        int restrinctionType = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"restrictionType");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        this._journalFolderService.updateFolder(serviceContext.getScopeGroupId(), 0L, 0L, null, null, ddmStructureIds, restrinctionType, false, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._journalFileUploadsConfiguration = (JournalFileUploadsConfiguration)ConfigurableUtil.createConfigurable(JournalFileUploadsConfiguration.class, properties);
        this._journalWebConfiguration = (JournalWebConfiguration)ConfigurableUtil.createConfigurable(JournalWebConfiguration.class, properties);
    }

    protected void deleteArticles(ActionRequest actionRequest, ActionResponse actionResponse, boolean moveToTrash) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String[] deleteArticleIds = null;
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        deleteArticleIds = Validator.isNotNull((String)articleId) ? new String[]{articleId} : ParamUtil.getParameterValues((PortletRequest)actionRequest, (String)"rowIds");
        ArrayList<JournalArticle> trashedModels = new ArrayList<JournalArticle>();
        for (String deleteArticleId : deleteArticleIds) {
            if (moveToTrash) {
                JournalArticle article = this._journalArticleService.moveArticleToTrash(themeDisplay.getScopeGroupId(), HtmlUtil.unescape((String)deleteArticleId));
                trashedModels.add(article);
                continue;
            }
            ActionUtil.deleteArticle(actionRequest, HtmlUtil.unescape((String)deleteArticleId));
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<JournalArticle>> data = new HashMap<String, ArrayList<JournalArticle>>();
            data.put("trashedModels", trashedModels);
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        this.sendEditArticleRedirect(actionRequest, actionResponse);
    }

    protected void deleteEntries(ActionRequest actionRequest, ActionResponse actionResponse, boolean moveToTrash) throws Exception {
        String[] deleteArticleIds;
        long[] deleteFolderIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<Object> trashedModels = new ArrayList<Object>();
        for (long deleteFolderId : deleteFolderIds = ParamUtil.getLongValues((PortletRequest)actionRequest, (String)"rowIdsJournalFolder")) {
            if (moveToTrash) {
                JournalFolder folder = this._journalFolderService.moveFolderToTrash(deleteFolderId);
                trashedModels.add(folder);
                continue;
            }
            this._journalFolderService.deleteFolder(deleteFolderId);
        }
        for (String deleteArticleId : deleteArticleIds = ParamUtil.getStringValues((PortletRequest)actionRequest, (String)"rowIdsJournalArticle")) {
            if (moveToTrash) {
                JournalArticle article = this._journalArticleService.moveArticleToTrash(themeDisplay.getScopeGroupId(), HtmlUtil.unescape((String)deleteArticleId));
                trashedModels.add(article);
                continue;
            }
            ActionUtil.deleteArticle(actionRequest, HtmlUtil.unescape((String)deleteArticleId));
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<Object>> data = new HashMap<String, ArrayList<Object>>();
            data.put("trashedModels", trashedModels);
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
        this.sendEditEntryRedirect(actionRequest, actionResponse);
    }

    protected void deleteFolder(ActionRequest actionRequest, ActionResponse actionResponse, boolean moveToTrash) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        ArrayList<JournalFolder> trashedModels = new ArrayList<JournalFolder>();
        if (moveToTrash) {
            JournalFolder folder = this._journalFolderService.moveFolderToTrash(folderId);
            trashedModels.add(folder);
        } else {
            this._journalFolderService.deleteFolder(folderId);
        }
        if (moveToTrash && !trashedModels.isEmpty()) {
            HashMap<String, ArrayList<JournalFolder>> data = new HashMap<String, ArrayList<JournalFolder>>();
            data.put("trashedModels", trashedModels);
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void doDispatch(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            String path = this.getPath((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            if (Objects.equals(path, "/edit_article.jsp") || Objects.equals(path, "/view_article_history.jsp")) {
                ActionUtil.getArticle((PortletRequest)renderRequest);
            } else {
                ActionUtil.getFolder((PortletRequest)renderRequest);
            }
        }
        catch (Exception e) {
            _log.error((Object)e.getMessage());
            SessionErrors.add((PortletRequest)renderRequest, e.getClass());
        }
        if (SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchArticleException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchFeedException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchFolderException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchStructureException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (String)NoSuchTemplateException.class.getName()) || SessionErrors.contains((PortletRequest)renderRequest, (Class[])PrincipalException.getNestedClasses())) {
            this.include("/error.jsp", renderRequest, renderResponse);
        } else {
            super.doDispatch(renderRequest, renderResponse);
        }
    }

    protected String getSaveAndContinueRedirect(ActionRequest actionRequest, JournalArticle article, String redirect) throws Exception {
        String portletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"portletResource");
        String referringPortletResource = ParamUtil.getString((PortletRequest)actionRequest, (String)"referringPortletResource");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)"com_liferay_journal_web_portlet_JournalPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        portletURL.setParameter("redirect", redirect);
        portletURL.setParameter("portletResource", portletResource);
        portletURL.setParameter("referringPortletResource", referringPortletResource);
        portletURL.setParameter("resourcePrimKey", String.valueOf(article.getResourcePrimKey()));
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        portletURL.setParameter("folderId", String.valueOf(article.getFolderId()));
        portletURL.setParameter("articleId", article.getArticleId());
        portletURL.setParameter("version", String.valueOf(article.getVersion()));
        portletURL.setWindowState(actionRequest.getWindowState());
        return portletURL.toString();
    }

    protected boolean isAlwaysSendRedirect() {
        return true;
    }

    protected boolean isSessionErrorException(Throwable cause) {
        return cause instanceof ArticleContentException || cause instanceof ArticleContentSizeException || cause instanceof ArticleDisplayDateException || cause instanceof ArticleExpirationDateException || cause instanceof ArticleIdException || cause instanceof ArticleSmallImageNameException || cause instanceof ArticleSmallImageSizeException || cause instanceof ArticleTitleException || cause instanceof ArticleVersionException || cause instanceof AssetCategoryException || cause instanceof AssetTagException || cause instanceof DuplicateArticleIdException || cause instanceof DuplicateFeedIdException || cause instanceof DuplicateFileEntryException || cause instanceof DuplicateFolderNameException || cause instanceof ExportImportContentValidationException || cause instanceof FeedContentFieldException || cause instanceof FeedIdException || cause instanceof FeedNameException || cause instanceof FeedTargetLayoutFriendlyUrlException || cause instanceof FeedTargetPortletIdException || cause instanceof FileSizeException || cause instanceof FolderNameException || cause instanceof InvalidDDMStructureException || cause instanceof LiferayFileItemException || cause instanceof LocaleException || cause instanceof MaxAddMenuFavItemsException || cause instanceof StorageFieldRequiredException || cause instanceof SystemException || super.isSessionErrorException(cause);
    }

    protected void sendEditArticleRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.sendEditArticleRedirect(actionRequest, actionResponse, null, "");
    }

    protected void sendEditArticleRedirect(ActionRequest actionRequest, ActionResponse actionResponse, JournalArticle article, String oldUrlTitle) throws Exception {
        String oldRedirectParam;
        String oldRedirect;
        String actionName = ParamUtil.getString((PortletRequest)actionRequest, (String)"javax.portlet.action");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        int workflowAction = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"workflowAction", (int)1);
        String portletId = this._http.getParameter(redirect, "portletResource", false);
        String namespace = this._portal.getPortletNamespace(portletId);
        if (Validator.isNotNull((String)oldUrlTitle) && Validator.isNotNull((String)portletId) && Validator.isNotNull((String)(oldRedirect = this._http.getParameter(redirect, oldRedirectParam = namespace + "redirect", false)))) {
            String newRedirect = this._http.decodeURL(oldRedirect);
            newRedirect = StringUtil.replace((String)newRedirect, (String)oldUrlTitle, (String)article.getUrlTitle());
            newRedirect = StringUtil.replace((String)newRedirect, (String)oldRedirectParam, (String)"redirect");
            redirect = StringUtil.replace((String)redirect, (String)oldRedirect, (String)newRedirect);
        }
        if ((actionName.equals("deleteArticle") || actionName.equals("deleteArticles")) && !ActionUtil.hasArticle(actionRequest)) {
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)actionRequest, (String)themeDisplay.getPpid(), (String)"RENDER_PHASE");
            redirect = portletURL.toString();
        }
        if (article != null && workflowAction == 2) {
            redirect = this.getSaveAndContinueRedirect(actionRequest, article, redirect);
            if (actionName.equals("previewArticle")) {
                SessionMessages.add((PortletRequest)actionRequest, (String)"previewRequested");
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            }
        } else if (Validator.isNotNull((String)(redirect = this._portal.escapeRedirect(redirect))) && Validator.isNotNull((String)portletId) && actionName.equals("addArticle") && article != null && Validator.isNotNull((String)namespace)) {
            redirect = this._http.addParameter(redirect, namespace + "className", JournalArticle.class.getName());
            redirect = this._http.addParameter(redirect, namespace + "classPK", JournalArticleAssetRenderer.getClassPK(article));
        }
        actionRequest.setAttribute("REDIRECT", (Object)redirect);
    }

    protected void sendEditEntryRedirect(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect = this._portal.escapeRedirect(ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
        WindowState windowState = actionRequest.getWindowState();
        if (!windowState.equals((Object)LiferayWindowState.POP_UP)) {
            this.sendRedirect(actionRequest, actionResponse);
        } else if (Validator.isNotNull((String)redirect)) {
            actionResponse.sendRedirect(redirect);
        }
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.journal.web)(&(release.schema.version>=1.0.0)(!(release.schema.version>=1.1.0))))", unbind="-")
    protected void setRelease(Release release) {
    }

    protected void updateContentSearch(long plid, String portletResource, String articleId) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        this._journalContentSearchLocalService.updateContentSearch(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), portletResource, articleId, true);
    }

    private boolean _hasDefaultLocale(Map<Locale, String> map, Locale locale) {
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        return !Validator.isNull((String)map.get(locale));
    }

    private void _updateAssetEntryUsage(long groupId, AssetEntry assetEntry, String portletResource, long plid, ServiceContext serviceContext) {
        AssetEntryUsage assetEntryUsage = this._assetEntryUsageLocalService.fetchAssetEntryUsage(assetEntry.getEntryId(), this._portal.getClassNameId(com.liferay.portal.kernel.model.Portlet.class), portletResource, plid);
        if (assetEntryUsage != null) {
            return;
        }
        this._assetEntryUsageLocalService.addAssetEntryUsage(groupId, assetEntry.getEntryId(), this._portal.getClassNameId(com.liferay.portal.kernel.model.Portlet.class), portletResource, plid, serviceContext);
    }
}

