/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.info.display.contributor;

import com.liferay.asset.info.display.contributor.BaseAssetInfoDisplayContributor;
import com.liferay.asset.info.display.contributor.util.ContentAccessor;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.info.display.contributor.InfoDisplayContributor;
import com.liferay.info.display.contributor.InfoDisplayField;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.web.asset.JournalArticleDDMFormValuesReader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={InfoDisplayContributor.class})
public class JournalArticleAssetInfoDisplayContributor
extends BaseAssetInfoDisplayContributor<JournalArticle> {
    @Reference
    protected DDMStructureLocalService ddmStructureLocalService;
    @Reference
    protected DLAppService dlAppService;
    @Reference
    protected DLURLHelper dlURLHelper;
    @Reference
    protected FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter;
    @Reference
    protected JournalContent journalContent;
    @Reference
    protected JournalConverter journalConverter;
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleAssetInfoDisplayContributor.class);

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public List<InfoDisplayField> getClassTypeInfoDisplayFields(long classTypeId, Locale locale) throws PortalException {
        List infoDisplayFields = super.getClassTypeInfoDisplayFields(classTypeId, locale);
        DDMStructure ddmStructure = this.ddmStructureLocalService.fetchDDMStructure(classTypeId);
        List ddmTemplates = ddmStructure.getTemplates();
        Stream stream = ddmTemplates.stream();
        infoDisplayFields.addAll(stream.map(ddmTemplate -> new InfoDisplayField(this._getTemplateKey((DDMTemplate)ddmTemplate), ddmTemplate.getName(locale) + " " + "*", "text")).collect(Collectors.toList()));
        return infoDisplayFields;
    }

    public String getInfoURLSeparator() {
        return "/w/";
    }

    protected Map<String, Object> getClassTypeValues(JournalArticle article, Locale locale) {
        HashMap<String, Object> classTypeValues;
        block3: {
            classTypeValues = new HashMap<String, Object>();
            JournalArticleDDMFormValuesReader journalArticleDDMFormValuesReader = new JournalArticleDDMFormValuesReader(article);
            journalArticleDDMFormValuesReader.setFieldsToDDMFormValuesConverter(this.fieldsToDDMFormValuesConverter);
            journalArticleDDMFormValuesReader.setJournalConverter(this.journalConverter);
            try {
                DDMFormValues ddmFormValues = journalArticleDDMFormValuesReader.getDDMFormValues();
                Map ddmFormFieldsValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
                for (Map.Entry entry : ddmFormFieldsValuesMap.entrySet()) {
                    List ddmFormFieldValues = (List)entry.getValue();
                    this._addDDMFormFieldValues(article, (String)entry.getKey(), ddmFormFieldValues, classTypeValues, locale);
                }
                DDMStructure ddmStructure = article.getDDMStructure();
                List ddmTemplates = ddmStructure.getTemplates();
                ddmTemplates.forEach(ddmTemplate -> classTypeValues.put(this._getTemplateKey((DDMTemplate)ddmTemplate), new DDMTemplateContentAccessor(article, (DDMTemplate)ddmTemplate, LocaleUtil.toLanguageId((Locale)locale))));
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return classTypeValues;
    }

    private void _addDDMFormFieldValues(JournalArticle article, String key, List<DDMFormFieldValue> ddmFormFieldValues, Map<String, Object> classTypeValues, Locale locale) throws PortalException {
        Object fieldValue = null;
        if (ddmFormFieldValues.size() == 1) {
            DDMFormFieldValue ddmFormFieldValue2 = ddmFormFieldValues.get(0);
            this._addNestedFields(article, ddmFormFieldValue2, classTypeValues, locale);
            fieldValue = this._sanitizeFieldValue(article, ddmFormFieldValue2, locale);
        } else {
            Stream stream = ddmFormFieldValues.stream();
            fieldValue = stream.map(ddmFormFieldValue -> {
                try {
                    this._addNestedFields(article, (DDMFormFieldValue)ddmFormFieldValue, classTypeValues, locale);
                    return this._sanitizeFieldValue(article, (DDMFormFieldValue)ddmFormFieldValue, locale);
                }
                catch (PortalException pe) {
                    _log.error((Object)("Unable to sanitize field " + ddmFormFieldValue.getName()), (Throwable)pe);
                    return null;
                }
            }).filter(value -> value != null).collect(Collectors.toList());
        }
        classTypeValues.put(key, fieldValue);
    }

    private void _addNestedFields(JournalArticle article, DDMFormFieldValue ddmFormFieldValue, Map<String, Object> classTypeValues, Locale locale) throws PortalException {
        Map nestedDDMFormFieldsValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
        for (Map.Entry entry : nestedDDMFormFieldsValuesMap.entrySet()) {
            List ddmFormFieldValues = (List)entry.getValue();
            this._addDDMFormFieldValues(article, (String)entry.getKey(), ddmFormFieldValues, classTypeValues, locale);
        }
    }

    private String _getTemplateKey(DDMTemplate ddmTemplate) {
        String templateKey = ddmTemplate.getTemplateKey();
        return "ddmTemplate_" + templateKey.replaceAll("\\W", "_");
    }

    private Object _sanitizeFieldValue(JournalArticle article, DDMFormFieldValue ddmFormFieldValue, Locale locale) throws PortalException {
        Value value = ddmFormFieldValue.getValue();
        String valueString = value.getString(locale);
        if (Objects.equals(ddmFormFieldValue.getType(), "ddm-date")) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
                Date date = DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale);
                return dateFormat.format(date);
            }
            catch (Exception e) {
                return valueString;
            }
        }
        if (Objects.equals(ddmFormFieldValue.getType(), "ddm-decimal")) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
            return numberFormat.format(GetterUtil.getDouble((String)valueString));
        }
        if (Objects.equals(ddmFormFieldValue.getType(), "ddm-image")) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            jsonObject.put("url", this._transformFileEntryURL(valueString));
            return jsonObject;
        }
        return SanitizerUtil.sanitize((long)article.getCompanyId(), (long)article.getGroupId(), (long)article.getUserId(), (String)JournalArticle.class.getName(), (long)article.getResourcePrimKey(), (String)"text/html", (String)"ALL", (String)valueString, null);
    }

    private String _transformFileEntryURL(String data) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)data);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull((String)uuid) && groupId == 0L) {
                return "";
            }
            FileEntry fileEntry = this.dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
            return this.dlURLHelper.getDownloadURL(fileEntry, fileEntry.getFileVersion(), null, "");
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return "";
        }
    }

    private class DDMTemplateContentAccessor
    implements ContentAccessor {
        private final JournalArticle _article;
        private final DDMTemplate _ddmTemplate;
        private final String _languageId;

        public DDMTemplateContentAccessor(JournalArticle article, DDMTemplate ddmTemplate, String languageId) {
            this._article = article;
            this._ddmTemplate = ddmTemplate;
            this._languageId = languageId;
        }

        public String getContent() {
            return JournalArticleAssetInfoDisplayContributor.this.journalContent.getContent(this._article.getGroupId(), this._article.getArticleId(), this._ddmTemplate.getTemplateKey(), "view", this._languageId, (ThemeDisplay)null);
        }
    }
}

