/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JournalPreviewArticleContentTemplateDisplayContext {
    private JournalArticleDisplay _articleDisplay;
    private String _articleId;
    private DDMTemplate _ddmTemplate;
    private Long _ddmTemplateId;
    private String _eventName;
    private Long _groupId;
    private String _languageId;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;
    private Double _version;

    public JournalPreviewArticleContentTemplateDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public JournalArticleDisplay getArticleDisplay() throws Exception {
        if (this._articleDisplay != null) {
            return this._articleDisplay;
        }
        JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)this.getGroupId(), (String)this.getArticleId(), (double)this.getVersion());
        if (article == null) {
            return this._articleDisplay;
        }
        String ddmTemplateKey = "";
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmTemplate != null) {
            ddmTemplateKey = ddmTemplate.getTemplateKey();
        }
        int page = ParamUtil.getInteger((PortletRequest)this._renderRequest, (String)"page");
        this._articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)article, (String)ddmTemplateKey, null, (String)this.getLanguageId(), (int)page, (PortletRequestModel)new PortletRequestModel((PortletRequest)this._renderRequest, (PortletResponse)this._renderResponse), (ThemeDisplay)this._themeDisplay);
        return this._articleDisplay;
    }

    public String getArticleId() {
        if (this._articleId != null) {
            return this._articleId;
        }
        this._articleId = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"articleId");
        return this._articleId;
    }

    public DDMTemplate getDDMTemplate() {
        if (this._ddmTemplate != null) {
            return this._ddmTemplate;
        }
        this._ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)this.getDDMTemplateId());
        return this._ddmTemplate;
    }

    public long getDDMTemplateId() {
        if (this._ddmTemplateId != null) {
            return this._ddmTemplateId;
        }
        this._ddmTemplateId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"ddmTemplateId");
        return this._ddmTemplateId;
    }

    public List<DDMTemplate> getDDMTemplates() throws PortalException {
        JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)this.getGroupId(), (String)this.getArticleId(), (double)this.getVersion());
        if (article == null) {
            return Collections.emptyList();
        }
        DDMStructure ddmStructure = article.getDDMStructure();
        if (ddmStructure == null) {
            return Collections.emptyList();
        }
        return DDMTemplateLocalServiceUtil.getTemplates((long)article.getGroupId(), (long)PortalUtil.getClassNameId(DDMStructure.class), (long)ddmStructure.getStructureId(), (boolean)true);
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "preview"));
        return this._eventName;
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"groupId");
        return this._groupId;
    }

    public String getLanguageId() {
        if (this._languageId != null) {
            return this._languageId;
        }
        this._languageId = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"languageId", (String)this._themeDisplay.getLanguageId());
        return this._languageId;
    }

    public PortletURL getPageIteratorPortletURL() throws Exception {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/preview_article_content_template.jsp");
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("articleId", this.getArticleId());
        portletURL.setParameter("version", String.valueOf(this.getVersion()));
        portletURL.setParameter("ddmTemplateId", String.valueOf(this.getDDMTemplateId()));
        portletURL.setParameter("eventName", this.getEventName());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    public PortletURL getPortletURL() throws Exception {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/preview_article_content_template.jsp");
        portletURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        portletURL.setParameter("articleId", this.getArticleId());
        portletURL.setParameter("version", String.valueOf(this.getVersion()));
        portletURL.setParameter("eventName", this.getEventName());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    public Double getVersion() {
        if (this._version != null) {
            return this._version;
        }
        this._version = ParamUtil.getDouble((PortletRequest)this._renderRequest, (String)"version");
        return this._version;
    }
}

