/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.LabelItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.display.context.JournalDisplayContext;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.trash.TrashHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(JournalManagementToolbarDisplayContext.class);
    private final JournalDisplayContext _journalDisplayContext;
    private final JournalWebConfiguration _journalWebConfiguration;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public JournalManagementToolbarDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, JournalDisplayContext journalDisplayContext, TrashHelper trashHelper) throws PortalException {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, journalDisplayContext.getSearchContainer(false));
        this._journalDisplayContext = journalDisplayContext;
        this._trashHelper = trashHelper;
        this._journalWebConfiguration = (JournalWebConfiguration)httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    boolean trashEnabled = JournalManagementToolbarDisplayContext.this._trashHelper.isTrashEnabled(JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId());
                    dropdownItem.setIcon(trashEnabled ? "trash" : "times-circle");
                    String label = "delete";
                    if (trashEnabled) {
                        label = "recycle-bin";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)label));
                    dropdownItem.setQuickAction(true);
                });
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "expireEntries");
                    dropdownItem.setIcon("time");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"expire"));
                    dropdownItem.setQuickAction(true);
                });
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "moveEntries");
                    dropdownItem.setIcon("move-folder");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"move"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getAvailableActions(JournalArticle article) throws PortalException {
        ArrayList<String> availableActions = new ArrayList<String>();
        if (JournalArticlePermission.contains(this._themeDisplay.getPermissionChecker(), article, "DELETE")) {
            availableActions.add("deleteEntries");
        }
        if (JournalArticlePermission.contains(this._themeDisplay.getPermissionChecker(), article, "EXPIRE") && article.getStatus() == 0) {
            availableActions.add("expireEntries");
        }
        if (JournalArticlePermission.contains(this._themeDisplay.getPermissionChecker(), article, "UPDATE")) {
            availableActions.add("moveEntries");
        }
        return StringUtil.merge(availableActions, (String)",");
    }

    public String getAvailableActions(JournalFolder folder) throws PortalException {
        ArrayList<String> availableActions = new ArrayList<String>();
        if (JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), folder, "UPDATE")) {
            availableActions.add("deleteEntries");
        }
        if (JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), folder, "DELETE")) {
            availableActions.add("moveEntries");
        }
        return StringUtil.merge(availableActions, (String)",");
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("navigation", "");
        clearResultsURL.setParameter("ddmStructureKey", "");
        clearResultsURL.setParameter("keywords", "");
        clearResultsURL.setParameter("status", String.valueOf(-1));
        return clearResultsURL.toString();
    }

    public Map<String, Object> getComponentContext() throws Exception {
        HashMap<String, Object> componentContext = new HashMap<String, Object>();
        PortletURL addArticleURL = this.liferayPortletResponse.createRenderURL();
        addArticleURL.setParameter("mvcPath", "/edit_article.jsp");
        addArticleURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        addArticleURL.setParameter("groupId", String.valueOf(this._themeDisplay.getScopeGroupId()));
        addArticleURL.setParameter("folderId", String.valueOf(this._journalDisplayContext.getFolderId()));
        componentContext.put("addArticleURL", addArticleURL.toString());
        componentContext.put("folderId", String.valueOf(0L));
        PortletURL openViewMoreStructuresURL = this.liferayPortletResponse.createRenderURL();
        openViewMoreStructuresURL.setParameter("mvcPath", "/view_more_menu_items.jsp");
        openViewMoreStructuresURL.setParameter("folderId", String.valueOf(this._journalDisplayContext.getFolderId()));
        openViewMoreStructuresURL.setParameter("eventName", this.liferayPortletResponse.getNamespace() + "selectAddMenuItem");
        openViewMoreStructuresURL.setWindowState(LiferayWindowState.POP_UP);
        componentContext.put("openViewMoreStructuresURL", openViewMoreStructuresURL.toString());
        PortletURL selectEntityURL = this.liferayPortletResponse.createRenderURL();
        selectEntityURL.setParameter("mvcPath", "/select_ddm_structure.jsp");
        selectEntityURL.setWindowState(LiferayWindowState.POP_UP);
        componentContext.put("selectEntityURL", selectEntityURL.toString());
        componentContext.put("trashEnabled", this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroupId()));
        PortletURL viewDDMStructureArticlesURL = this.liferayPortletResponse.createRenderURL();
        viewDDMStructureArticlesURL.setParameter("navigation", "structure");
        viewDDMStructureArticlesURL.setParameter("folderId", String.valueOf(0L));
        componentContext.put("viewDDMStructureArticlesURL", viewDDMStructureArticlesURL.toString());
        return componentContext;
    }

    public String getComponentId() {
        return "journalWebManagementToolbar";
    }

    public CreationMenu getCreationMenu() {
        try {
            return this._getCreationMenu();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get creation menu", (Throwable)pe);
            }
            return null;
        }
    }

    public String getDefaultEventHandler() {
        return "journalManagementToolbarDefaultEventHandler";
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalManagementToolbarDisplayContext.this.getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(JournalManagementToolbarDisplayContext.this.getFilterNavigationDropdownItemsLabel());
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalManagementToolbarDisplayContext.this._getFilterStatusDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"filter-by-status"));
                });
                if (!JournalManagementToolbarDisplayContext.this._journalDisplayContext.isNavigationRecent()) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(JournalManagementToolbarDisplayContext.this.getOrderByDropdownItems());
                        dropdownGroupItem.setLabel(JournalManagementToolbarDisplayContext.this.getOrderByDropdownItemsLabel());
                    });
                }
            }
        };
    }

    public List<LabelItem> getFilterLabelItems() {
        return new LabelItemList(){
            {
                int status;
                if (JournalManagementToolbarDisplayContext.this._journalDisplayContext.isNavigationMine()) {
                    this.add(labelItem -> {
                        ThemeDisplay themeDisplay = (ThemeDisplay)JournalManagementToolbarDisplayContext.this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                        User user = themeDisplay.getUser();
                        labelItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"owner") + ": " + user.getFullName());
                    });
                }
                if (JournalManagementToolbarDisplayContext.this._journalDisplayContext.isNavigationRecent()) {
                    this.add(labelItem -> labelItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"recent")));
                }
                if (JournalManagementToolbarDisplayContext.this._journalDisplayContext.isNavigationStructure()) {
                    this.add(labelItem -> labelItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"structures") + ": " + JournalManagementToolbarDisplayContext.this._journalDisplayContext.getDDMStructureName()));
                }
                if ((status = JournalManagementToolbarDisplayContext.this._journalDisplayContext.getStatus()) != JournalManagementToolbarDisplayContext.this._journalDisplayContext.getDefaultStatus()) {
                    this.add(labelItem -> labelItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"status") + ": " + WorkflowConstants.getStatusLabel((int)status)));
                }
            }
        };
    }

    public String getInfoPanelId() {
        return "infoPanelId";
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this.liferayPortletResponse.createRenderURL();
        portletURL.setParameter("folderId", String.valueOf(this._journalDisplayContext.getFolderId()));
        return portletURL.toString();
    }

    public String getSearchContainerId() {
        return "articles";
    }

    public String getSearchFormName() {
        return "fm1";
    }

    public Boolean isDisabled() {
        if (this.getItemsTotal() > 0) {
            return false;
        }
        if (this._journalDisplayContext.isSearch()) {
            return false;
        }
        if (!this._journalDisplayContext.isNavigationHome() || this._journalDisplayContext.getStatus() != -1) {
            return false;
        }
        return true;
    }

    public Boolean isShowCreationMenu() {
        try {
            return this._isShowAddButton();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to get creation menu", (Throwable)pe);
            }
            return false;
        }
    }

    public Boolean isShowInfoButton() {
        return this._journalDisplayContext.isShowInfoButton();
    }

    protected String getDefaultDisplayStyle() {
        return this._journalWebConfiguration.defaultDisplayView();
    }

    protected String[] getDisplayViews() {
        return this._journalDisplayContext.getDisplayViews();
    }

    protected List<DropdownItem> getFilterNavigationDropdownItems() {
        List filterNavigationDropdownItems = super.getFilterNavigationDropdownItems();
        DropdownItem dropdownItem = new DropdownItem();
        dropdownItem.setActive(this._journalDisplayContext.isNavigationStructure());
        dropdownItem.putData("action", "openDDMStructuresSelector");
        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this.request, (String)"structures"));
        filterNavigationDropdownItems.add(dropdownItem);
        return filterNavigationDropdownItems;
    }

    protected String[] getNavigationKeys() {
        return new String[]{"all", "mine", "recent"};
    }

    protected String[] getOrderByKeys() {
        return this._journalDisplayContext.getOrderColumns();
    }

    private CreationMenu _getCreationMenu() throws PortalException {
        return new CreationMenu(){
            {
                if (JournalFolderPermission.contains(JournalManagementToolbarDisplayContext.this._themeDisplay.getPermissionChecker(), JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId(), JournalManagementToolbarDisplayContext.this._journalDisplayContext.getFolderId(), "ADD_FOLDER")) {
                    this.addPrimaryDropdownItem(dropdownItem -> {
                        dropdownItem.setHref(JournalManagementToolbarDisplayContext.this.liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request), "groupId", String.valueOf(JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId()), "parentFolderId", String.valueOf(JournalManagementToolbarDisplayContext.this._journalDisplayContext.getFolderId())});
                        String label = "folder";
                        if (JournalManagementToolbarDisplayContext.this._journalDisplayContext.getFolder() != null) {
                            label = "subfolder";
                        }
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)label));
                    });
                }
                if (JournalFolderPermission.contains(JournalManagementToolbarDisplayContext.this._themeDisplay.getPermissionChecker(), JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId(), JournalManagementToolbarDisplayContext.this._journalDisplayContext.getFolderId(), "ADD_ARTICLE")) {
                    List<DDMStructure> ddmStructures = JournalManagementToolbarDisplayContext.this._journalDisplayContext.getDDMStructures();
                    for (DDMStructure ddmStructure : ddmStructures) {
                        PortletURL portletURL = JournalManagementToolbarDisplayContext.this.liferayPortletResponse.createRenderURL();
                        portletURL.setParameter("mvcPath", "/edit_article.jsp");
                        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request));
                        portletURL.setParameter("groupId", String.valueOf(JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId()));
                        portletURL.setParameter("folderId", String.valueOf(JournalManagementToolbarDisplayContext.this._journalDisplayContext.getFolderId()));
                        portletURL.setParameter("ddmStructureKey", ddmStructure.getStructureKey());
                        UnsafeConsumer unsafeConsumer = dropdownItem -> {
                            dropdownItem.setHref((Object)portletURL);
                            dropdownItem.setLabel(ddmStructure.getUnambiguousName(ddmStructures, JournalManagementToolbarDisplayContext.this._themeDisplay.getScopeGroupId(), JournalManagementToolbarDisplayContext.this._themeDisplay.getLocale()));
                        };
                        if (ArrayUtil.contains((Object[])JournalManagementToolbarDisplayContext.this._journalDisplayContext.getAddMenuFavItems(), (Object)ddmStructure.getStructureKey())) {
                            this.addFavoriteDropdownItem(unsafeConsumer);
                            continue;
                        }
                        this.addRestDropdownItem(unsafeConsumer);
                    }
                }
                this.setHelpText(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)"you-can-customize-this-menu-or-see-all-you-have-by-clicking-more"));
            }
        };
    }

    private List<DropdownItem> _getFilterStatusDropdownItems() {
        return new DropdownItemList(){
            {
                Iterator iterator = JournalManagementToolbarDisplayContext.this._getStatuses().iterator();
                while (iterator.hasNext()) {
                    int status = (Integer)iterator.next();
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(JournalManagementToolbarDisplayContext.this._journalDisplayContext.getStatus() == status);
                        dropdownItem.setHref(JournalManagementToolbarDisplayContext.this.getPortletURL(), new Object[]{"status", String.valueOf(status)});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalManagementToolbarDisplayContext.this.request, (String)WorkflowConstants.getStatusLabel((int)status)));
                    });
                }
            }
        };
    }

    private List<Integer> _getStatuses() {
        ArrayList<Integer> statuses = new ArrayList<Integer>();
        statuses.add(-1);
        statuses.add(2);
        int workflowDefinitionLinksCount = WorkflowDefinitionLinkLocalServiceUtil.getWorkflowDefinitionLinksCount((long)this._themeDisplay.getCompanyId(), (long)this._themeDisplay.getScopeGroupId(), (String)JournalFolder.class.getName());
        if (workflowDefinitionLinksCount > 0) {
            statuses.add(1);
            statuses.add(4);
        }
        statuses.add(7);
        statuses.add(0);
        statuses.add(3);
        return statuses;
    }

    private boolean _isShowAddButton() throws PortalException {
        StagingGroupHelper stagingGroupHelper;
        Group group = this._themeDisplay.getScopeGroup();
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if (((stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper()).isLocalLiveGroup(group) || stagingGroupHelper.isRemoteLiveGroup(group)) && stagingGroupHelper.isStagedPortlet(group, "com_liferay_journal_web_portlet_JournalPortlet")) {
            return false;
        }
        return JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroupId(), this._journalDisplayContext.getFolderId(), "ADD_FOLDER") || JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), this._themeDisplay.getScopeGroupId(), this._journalDisplayContext.getFolderId(), "ADD_ARTICLE");
    }
}

