/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.display.context.SearchContainerManagementToolbarDisplayContext;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.internal.display.context.JournalHistoryDisplayContext;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalHistoryManagementToolbarDisplayContext
extends SearchContainerManagementToolbarDisplayContext {
    private final JournalArticle _article;

    public JournalHistoryManagementToolbarDisplayContext(JournalArticle article, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, HttpServletRequest httpServletRequest, JournalHistoryDisplayContext journalHistoryDisplayContext) {
        super(liferayPortletRequest, liferayPortletResponse, httpServletRequest, journalHistoryDisplayContext.getArticleSearchContainer());
        this._article = article;
    }

    public List<DropdownItem> getActionDropdownItems() {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new DropdownItemList(){
            {
                try {
                    if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), JournalHistoryManagementToolbarDisplayContext.this._article, "DELETE")) {
                        PortletURL deleteArticlesURL = JournalHistoryManagementToolbarDisplayContext.this.liferayPortletResponse.createActionURL();
                        deleteArticlesURL.setParameter("javax.portlet.action", "deleteArticles");
                        deleteArticlesURL.setParameter("redirect", themeDisplay.getURLCurrent());
                        this.add(dropdownItem -> {
                            dropdownItem.putData("action", "deleteArticles");
                            dropdownItem.putData("deleteArticlesURL", deleteArticlesURL.toString());
                            dropdownItem.setIcon("trash");
                            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryManagementToolbarDisplayContext.this.request, (String)"delete"));
                            dropdownItem.setQuickAction(true);
                        });
                    }
                }
                catch (Exception deleteArticlesURL) {
                    // empty catch block
                }
                try {
                    if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), JournalHistoryManagementToolbarDisplayContext.this._article, "EXPIRE")) {
                        PortletURL expireArticlesURL = JournalHistoryManagementToolbarDisplayContext.this.liferayPortletResponse.createActionURL();
                        expireArticlesURL.setParameter("javax.portlet.action", "expireArticles");
                        expireArticlesURL.setParameter("redirect", themeDisplay.getURLCurrent());
                        this.add(dropdownItem -> {
                            dropdownItem.putData("action", "expireArticles");
                            dropdownItem.putData("expireArticlesURL", expireArticlesURL.toString());
                            dropdownItem.setIcon("time");
                            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryManagementToolbarDisplayContext.this.request, (String)"expire"));
                            dropdownItem.setQuickAction(true);
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public String getAvailableActions(JournalArticle article) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<String> availableActions = new ArrayList<String>();
        if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), article, "DELETE")) {
            availableActions.add("deleteArticles");
        }
        if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), article, "EXPIRE") && article.getStatus() == 0) {
            availableActions.add("expireArticles");
        }
        return StringUtil.merge(availableActions, (String)",");
    }

    public String getComponentId() {
        return "journalHistoryManagementToolbar";
    }

    public String getDefaultEventHandler() {
        return "journalArticleHistoryManagementToolbarDefaultEventHandler";
    }

    public String getSearchContainerId() {
        return "articleVersions";
    }

    protected String[] getDisplayViews() {
        return new String[]{"list", "descriptive", "icon"};
    }

    protected String[] getNavigationKeys() {
        return new String[]{"all"};
    }

    protected String[] getOrderByKeys() {
        return new String[]{"version", "display-date", "modified-date"};
    }
}

