/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.journal.web.internal.search.FeedSearch;
import com.liferay.journal.web.internal.search.FeedSearchTerms;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class JournalFeedsDisplayContext {
    private String _displayStyle;
    private FeedSearch _feedSearch;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public JournalFeedsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public SearchContainer getFeedsSearchContainer() {
        if (this._feedSearch != null) {
            return this._feedSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._feedSearch = new FeedSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        this._feedSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        FeedSearchTerms searchTerms = (FeedSearchTerms)this._feedSearch.getSearchTerms();
        int feedsCount = JournalFeedLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)searchTerms.getGroupId(), (String)searchTerms.getKeywords());
        this._feedSearch.setTotal(feedsCount);
        List feeds = JournalFeedLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)searchTerms.getGroupId(), (String)searchTerms.getKeywords(), (int)this._feedSearch.getStart(), (int)this._feedSearch.getEnd(), (OrderByComparator)this._feedSearch.getOrderByComparator());
        this._feedSearch.setResults(feeds);
        return this._feedSearch;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_feeds.jsp");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect");
        return this._redirect;
    }
}

