/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMTemplateHelper;
import com.liferay.journal.configuration.JournalFileUploadsConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.util.JournalChangeTrackingHelperUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.template.TemplateVariableGroup;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.TemplateContextHelper;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class JournalEditDDMTemplateDisplayContext {
    private Boolean _cacheable;
    private Long _classPK;
    private DDMStructure _ddmStructure;
    private DDMTemplate _ddmTemplate;
    private final DDMTemplateHelper _ddmTemplateHelper;
    private Long _ddmTemplateId;
    private Long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private final JournalFileUploadsConfiguration _journalFileUploadsConfiguration;
    private final JournalWebConfiguration _journalWebConfiguration;
    private String _language;
    private String _redirect;
    private String _script;
    private Boolean _smallImage;
    private String _smallImageSource;

    public JournalEditDDMTemplateDisplayContext(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
        this._ddmTemplateHelper = (DDMTemplateHelper)this._httpServletRequest.getAttribute(DDMTemplateHelper.class.getName());
        this._journalFileUploadsConfiguration = (JournalFileUploadsConfiguration)this._httpServletRequest.getAttribute(JournalFileUploadsConfiguration.class.getName());
        this._journalWebConfiguration = (JournalWebConfiguration)this._httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
    }

    public boolean autogenerateDDMTemplateKey() {
        return this._journalWebConfiguration.autogenerateDDMTemplateKey();
    }

    public String getAutocompleteJSON() throws Exception {
        return this._ddmTemplateHelper.getAutocompleteJSON(this._httpServletRequest, this.getLanguage());
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = BeanParamUtil.getLong((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"classPK");
        return this._classPK;
    }

    public DDMStructure getDDMStructure() {
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)this.getClassPK());
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmTemplate != null) {
            this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)ddmTemplate.getClassPK());
        }
        return this._ddmStructure;
    }

    public DDMTemplate getDDMTemplate() {
        if (this._ddmTemplate != null) {
            return this._ddmTemplate;
        }
        this._ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)this.getDDMTemplateId());
        return this._ddmTemplate;
    }

    public long getDDMTemplateId() {
        if (this._ddmTemplateId != null) {
            return this._ddmTemplateId;
        }
        this._ddmTemplateId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"ddmTemplateId");
        return this._ddmTemplateId;
    }

    public String getEditorMode() {
        if (Objects.equals(this.getLanguage(), "ftl")) {
            return "ftl";
        }
        if (Objects.equals(this.getLanguage(), "xsl")) {
            return "xml";
        }
        return "velocity";
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._groupId = BeanParamUtil.getLong((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        return this._groupId;
    }

    public String getLanguage() {
        if (this._language != null) {
            return this._language;
        }
        this._language = BeanParamUtil.getString((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"language", (String)"ftl");
        return this._language;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        return this._redirect;
    }

    public String getSaveButtonLabel() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (JournalChangeTrackingHelperUtil.hasActiveCTCollection(themeDisplay.getCompanyId(), themeDisplay.getUserId())) {
            return "publish-to-change-list";
        }
        return "save";
    }

    public String getScript() {
        String scriptContent;
        if (this._script != null) {
            return this._script;
        }
        this._language = BeanParamUtil.getString((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"language", (String)"ftl");
        this._script = BeanParamUtil.getString((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"script");
        if (Validator.isNull((String)this._script)) {
            TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)PortalUtil.getClassNameId(JournalArticle.class));
            this._script = templateHandler.getTemplatesHelpContent(this._language);
        }
        if (Validator.isNotNull((String)(scriptContent = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"scriptContent")))) {
            this._script = scriptContent;
        }
        return this._script;
    }

    public String getSmallImageSource() {
        if (Validator.isNotNull((String)this._smallImageSource)) {
            return this._smallImageSource;
        }
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmTemplate == null) {
            this._smallImageSource = "none";
            return this._smallImageSource;
        }
        this._smallImageSource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"smallImageSource");
        if (Validator.isNotNull((String)this._smallImageSource)) {
            return this._smallImageSource;
        }
        if (!ddmTemplate.isSmallImage()) {
            this._smallImageSource = "none";
        } else if (Validator.isNotNull((String)ddmTemplate.getSmallImageURL())) {
            this._smallImageSource = "url";
        } else if (ddmTemplate.getSmallImageId() > 0L && Validator.isNull((String)ddmTemplate.getSmallImageURL())) {
            this._smallImageSource = "file";
        }
        return this._smallImageSource;
    }

    public ResourceBundle getTemplateHandlerResourceBundle() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((long)PortalUtil.getClassNameId(JournalArticle.class));
        Class<?> clazz = this.getClass();
        if (templateHandler != null) {
            clazz = templateHandler.getClass();
        }
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)bundle.getSymbolicName());
        return resourceBundleLoader.loadResourceBundle(themeDisplay.getLocale());
    }

    public Collection<TemplateVariableGroup> getTemplateVariableGroups() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Map templateVariableGroups = TemplateContextHelper.getTemplateVariableGroups((long)PortalUtil.getClassNameId(JournalArticle.class), (long)this.getClassPK(), (String)this.getLanguage(), (Locale)themeDisplay.getLocale());
        return templateVariableGroups.values();
    }

    public String getTitle() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMStructure ddmStructure = this.getDDMStructure();
        DDMTemplate ddmTemplate = this.getDDMTemplate();
        if (ddmStructure != null && ddmTemplate != null) {
            return StringUtil.appendParentheticalSuffix((String)ddmTemplate.getName(themeDisplay.getLocale()), (String)ddmStructure.getName(themeDisplay.getLocale()));
        }
        if (ddmStructure != null) {
            return LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"new-template-for-structure-x", (Object)ddmStructure.getName(themeDisplay.getLocale()), (boolean)false);
        }
        if (ddmTemplate != null) {
            return ddmTemplate.getName(themeDisplay.getLocale());
        }
        return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"new-template");
    }

    public String[] imageExtensions() {
        return this._journalFileUploadsConfiguration.imageExtensions();
    }

    public boolean isAutocompleteEnabled() {
        return this._ddmTemplateHelper.isAutocompleteEnabled(this.getLanguage());
    }

    public boolean isCacheable() {
        if (this._cacheable != null) {
            return this._cacheable;
        }
        this._cacheable = BeanParamUtil.getBoolean((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"cacheable", (boolean)true);
        return this._cacheable;
    }

    public boolean isSmallImage() {
        if (this._smallImage != null) {
            return this._smallImage;
        }
        this._smallImage = BeanParamUtil.getBoolean((Object)this.getDDMTemplate(), (HttpServletRequest)this._httpServletRequest, (String)"smallImage");
        return this._smallImage;
    }

    public long smallImageMaxSize() {
        return this._journalFileUploadsConfiguration.smallImageMaxSize();
    }
}

