/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.util.JournalChangeTrackingHelperUtil;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class JournalEditDDMStructuresDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(JournalEditDDMStructuresDisplayContext.class);
    private DDMStructure _ddmStructure;
    private Long _ddmStructureId;
    private final HttpServletRequest _httpServletRequest;
    private final JournalWebConfiguration _journalWebConfiguration;
    private Long _parentDDMStructureId;
    private String _parentDDMStructureName;
    private String _script;

    public JournalEditDDMStructuresDisplayContext(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
        this._journalWebConfiguration = (JournalWebConfiguration)httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
    }

    public boolean autogenerateDDMStructureKey() {
        return this._journalWebConfiguration.autogenerateDDMStructureKey();
    }

    public boolean changeableDefaultLanguage() {
        return this._journalWebConfiguration.changeableDefaultLanguage();
    }

    public String getAvailableFields() {
        return "Liferay.FormBuilder.AVAILABLE_FIELDS.WCM_STRUCTURE";
    }

    public Locale[] getAvailableLocales() {
        DDMForm ddmForm = this.getDDMForm();
        if (ddmForm == null) {
            return new Locale[]{LocaleUtil.getSiteDefault()};
        }
        Set ddmFormAvailableLocales = ddmForm.getAvailableLocales();
        return ddmFormAvailableLocales.toArray(new Locale[0]);
    }

    public String getAvailableLocalesJSONArrayString() {
        JSONArray availableLocalesJSONArray = JSONFactoryUtil.createJSONArray();
        for (Locale availableLocale : this.getAvailableLocales()) {
            availableLocalesJSONArray.put(LanguageUtil.getLanguageId((Locale)availableLocale));
        }
        if (availableLocalesJSONArray.length() > 0) {
            return availableLocalesJSONArray.toString();
        }
        return "";
    }

    public DDMForm getDDMForm() {
        try {
            return DDMUtil.getDDMForm((String)this.getScript());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public DDMStructure getDDMStructure() {
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)this.getDDMStructureId());
        return this._ddmStructure;
    }

    public long getDDMStructureId() {
        if (this._ddmStructureId != null) {
            return this._ddmStructureId;
        }
        this._ddmStructureId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"ddmStructureId");
        return this._ddmStructureId;
    }

    public String getFields() throws PortalException {
        DDMStructure ddmStructure = this.getDDMStructure();
        if (ddmStructure == null) {
            return "";
        }
        JSONArray fieldsJSONArray = DDMUtil.getDDMFormFieldsJSONArray((DDMStructureVersion)ddmStructure.getLatestStructureVersion(), (String)this.getScript());
        if (fieldsJSONArray != null) {
            return fieldsJSONArray.toString();
        }
        return "";
    }

    public String getLocalesMap() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject localesMapJSONObject = JSONFactoryUtil.createJSONObject();
        for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)themeDisplay.getSiteGroupId())) {
            localesMapJSONObject.put(LocaleUtil.toLanguageId((Locale)availableLocale), availableLocale.getDisplayName(themeDisplay.getLocale()));
        }
        return localesMapJSONObject.toString();
    }

    public long getParentDDMStructureId() {
        if (this._parentDDMStructureId != null) {
            return this._parentDDMStructureId;
        }
        long defaultParentDDMStructureId = 0L;
        DDMStructure ddmStructure = this.getDDMStructure();
        if (ddmStructure != null) {
            defaultParentDDMStructureId = ddmStructure.getParentStructureId();
        }
        this._parentDDMStructureId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentDDMStructureId", (long)defaultParentDDMStructureId);
        return this._parentDDMStructureId;
    }

    public String getParentDDMStructureName() {
        if (this._parentDDMStructureName != null) {
            return this._parentDDMStructureName;
        }
        DDMStructure parentDDMStructure = DDMStructureLocalServiceUtil.fetchStructure((long)this.getParentDDMStructureId());
        if (parentDDMStructure != null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._parentDDMStructureName = parentDDMStructure.getName(themeDisplay.getLocale());
        }
        return this._parentDDMStructureName;
    }

    public String getSaveButtonLabel() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (JournalChangeTrackingHelperUtil.hasActiveCTCollection(themeDisplay.getCompanyId(), themeDisplay.getUserId())) {
            return "publish-to-change-list";
        }
        return "save";
    }

    public String getScript() throws PortalException {
        if (this._script != null) {
            DDMStructure ddmStructure = this.getDDMStructure();
            this._script = BeanParamUtil.getString((Object)ddmStructure.getLatestStructureVersion(), (HttpServletRequest)this._httpServletRequest, (String)"definition");
            return this._script;
        }
        this._script = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"definition");
        return this._script;
    }

    public String getStorageType() {
        String storageType = StorageType.JSON.getValue();
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
            storageType = journalServiceConfiguration.journalArticleStorageType();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return storageType;
    }
}

