/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.journal.web.internal.util.JournalChangeTrackingHelperUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalEditArticleDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(JournalEditArticleDisplayContext.class);
    private JournalArticle _article;
    private String _articleId;
    private Set<Locale> _availableLocales;
    private Boolean _changeStructure;
    private Long _classNameId;
    private Long _classPK;
    private DDMFormValues _ddmFormValues;
    private DDMStructure _ddmStructure;
    private String _ddmStructureKey;
    private DDMTemplate _ddmTemplate;
    private String _ddmTemplateKey;
    private String _defaultLanguageId;
    private Long _folderId;
    private Long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private Long _inheritedWorkflowDDMStructuresFolderId;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Boolean _neverExpire;
    private Boolean _neverReview;
    private String _portletResource;
    private String _redirect;
    private Long _refererPlid;
    private String _referringPortletResource;
    private Boolean _showHeader;
    private String _smallImageSource;
    private final ThemeDisplay _themeDisplay;
    private Double _version;

    public JournalEditArticleDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletResponse liferayPortletResponse, JournalArticle article) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._article = article;
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._setViewAttributes();
    }

    public String getArticleId() {
        if (this._articleId != null) {
            return this._articleId;
        }
        this._articleId = BeanParamUtil.getString((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"articleId");
        return this._articleId;
    }

    public Set<Locale> getAvailableLocales() {
        if (this._availableLocales != null) {
            return this._availableLocales;
        }
        this._availableLocales = LanguageUtil.getAvailableLocales((long)this.getGroupId());
        return this._availableLocales;
    }

    public Map<String, Object> getChangeDefaultLanguageSoyContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("defaultLanguage", this.getDefaultArticleLanguageId());
        LinkedHashSet<String> uniqueLanguageIds = new LinkedHashSet<String>();
        uniqueLanguageIds.add(this.getDefaultLanguageId());
        HashMap<String, String> strings = new HashMap<String, String>();
        strings.put("change", LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"change", (Object)"content"));
        strings.put("default", LanguageUtil.format((HttpServletRequest)this._httpServletRequest, (String)"default", (Object)"content"));
        for (Locale availableLocale : this.getAvailableLocales()) {
            String curLanguageId = LocaleUtil.toLanguageId((Locale)availableLocale);
            strings.put(curLanguageId, StringBundler.concat((String[])new String[]{availableLocale.getDisplayLanguage(), " ", "(", availableLocale.getCountry(), ")"}));
            uniqueLanguageIds.add(curLanguageId);
        }
        ArrayList languages = new ArrayList();
        for (String curLanguageId : uniqueLanguageIds) {
            HashMap<String, Object> language = new HashMap<String, Object>();
            language.put("checked", Objects.equals(this.getDefaultLanguageId(), curLanguageId));
            language.put("icon", StringUtil.toLowerCase((String)StringUtil.replace((String)curLanguageId, (char)'_', (char)'-')));
            language.put("label", curLanguageId);
            languages.add(language);
        }
        context.put("languages", languages);
        context.put("namespace", this._liferayPortletResponse.getNamespace());
        context.put("spritemap", this._themeDisplay.getPathThemeImages() + "/lexicon/icons.svg");
        context.put("strings", strings);
        return context;
    }

    public long getClassNameId() {
        if (this._classNameId != null) {
            return this._classNameId;
        }
        this._classNameId = BeanParamUtil.getLong((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"classNameId");
        return this._classNameId;
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = BeanParamUtil.getLong((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"classPK");
        return this._classPK;
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure) throws PortalException {
        if (this._ddmFormValues != null) {
            return this._ddmFormValues;
        }
        if (this._article == null) {
            return this._ddmFormValues;
        }
        String content = this._article.getContent();
        if (Validator.isNull((String)content)) {
            return this._ddmFormValues;
        }
        JournalConverter journalConverter = this._getJournalConverter();
        Fields fields = journalConverter.getDDMFields(ddmStructure, content);
        if (fields == null) {
            return this._ddmFormValues;
        }
        this._ddmFormValues = journalConverter.getDDMFormValues(ddmStructure, fields);
        return this._ddmFormValues;
    }

    public DDMStructure getDDMStructure() {
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        long ddmStructureId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"ddmStructureId");
        if (ddmStructureId > 0L) {
            this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)ddmStructureId);
        } else if (Validator.isNotNull((String)this.getDDMStructureKey())) {
            long groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)this._themeDisplay.getSiteGroupId());
            if (this._article != null) {
                groupId = this._article.getGroupId();
            }
            this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)groupId, (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
        }
        return this._ddmStructure;
    }

    public long getDDMStructureId() {
        DDMStructure ddmStructure = this.getDDMStructure();
        return ddmStructure.getStructureId();
    }

    public String getDDMStructureKey() {
        if (this._ddmStructureKey != null) {
            return this._ddmStructureKey;
        }
        this._ddmStructureKey = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"ddmStructureKey");
        if (Validator.isNull((String)this._ddmStructureKey) && this._article != null) {
            this._ddmStructureKey = this._article.getDDMStructureKey();
        }
        return this._ddmStructureKey;
    }

    public DDMTemplate getDDMTemplate() {
        if (this._ddmTemplate != null) {
            return this._ddmTemplate;
        }
        long ddmTemplateId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"ddmTemplateId");
        if (ddmTemplateId == -1L) {
            return null;
        }
        if (ddmTemplateId > 0L) {
            this._ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)ddmTemplateId);
            return this._ddmTemplate;
        }
        if (Validator.isNotNull((String)this.getDDMTemplateKey())) {
            long groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)this._themeDisplay.getSiteGroupId());
            if (this._article != null) {
                groupId = this._article.getGroupId();
            }
            this._ddmTemplate = DDMTemplateLocalServiceUtil.fetchTemplate((long)groupId, (long)PortalUtil.getClassNameId(DDMStructure.class), (String)this.getDDMTemplateKey(), (boolean)true);
            return this._ddmTemplate;
        }
        return null;
    }

    public String getDDMTemplateKey() {
        if (this._ddmTemplateKey != null) {
            return this._ddmTemplateKey;
        }
        this._ddmTemplateKey = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"ddmTemplateKey");
        if (Validator.isNull((String)this._ddmTemplateKey) && this._article != null && Objects.equals(this._article.getDDMStructureKey(), this.getDDMStructureKey())) {
            this._ddmTemplateKey = this._article.getDDMTemplateKey();
        }
        return this._ddmTemplateKey;
    }

    public String getDefaultArticleLanguageId() {
        Locale siteDefaultLocale = null;
        try {
            siteDefaultLocale = PortalUtil.getSiteDefaultLocale((long)this.getGroupId());
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            siteDefaultLocale = LocaleUtil.getSiteDefault();
        }
        if (this._article == null) {
            return LocaleUtil.toLanguageId((Locale)siteDefaultLocale);
        }
        return LocalizationUtil.getDefaultLanguageId((String)this._article.getContent(), (Locale)siteDefaultLocale);
    }

    public String getDefaultLanguageId() {
        if (Validator.isNotNull((String)this._defaultLanguageId)) {
            return this._defaultLanguageId;
        }
        this._defaultLanguageId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"languageId");
        if (Validator.isNotNull((String)this._defaultLanguageId)) {
            return this._defaultLanguageId;
        }
        this._defaultLanguageId = this.getDefaultArticleLanguageId();
        return this._defaultLanguageId;
    }

    public String getEditArticleURL() {
        PortletURL editArticleURL = this._liferayPortletResponse.createRenderURL();
        editArticleURL.setParameter("redirect", this.getRedirect());
        editArticleURL.setParameter("mvcPath", "/edit_article.jsp");
        editArticleURL.setParameter("groupId", String.valueOf(this.getGroupId()));
        editArticleURL.setParameter("articleId", this.getArticleId());
        editArticleURL.setParameter("version", String.valueOf(this.getVersion()));
        return editArticleURL.toString();
    }

    public long getFolderId() {
        if (this._folderId != null) {
            return this._folderId;
        }
        this._folderId = BeanParamUtil.getLong((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"folderId", (long)0L);
        return this._folderId;
    }

    public String getFriendlyURLBase() {
        Layout layout;
        StringBundler sb = new StringBundler(4);
        sb.append(this._themeDisplay.getPortalURL());
        Group group = this._themeDisplay.getScopeGroup();
        boolean privateLayout = false;
        if (this._article != null && (layout = this._article.getLayout()) != null) {
            privateLayout = layout.isPrivateLayout();
        }
        if (privateLayout) {
            sb.append(PortalUtil.getPathFriendlyURLPrivateGroup());
        } else {
            sb.append(PortalUtil.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append("/-/");
        return sb.toString();
    }

    public long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        this._groupId = BeanParamUtil.getLong((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"groupId", (long)this._themeDisplay.getScopeGroupId());
        return this._groupId;
    }

    public String getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"portletResource");
        return this._portletResource;
    }

    public String getPublishButtonLabel() throws PortalException {
        if (JournalChangeTrackingHelperUtil.hasActiveCTCollection(this._themeDisplay.getCompanyId(), this._themeDisplay.getUserId())) {
            return "publish-to-change-list";
        }
        if (this.getClassNameId() > 0L) {
            return "save";
        }
        if (this._isWorkflowEnabled()) {
            return "submit-for-publication";
        }
        return "publish";
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        return this._redirect;
    }

    public long getRefererPlid() {
        if (this._refererPlid != null) {
            return this._refererPlid;
        }
        this._refererPlid = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"refererPlid");
        return this._refererPlid;
    }

    public String getReferringPortletResource() {
        if (this._referringPortletResource != null) {
            return this._referringPortletResource;
        }
        this._referringPortletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"referringPortletResource");
        return this._referringPortletResource;
    }

    public String getSaveButtonLabel() {
        if (this._article == null || this._article.isApproved() || this._article.isDraft() || this._article.isExpired() || this._article.isScheduled()) {
            return "save-as-draft";
        }
        return "save";
    }

    public String getSmallImageSource() {
        if (Validator.isNotNull((String)this._smallImageSource)) {
            return this._smallImageSource;
        }
        if (this._article == null) {
            this._smallImageSource = "none";
            return this._smallImageSource;
        }
        this._smallImageSource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"smallImageSource");
        if (Validator.isNotNull((String)this._smallImageSource)) {
            return this._smallImageSource;
        }
        if (!this._article.getSmallImage()) {
            this._smallImageSource = "none";
        } else if (Validator.isNotNull((String)this._article.getSmallImageURL())) {
            this._smallImageSource = "url";
        } else if (this._article.getSmallImageId() > 0L && Validator.isNull((String)this._article.getSmallImageURL())) {
            this._smallImageSource = "file";
        }
        return this._smallImageSource;
    }

    public double getVersion() {
        if (this._version != null) {
            return this._version;
        }
        this._version = BeanParamUtil.getDouble((Object)this._article, (HttpServletRequest)this._httpServletRequest, (String)"version", (double)1.0);
        return this._version;
    }

    public boolean hasSavePermission() throws PortalException {
        if (this._article != null && !this._article.isNew()) {
            return JournalArticlePermission.contains(this._themeDisplay.getPermissionChecker(), this._article, "UPDATE");
        }
        return JournalFolderPermission.contains(this._themeDisplay.getPermissionChecker(), this.getGroupId(), this.getFolderId(), "ADD_ARTICLE");
    }

    public boolean isApproved() {
        if (this._article != null && this.getVersion() > 0.0) {
            return this._article.isApproved();
        }
        return false;
    }

    public boolean isChangeStructure() {
        if (this._changeStructure != null) {
            return this._changeStructure;
        }
        this._changeStructure = GetterUtil.getBoolean((String)ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"changeStructure"));
        return this._changeStructure;
    }

    public boolean isNeverExpire() {
        if (this._neverExpire != null) {
            return this._neverExpire;
        }
        this._neverExpire = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"neverExpire", (boolean)true);
        if (this._article != null && this._article.getExpirationDate() != null) {
            this._neverExpire = false;
        }
        return this._neverExpire;
    }

    public boolean isNeverReview() {
        if (this._neverReview != null) {
            return this._neverReview;
        }
        this._neverReview = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"neverReview", (boolean)true);
        if (this._article != null && this._article.getReviewDate() != null) {
            this._neverReview = false;
        }
        return this._neverReview;
    }

    public boolean isPending() throws PortalException {
        if (this._article != null && this.getVersion() > 0.0 && this._isWorkflowEnabled()) {
            return this._article.isPending();
        }
        return false;
    }

    private long _getInheritedWorkflowDDMStructuresFolderId() throws PortalException {
        if (this._inheritedWorkflowDDMStructuresFolderId != null) {
            return this._inheritedWorkflowDDMStructuresFolderId;
        }
        this._inheritedWorkflowDDMStructuresFolderId = JournalFolderLocalServiceUtil.getInheritedWorkflowFolderId((long)this.getFolderId());
        return this._inheritedWorkflowDDMStructuresFolderId;
    }

    private JournalConverter _getJournalConverter() {
        return (JournalConverter)this._httpServletRequest.getAttribute("JOURNAL_CONVERTER");
    }

    private String _getTitle() {
        if (this.getClassNameId() > 0L) {
            return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"structure-default-values");
        }
        if (this._article != null && !this._article.isNew()) {
            return this._article.getTitle(this._themeDisplay.getLocale());
        }
        return LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"new-web-content");
    }

    private boolean _hasInheritedWorkflowDefinitionLink() throws PortalException {
        if (this._getInheritedWorkflowDDMStructuresFolderId() <= 0L) {
            return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this._themeDisplay.getCompanyId(), (long)this.getGroupId(), (String)JournalArticle.class.getName());
        }
        JournalFolder inheritedWorkflowDDMStructuresFolder = JournalFolderLocalServiceUtil.getFolder((long)this._getInheritedWorkflowDDMStructuresFolderId());
        return inheritedWorkflowDDMStructuresFolder.getRestrictionType() == 0;
    }

    private boolean _isShowHeader() {
        if (this._showHeader != null) {
            return this._showHeader;
        }
        this._showHeader = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"showHeader", (boolean)true);
        return this._showHeader;
    }

    private boolean _isWorkflowEnabled() throws PortalException {
        if (this._hasInheritedWorkflowDefinitionLink()) {
            return true;
        }
        DDMStructure ddmStructure = this.getDDMStructure();
        if (WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this._themeDisplay.getCompanyId(), (long)this.getGroupId(), (String)JournalFolder.class.getName(), (long)this.getFolderId(), (long)ddmStructure.getStructureId())) {
            return true;
        }
        if (WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this._themeDisplay.getCompanyId(), (long)this.getGroupId(), (String)JournalFolder.class.getName(), (long)this._getInheritedWorkflowDDMStructuresFolderId(), (long)ddmStructure.getStructureId())) {
            return true;
        }
        return WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this._themeDisplay.getCompanyId(), (long)this.getGroupId(), (String)JournalFolder.class.getName(), (long)this._getInheritedWorkflowDDMStructuresFolderId(), (long)-1L);
    }

    private void _setViewAttributes() {
        if (!this._isShowHeader()) {
            return;
        }
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        portletDisplay.setShowBackIcon(true);
        if (Validator.isNotNull((String)this.getRedirect())) {
            portletDisplay.setURLBack(this.getRedirect());
        } else if (this.getClassNameId() == 0L && this._article != null) {
            PortletURL backURL = this._liferayPortletResponse.createRenderURL();
            backURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
            backURL.setParameter("folderId", String.valueOf(this._article.getFolderId()));
            portletDisplay.setURLBack(backURL.toString());
        }
        if (this._liferayPortletResponse instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)this._liferayPortletResponse;
            renderResponse.setTitle(this._getTitle());
        }
    }
}

