/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.service.JournalFolderServiceUtil;
import com.liferay.journal.util.comparator.FolderArticleArticleIdComparator;
import com.liferay.journal.util.comparator.FolderArticleDisplayDateComparator;
import com.liferay.journal.util.comparator.FolderArticleModifiedDateComparator;
import com.liferay.journal.util.comparator.FolderArticleTitleComparator;
import com.liferay.journal.web.asset.model.JournalArticleAssetRenderer;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.portlet.action.ActionUtil;
import com.liferay.journal.web.internal.search.EntriesChecker;
import com.liferay.journal.web.internal.search.EntriesMover;
import com.liferay.journal.web.internal.search.JournalSearcher;
import com.liferay.journal.web.internal.servlet.taglib.util.JournalArticleActionDropdownItemsProvider;
import com.liferay.journal.web.internal.servlet.taglib.util.JournalFolderActionDropdownItems;
import com.liferay.journal.web.internal.util.JournalChangeTrackingHelperUtil;
import com.liferay.journal.web.util.JournalPortletUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.RowMover;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalDisplayContext {
    private String[] _addMenuFavItems;
    private JournalArticle _article;
    private JournalArticleDisplay _articleDisplay;
    private SearchContainer _articleSearchContainer;
    private final AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private String _ddmStructureKey;
    private String _ddmStructureName;
    private List<DDMStructure> _ddmStructures;
    private String _displayStyle;
    private JournalFolder _folder;
    private Long _folderId;
    private final HttpServletRequest _httpServletRequest;
    private final JournalWebConfiguration _journalWebConfiguration;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private Long _parentFolderId;
    private final PortalPreferences _portalPreferences;
    private Integer _restrictionType;
    private Integer _status;
    private String _tabs1;
    private final ThemeDisplay _themeDisplay;
    private final TrashHelper _trashHelper;

    public JournalDisplayContext(HttpServletRequest httpServletRequest, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider, TrashHelper trashHelper) {
        this._httpServletRequest = httpServletRequest;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
        this._trashHelper = trashHelper;
        this._journalWebConfiguration = (JournalWebConfiguration)this._httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._httpServletRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String[] getAddMenuFavItems() throws PortalException {
        if (this._addMenuFavItems != null) {
            return this._addMenuFavItems;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._httpServletRequest);
        String key = JournalPortletUtil.getAddMenuFavItemKey((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        ArrayList<String> addMenuFavItemsList = new ArrayList<String>();
        Object[] addMenuFavItems = portalPreferences.getValues("com_liferay_journal_web_portlet_JournalPortlet", key, new String[0]);
        for (DDMStructure ddmStructure : this.getDDMStructures()) {
            if (!ArrayUtil.contains((Object[])addMenuFavItems, (Object)ddmStructure.getStructureKey())) continue;
            addMenuFavItemsList.add(ddmStructure.getStructureKey());
        }
        this._addMenuFavItems = ArrayUtil.toStringArray(addMenuFavItemsList);
        return this._addMenuFavItems;
    }

    public int getAddMenuFavItemsLength() throws PortalException {
        String[] addMenuFavItems = this.getAddMenuFavItems();
        return addMenuFavItems.length;
    }

    public JournalArticle getArticle() throws PortalException {
        if (this._article != null) {
            return this._article;
        }
        this._article = ActionUtil.getArticle(this._httpServletRequest);
        return this._article;
    }

    public List<DropdownItem> getArticleActionDropdownItems(JournalArticle article) throws Exception {
        JournalArticleActionDropdownItemsProvider articleActionDropdownItemsProvider = new JournalArticleActionDropdownItemsProvider(article, this._liferayPortletRequest, this._liferayPortletResponse, this._assetDisplayPageFriendlyURLProvider, this._trashHelper);
        return articleActionDropdownItemsProvider.getActionDropdownItems();
    }

    public JournalArticleDisplay getArticleDisplay() throws Exception {
        double version;
        String articleId;
        if (this._articleDisplay != null) {
            return this._articleDisplay;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId");
        JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)(articleId = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"articleId")), (double)(version = ParamUtil.getDouble((HttpServletRequest)this._httpServletRequest, (String)"version")));
        if (article == null) {
            return this._articleDisplay;
        }
        int page = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"page");
        this._articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)article, (String)article.getDDMTemplateKey(), null, (String)this._themeDisplay.getLanguageId(), (int)page, (PortletRequestModel)new PortletRequestModel((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse), (ThemeDisplay)this._themeDisplay);
        return this._articleDisplay;
    }

    public List<DropdownItem> getArticleHistoryActionDropdownItems(JournalArticle article) throws Exception {
        JournalArticleActionDropdownItemsProvider articleActionDropdownItemsProvider = new JournalArticleActionDropdownItemsProvider(article, this._liferayPortletRequest, this._liferayPortletResponse, this._assetDisplayPageFriendlyURLProvider, this._trashHelper);
        return articleActionDropdownItemsProvider.getArticleHistoryActionDropdownItems();
    }

    public List<DropdownItem> getArticleInfoPanelDropdownItems(JournalArticle article) throws Exception {
        return this.getArticleActionDropdownItems(article);
    }

    public List<DropdownItem> getArticleVersionActionDropdownItems(JournalArticle article) throws Exception {
        JournalArticleActionDropdownItemsProvider articleActionDropdownItemsProvider = new JournalArticleActionDropdownItemsProvider(article, this._liferayPortletRequest, this._liferayPortletResponse, this._assetDisplayPageFriendlyURLProvider, this._trashHelper);
        return articleActionDropdownItemsProvider.getArticleVersionActionDropdownItems();
    }

    public String getChangeListName(JournalArticle journalArticle) {
        return JournalChangeTrackingHelperUtil.getJournalArticleCTCollectionName(this._themeDisplay.getCompanyId(), this._themeDisplay.getUserId(), journalArticle.getId());
    }

    public String[] getCharactersBlacklist() throws PortalException {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)this._themeDisplay.getCompanyId());
        return journalServiceConfiguration.charactersblacklist();
    }

    public SearchContainer<MBMessage> getCommentsSearchContainer() throws PortalException {
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this._liferayPortletResponse.createRenderURL(), null, null);
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._liferayPortletRequest.getHttpServletRequest());
        searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(PortalUtil.getClassNameId(JournalArticle.class)));
        searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
        ArrayList<MBMessage> mbMessages = new ArrayList<MBMessage>();
        Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
        Hits hits = indexer.search(searchContext);
        for (Document document : hits.getDocs()) {
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            MBMessage mbMessage = MBMessageLocalServiceUtil.fetchMBMessage((long)entryClassPK);
            mbMessages.add(mbMessage);
        }
        searchContainer.setResults(mbMessages);
        searchContainer.setTotal(hits.getLength());
        return searchContainer;
    }

    public int getCommentsTotal() throws PortalException {
        SearchContainer<MBMessage> commentsSearchContainer = this.getCommentsSearchContainer();
        return commentsSearchContainer.getTotal();
    }

    public Map<String, Object> getComponentContext() throws Exception {
        HashMap<String, Object> componentContext = new HashMap<String, Object>();
        componentContext.put("trashEnabled", this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroupId()));
        return componentContext;
    }

    public String getDDMStructureKey() {
        if (this._ddmStructureKey != null) {
            return this._ddmStructureKey;
        }
        this._ddmStructureKey = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"ddmStructureKey");
        return this._ddmStructureKey;
    }

    public String getDDMStructureName() {
        if (this._ddmStructureName != null) {
            return this._ddmStructureName;
        }
        this._ddmStructureName = LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"basic-web-content");
        if (Validator.isNull((String)this.getDDMStructureKey())) {
            return this._ddmStructureName;
        }
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)this._themeDisplay.getSiteGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
        if (ddmStructure != null) {
            this._ddmStructureName = ddmStructure.getName(this._themeDisplay.getLocale());
        }
        return this._ddmStructureName;
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        Integer restrictionType = this.getRestrictionType();
        return this.getDDMStructures(restrictionType);
    }

    public List<DDMStructure> getDDMStructures(Integer restrictionType) throws PortalException {
        if (this._ddmStructures != null) {
            return this._ddmStructures;
        }
        if (restrictionType == null) {
            restrictionType = this.getRestrictionType();
        }
        this._ddmStructures = JournalFolderServiceUtil.getDDMStructures((long[])PortalUtil.getCurrentAndAncestorSiteGroupIds((long)this._themeDisplay.getScopeGroupId()), (long)this.getFolderId(), (int)restrictionType);
        Locale locale = this._themeDisplay.getLocale();
        if (this._journalWebConfiguration.journalBrowseByStructuresSortedByName()) {
            this._ddmStructures.sort((ddmStructure1, ddmStructure2) -> {
                String name1 = ddmStructure1.getName(locale);
                String name2 = ddmStructure2.getName(locale);
                return name1.compareTo(name2);
            });
        }
        return this._ddmStructures;
    }

    public int getDefaultStatus() {
        PermissionChecker permissionChecker = this._themeDisplay.getPermissionChecker();
        if (permissionChecker.isContentReviewer(this._themeDisplay.getCompanyId(), this._themeDisplay.getScopeGroupId()) || this.isNavigationMine()) {
            return -1;
        }
        return 0;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        Object[] displayViews = this.getDisplayViews();
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._httpServletRequest);
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle");
        if (Validator.isNull((String)this._displayStyle)) {
            this._displayStyle = portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "display-style", this._journalWebConfiguration.defaultDisplayView());
        }
        if (!ArrayUtil.contains((Object[])displayViews, (Object)this._displayStyle)) {
            this._displayStyle = displayViews[0];
        }
        return this._displayStyle;
    }

    public String[] getDisplayViews() {
        return this._journalWebConfiguration.displayViews();
    }

    public JournalFolder getFolder() {
        if (this._folder != null) {
            return this._folder;
        }
        this._folder = (JournalFolder)this._httpServletRequest.getAttribute("JOURNAL_FOLDER");
        if (this._folder != null) {
            return this._folder;
        }
        long folderId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"folderId");
        this._folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId);
        return this._folder;
    }

    public List<DropdownItem> getFolderActionDropdownItems(JournalFolder folder) throws Exception {
        JournalFolderActionDropdownItems folderActionDropdownItems = new JournalFolderActionDropdownItems(folder, this._liferayPortletRequest, this._liferayPortletResponse, this._trashHelper);
        return folderActionDropdownItems.getActionDropdownItems();
    }

    public long getFolderId() {
        if (this._folderId != null) {
            return this._folderId;
        }
        JournalFolder folder = this.getFolder();
        this._folderId = BeanParamUtil.getLong((Object)folder, (HttpServletRequest)this._httpServletRequest, (String)"folderId", (long)0L);
        return this._folderId;
    }

    public List<DropdownItem> getFolderInfoPanelDropdownItems(JournalFolder folder) throws Exception {
        JournalFolderActionDropdownItems folderActionDropdownItems = new JournalFolderActionDropdownItems(folder, this._liferayPortletRequest, this._liferayPortletResponse, this._trashHelper);
        return folderActionDropdownItems.getInfoPanelActionDropdownItems();
    }

    public JSONArray getFoldersJSONArray() {
        JSONArray jsonArray = this._getFoldersJSONArray(this._themeDisplay.getScopeGroupId(), 0L);
        JSONObject jsonObject = JSONUtil.put((String)"children", (Object)jsonArray).put("icon", "folder").put("id", 0L).put("name", LanguageUtil.get((Locale)this._themeDisplay.getLocale(), (String)"home"));
        return JSONUtil.put((Object)jsonObject);
    }

    public String getFolderTitle() {
        JournalFolder folder = this.getFolder();
        if (folder != null) {
            return folder.getName();
        }
        return "";
    }

    public List<NavigationItem> getInfoPanelNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._httpServletRequest, (String)"details"));
                });
            }
        };
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords");
        return this._keywords;
    }

    public JournalArticle getLatestArticle(JournalArticle journalArticle) {
        JournalArticle latestArticle = JournalArticleLocalServiceUtil.fetchLatestArticle((long)journalArticle.getGroupId(), (String)journalArticle.getArticleId(), (int)-1);
        if (latestArticle != null) {
            return latestArticle;
        }
        return journalArticle;
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public List<NavigationItem> getNavigationBarItems(final String currentItem) {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(currentItem.equals("web-content"));
                    navigationItem.setHref((Object)JournalDisplayContext.this._liferayPortletResponse.createRenderURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._httpServletRequest, (String)"web-content"));
                });
                Group group = JournalDisplayContext.this._themeDisplay.getScopeGroup();
                if (!group.isLayout()) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(currentItem.equals("structures"));
                        navigationItem.setHref(JournalDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/view_ddm_structures.jsp"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._httpServletRequest, (String)"structures"));
                    });
                    this.add(navigationItem -> {
                        navigationItem.setActive(currentItem.equals("templates"));
                        navigationItem.setHref(JournalDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/view_ddm_templates.jsp"});
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._httpServletRequest, (String)"templates"));
                    });
                }
                if (JournalDisplayContext.this._journalWebConfiguration.showFeeds() && PortalUtil.isRSSFeedsEnabled()) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(currentItem.equals("feeds"));
                        navigationItem.setHref((Object)JournalDisplayContext.this._getFeedsURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._httpServletRequest, (String)"feeds"));
                    });
                }
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this._portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-col", "modified-date");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        if (this.isNavigationRecent()) {
            return "desc";
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this._portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-type", "asc");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._httpServletRequest, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public String[] getOrderColumns() {
        Object[] orderColumns = new String[]{"display-date", "modified-date", "title"};
        if (!this._journalWebConfiguration.journalArticleForceAutogenerateId()) {
            orderColumns = (String[])ArrayUtil.append((Object[])orderColumns, (Object)"id");
        }
        return orderColumns;
    }

    public String getOriginalAuthor(JournalArticle article) {
        long classPK = JournalArticleAssetRenderer.getClassPK(article);
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)JournalArticle.class.getName(), (long)classPK);
        if (assetEntry != null) {
            return assetEntry.getUserName();
        }
        return article.getUserName();
    }

    public long getParentFolderId() {
        if (this._parentFolderId != null) {
            return this._parentFolderId;
        }
        this._parentFolderId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"parentFolderId", (long)0L);
        return this._parentFolderId;
    }

    public PortletURL getPortletURL() {
        String tabs1;
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        String deltaEntry;
        String delta;
        String status;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        String navigation = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"navigation");
        if (Validator.isNotNull((String)navigation)) {
            portletURL.setParameter("navigation", HtmlUtil.escapeJS((String)this.getNavigation()));
        }
        portletURL.setParameter("folderId", String.valueOf(this.getFolderId()));
        if (this.isNavigationStructure()) {
            portletURL.setParameter("ddmStructureKey", this.getDDMStructureKey());
        }
        if (Validator.isNotNull((String)(status = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"status")))) {
            portletURL.setParameter("status", String.valueOf(this.getStatus()));
        }
        if (Validator.isNotNull((String)(delta = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"delta")))) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(deltaEntry = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"deltaEntry")))) {
            portletURL.setParameter("deltaEntry", deltaEntry);
        }
        if (Validator.isNotNull((String)(displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle")))) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        if (Validator.isNotNull((String)(tabs1 = this.getTabs1()))) {
            portletURL.setParameter("tabs1", tabs1);
        }
        return portletURL;
    }

    public int getRestrictionType() {
        if (this._restrictionType != null) {
            return this._restrictionType;
        }
        JournalFolder folder = this.getFolder();
        this._restrictionType = folder != null ? Integer.valueOf(folder.getRestrictionType()) : Integer.valueOf(0);
        return this._restrictionType;
    }

    public SearchContainer getSearchContainer(boolean showVersions) throws PortalException {
        if (this._articleSearchContainer != null) {
            return this._articleSearchContainer;
        }
        SearchContainer articleSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, null);
        OrderByComparator<JournalArticle> orderByComparator = JournalPortletUtil.getArticleOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        articleSearchContainer.setOrderByCol(this.getOrderByCol());
        articleSearchContainer.setOrderByComparator(orderByComparator);
        articleSearchContainer.setOrderByType(this.getOrderByType());
        if (!showVersions) {
            EntriesChecker entriesChecker = new EntriesChecker(this._liferayPortletRequest, this._liferayPortletResponse);
            entriesChecker.setCssClass("entry-selector");
            entriesChecker.setRememberCheckBoxStateURLRegex(StringBundler.concat((Object[])new Object[]{"^(?!.*", this._liferayPortletResponse.getNamespace(), "redirect).*(folderId=", this.getFolderId(), ")"}));
            articleSearchContainer.setRowChecker((RowChecker)entriesChecker);
            if (!BrowserSnifferUtil.isMobile((HttpServletRequest)this._httpServletRequest)) {
                EntriesMover entriesMover = new EntriesMover(this._trashHelper.isTrashEnabled(this._themeDisplay.getScopeGroupId()));
                articleSearchContainer.setRowMover((RowMover)entriesMover);
            }
        }
        if (this.isNavigationMine() || this.isNavigationRecent()) {
            boolean includeOwner = true;
            if (this.isNavigationMine()) {
                includeOwner = false;
            }
            if (this.isNavigationRecent()) {
                articleSearchContainer.setOrderByCol("modified-date");
                articleSearchContainer.setOrderByType(this.getOrderByType());
            }
            int total = JournalArticleServiceUtil.getGroupArticlesCount((long)this._themeDisplay.getScopeGroupId(), (long)this._themeDisplay.getUserId(), (long)this.getFolderId(), (int)this.getStatus(), (boolean)includeOwner);
            articleSearchContainer.setTotal(total);
            List results = JournalArticleServiceUtil.getGroupArticles((long)this._themeDisplay.getScopeGroupId(), (long)this._themeDisplay.getUserId(), (long)this.getFolderId(), (int)this.getStatus(), (boolean)includeOwner, (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
            articleSearchContainer.setResults(results);
        } else if (Validator.isNotNull((String)this.getDDMStructureKey())) {
            int total = JournalArticleServiceUtil.getArticlesCountByStructureId((long)this._themeDisplay.getScopeGroupId(), (String)this.getDDMStructureKey(), (int)this.getStatus());
            articleSearchContainer.setTotal(total);
            List results = JournalArticleServiceUtil.getArticlesByStructureId((long)this._themeDisplay.getScopeGroupId(), (String)this.getDDMStructureKey(), (int)this.getStatus(), (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
            articleSearchContainer.setResults(results);
        } else if (this.isSearch()) {
            Document[] documents;
            ArrayList<Long> folderIds = new ArrayList<Long>(1);
            if (this.getFolderId() != 0L) {
                folderIds.add(this.getFolderId());
            }
            boolean orderByAsc = false;
            if (Objects.equals(this.getOrderByType(), "asc")) {
                orderByAsc = true;
            }
            Sort sort = null;
            if (Objects.equals(this.getOrderByCol(), "display-date")) {
                sort = new Sort("displayDate", 6, orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "id")) {
                sort = new Sort(Field.getSortableFieldName((String)"articleId"), 3, !orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "modified-date")) {
                sort = new Sort("modified", 6, orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "title")) {
                sort = new Sort("title", 3, !orderByAsc);
            }
            Indexer indexer = null;
            indexer = !showVersions ? JournalSearcher.getInstance() : IndexerRegistryUtil.getIndexer(JournalArticle.class);
            SearchContext searchContext = this.buildSearchContext(folderIds, articleSearchContainer.getStart(), articleSearchContainer.getEnd(), sort, showVersions);
            Hits hits = indexer.search(searchContext);
            int total = hits.getLength();
            articleSearchContainer.setTotal(total);
            ArrayList<Object> results = new ArrayList<Object>();
            for (Document document : documents = hits.getDocs()) {
                String className = document.get("entryClassName");
                long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                if (className.equals(JournalArticle.class.getName())) {
                    JournalArticle article = null;
                    boolean visible = true;
                    if (!showVersions) {
                        article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)classPK, (int)-1, (boolean)false);
                    } else {
                        String articleId = document.get("articleId");
                        long groupId = GetterUtil.getLong((String)document.get("groupId"));
                        double version = GetterUtil.getDouble((String)document.get("version"));
                        article = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)version);
                        visible = JournalChangeTrackingHelperUtil.isJournalArticleInChangeList(this._themeDisplay.getCompanyId(), this._themeDisplay.getUserId(), article.getId());
                    }
                    if (!visible) continue;
                    results.add(article);
                    continue;
                }
                if (!className.equals(JournalFolder.class.getName())) continue;
                JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
                results.add(folder);
            }
            articleSearchContainer.setResults(results);
        } else {
            int total = JournalFolderServiceUtil.getFoldersAndArticlesCount((long)this._themeDisplay.getScopeGroupId(), (long)0L, (long)this.getFolderId(), (int)this.getStatus());
            articleSearchContainer.setTotal(total);
            FolderArticleDisplayDateComparator folderOrderByComparator = null;
            boolean orderByAsc = false;
            if (Objects.equals(this.getOrderByType(), "asc")) {
                orderByAsc = true;
            }
            if (Objects.equals(this.getOrderByCol(), "display-date")) {
                folderOrderByComparator = new FolderArticleDisplayDateComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "id")) {
                folderOrderByComparator = new FolderArticleArticleIdComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "modified-date")) {
                folderOrderByComparator = new FolderArticleModifiedDateComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "title")) {
                folderOrderByComparator = new FolderArticleTitleComparator(orderByAsc);
            }
            List results = JournalFolderServiceUtil.getFoldersAndArticles((long)this._themeDisplay.getScopeGroupId(), (long)0L, (long)this.getFolderId(), (int)this.getStatus(), (Locale)this._themeDisplay.getLocale(), (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)folderOrderByComparator);
            articleSearchContainer.setResults(results);
        }
        this._articleSearchContainer = articleSearchContainer;
        return this._articleSearchContainer;
    }

    public int getStatus() {
        if (this._status != null) {
            return this._status;
        }
        this._status = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"status", (int)this.getDefaultStatus());
        return this._status;
    }

    public String getTabs1() {
        if (this._tabs1 != null) {
            return this._tabs1;
        }
        this._tabs1 = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"tabs1");
        return this._tabs1;
    }

    public int getTotalItems() throws PortalException {
        SearchContainer articleSearch = this.getSearchContainer(false);
        return articleSearch.getTotal();
    }

    public int getVersionsTotal() throws PortalException {
        SearchContainer articleSearch = this.getSearchContainer(true);
        return articleSearch.getTotal();
    }

    public boolean hasCommentsResults() throws PortalException {
        return this.getCommentsTotal() > 0;
    }

    public boolean hasResults() throws PortalException {
        return this.getTotalItems() > 0;
    }

    public boolean hasVersionsResults() throws PortalException {
        return this.getVersionsTotal() > 0;
    }

    public boolean isChangeListColumnVisible() {
        return JournalChangeTrackingHelperUtil.hasActiveCTCollection(this._themeDisplay.getCompanyId(), this._themeDisplay.getUserId());
    }

    public boolean isJournalArticleInChangeList(JournalArticle journalArticle) {
        return JournalChangeTrackingHelperUtil.isJournalArticleInChangeList(this._themeDisplay.getCompanyId(), this._themeDisplay.getUserId(), journalArticle.getId());
    }

    public boolean isNavigationHome() {
        return Objects.equals(this.getNavigation(), "all");
    }

    public boolean isNavigationMine() {
        return Objects.equals(this.getNavigation(), "mine");
    }

    public boolean isNavigationRecent() {
        return Objects.equals(this.getNavigation(), "recent");
    }

    public boolean isNavigationStructure() {
        return Objects.equals(this.getNavigation(), "structure");
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowInfoButton() {
        if (Validator.isNotNull((String)this.getDDMStructureKey())) {
            return false;
        }
        if (this.isNavigationMine()) {
            return false;
        }
        if (this.isNavigationRecent()) {
            return false;
        }
        return !this.isSearch();
    }

    protected SearchContext buildSearchContext(List<Long> folderIds, int start, int end, Sort sort, boolean showVersions) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(false);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("articleId", this.getKeywords());
        attributes.put("classNameId", 0L);
        attributes.put("content", this.getKeywords());
        attributes.put("description", this.getKeywords());
        attributes.put("status", this.getStatus());
        attributes.put("title", this.getKeywords());
        attributes.put("ddmStructureKey", this.getDDMStructureKey());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("expandoAttributes", this.getKeywords());
        params.put("keywords", this.getKeywords());
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(this._themeDisplay.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{this._themeDisplay.getScopeGroupId()});
        searchContext.setKeywords(this.getKeywords());
        searchContext.setAttribute("head", (Serializable)Boolean.valueOf(!showVersions));
        searchContext.setAttribute("latest", (Serializable)Boolean.valueOf(!showVersions));
        searchContext.setAttribute("params", params);
        if (!showVersions) {
            searchContext.setAttribute("showNonindexable", (Serializable)Boolean.TRUE);
        }
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    private String _getFeedsURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_feeds.jsp");
        portletURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        return portletURL.toString();
    }

    private JSONArray _getFoldersJSONArray(long groupId, long folderId) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List folders = JournalFolderLocalServiceUtil.getFolders((long)groupId, (long)folderId);
        for (JournalFolder folder : folders) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONArray childrenJSONArray = this._getFoldersJSONArray(groupId, folder.getFolderId());
            if (childrenJSONArray.length() > 0) {
                jsonObject.put("children", childrenJSONArray);
            }
            jsonObject.put("icon", "folder").put("id", folder.getFolderId()).put("name", folder.getName());
            if (folder.getFolderId() == this.getParentFolderId()) {
                jsonObject.put("selected", true);
            }
            if (folder.getFolderId() == this.getFolderId()) {
                jsonObject.put("disabled", true);
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }
}

