/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMTemplateServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.servlet.taglib.util.JournalDDMTemplateActionDropdownItemsProvider;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalDDMTemplateDisplayContext {
    private Long _classPK;
    private DDMStructure _ddmStructure;
    private SearchContainer _ddmTemplateSearch;
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private final JournalWebConfiguration _journalWebConfiguration;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public JournalDDMTemplateDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._journalWebConfiguration = (JournalWebConfiguration)this._httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"classPK");
        return this._classPK;
    }

    public DDMStructure getDDMStructure() {
        if (this._ddmStructure != null) {
            return this._ddmStructure;
        }
        if (this.getClassPK() <= 0L) {
            return this._ddmStructure;
        }
        this._ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)this.getClassPK());
        return this._ddmStructure;
    }

    public List<DropdownItem> getDDMTemplateActionDropdownItems(DDMTemplate ddmTemplate) throws Exception {
        JournalDDMTemplateActionDropdownItemsProvider ddmTemplateActionDropdownItems = new JournalDDMTemplateActionDropdownItemsProvider(ddmTemplate, this._renderRequest, this._renderResponse);
        return ddmTemplateActionDropdownItems.getActionDropdownItems();
    }

    public SearchContainer getDDMTemplateSearch() throws Exception {
        if (this._ddmTemplateSearch != null) {
            return this._ddmTemplateSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer ddmTemplateSearch = new SearchContainer((PortletRequest)this._renderRequest, this._getPortletURL(), null, "there-are-no-templates");
        if (Validator.isNotNull((String)this._getKeywords())) {
            ddmTemplateSearch.setEmptyResultsMessage("no-templates-were-found");
        }
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getTemplateOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        ddmTemplateSearch.setOrderByCol(orderByCol);
        ddmTemplateSearch.setOrderByComparator(orderByComparator);
        ddmTemplateSearch.setOrderByType(orderByType);
        ddmTemplateSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        long[] groupIds = new long[]{themeDisplay.getScopeGroupId()};
        if (this._journalWebConfiguration.showAncestorScopesByDefault()) {
            groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId());
        }
        List results = DDMTemplateServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])groupIds, (long[])new long[]{PortalUtil.getClassNameId(DDMStructure.class)}, (long[])this._getDDMTemplateClassPKs(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this._getKeywords(), (String)"", (String)"", (int)-1, (int)ddmTemplateSearch.getStart(), (int)ddmTemplateSearch.getEnd(), (OrderByComparator)ddmTemplateSearch.getOrderByComparator());
        ddmTemplateSearch.setResults(results);
        int total = DDMTemplateServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long[])new long[]{PortalUtil.getClassNameId(DDMStructure.class)}, (long[])this._getDDMTemplateClassPKs(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this._getKeywords(), (String)"", (String)"", (int)-1);
        ddmTemplateSearch.setTotal(total);
        this._ddmTemplateSearch = ddmTemplateSearch;
        return ddmTemplateSearch;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"icon");
        return this._displayStyle;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String[] getTemplateLanguageTypes() {
        return this._journalWebConfiguration.journalDDMTemplateLanguageTypes();
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this._getKeywords());
    }

    private long[] _getDDMTemplateClassPKs() {
        if (this.getClassPK() > 0L) {
            return new long[]{this.getClassPK()};
        }
        return null;
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private PortletURL _getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_ddm_templates.jsp");
        String keywords = this._getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }
}

