/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.service.DDMStructureServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalDDMStructuresDisplayContext {
    private SearchContainer _ddmStructureSearch;
    private final HttpServletRequest _httpServletRequest;
    private final JournalWebConfiguration _journalWebConfiguration;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public JournalDDMStructuresDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._journalWebConfiguration = (JournalWebConfiguration)this._httpServletRequest.getAttribute(JournalWebConfiguration.class.getName());
    }

    public SearchContainer getDDMStructureSearch() throws Exception {
        if (this._ddmStructureSearch != null) {
            return this._ddmStructureSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer ddmStructureSearch = new SearchContainer((PortletRequest)this._renderRequest, this._getPortletURL(), null, "there-are-no-structures");
        if (Validator.isNotNull((String)this._getKeywords())) {
            ddmStructureSearch.setEmptyResultsMessage("no-structures-were-found");
        }
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getStructureOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        ddmStructureSearch.setOrderByCol(orderByCol);
        ddmStructureSearch.setOrderByComparator(orderByComparator);
        ddmStructureSearch.setOrderByType(orderByType);
        ddmStructureSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        long[] groupIds = new long[]{themeDisplay.getScopeGroupId()};
        if (this._journalWebConfiguration.showAncestorScopesByDefault()) {
            groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId());
        }
        List results = null;
        int total = 0;
        if (Validator.isNotNull((String)this._getKeywords())) {
            results = DDMStructureServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (int)-1, (int)ddmStructureSearch.getStart(), (int)ddmStructureSearch.getEnd(), (OrderByComparator)ddmStructureSearch.getOrderByComparator());
            total = DDMStructureServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (int)-1);
        } else {
            results = DDMStructureServiceUtil.getStructures((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (int)ddmStructureSearch.getStart(), (int)ddmStructureSearch.getEnd(), (OrderByComparator)ddmStructureSearch.getOrderByComparator());
            total = DDMStructureServiceUtil.getStructuresCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()));
        }
        ddmStructureSearch.setResults(results);
        ddmStructureSearch.setTotal(total);
        this._ddmStructureSearch = ddmStructureSearch;
        return ddmStructureSearch;
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this._getKeywords());
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private PortletURL _getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_ddm_structures.jsp");
        String keywords = this._getKeywords();
        if (Validator.isNotNull((String)keywords)) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }
}

