/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.asset.util;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.asset.util.AssetEntryUsageActionMenuContributor;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AssetEntryUsageActionMenuContributor.class})
public class JournalArticleAssetEntryUsageActionMenuContributor
implements AssetEntryUsageActionMenuContributor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleAssetEntryUsageActionMenuContributor.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private Http _http;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private Portal _portal;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(bundle.symbolic.name=com.liferay.journal.web)")
    private volatile ResourceBundleLoader _resourceBundleLoader;

    public List<DropdownItem> getAssetEntryUsageActionMenu(final AssetEntryUsage assetEntryUsage, final HttpServletRequest httpServletRequest) {
        final AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryUsage.getAssetEntryId());
        final JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(assetEntry.getClassPK(), -1, false);
        return new DropdownItemList(){
            {
                JournalArticle approvedArticle = JournalArticleAssetEntryUsageActionMenuContributor.this._journalArticleLocalService.fetchLatestArticle(assetEntry.getClassPK(), 0);
                ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                ResourceBundle resourceBundle = JournalArticleAssetEntryUsageActionMenuContributor.this._resourceBundleLoader.loadResourceBundle(themeDisplay.getLocale());
                if (approvedArticle != null) {
                    this.add(dropdownItem -> {
                        dropdownItem.setHref((Object)JournalArticleAssetEntryUsageActionMenuContributor.this._getURL(assetEntryUsage, 1, httpServletRequest));
                        dropdownItem.setLabel(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"view-in-page"));
                    });
                }
                if (article.isDraft() || article.isPending() || article.isScheduled()) {
                    try {
                        if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), article, "UPDATE")) {
                            String key = "preview-draft-in-page";
                            if (article.isPending()) {
                                key = "preview-pending-in-page";
                            } else if (article.isScheduled()) {
                                key = "preview-scheduled-in-page";
                            }
                            String label = LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
                            this.add(dropdownItem -> {
                                dropdownItem.setHref((Object)JournalArticleAssetEntryUsageActionMenuContributor.this._getURL(assetEntryUsage, 0, httpServletRequest));
                                dropdownItem.setLabel(label);
                            });
                        }
                    }
                    catch (PortalException pe) {
                        _log.error((Object)"Unable to check article permission", (Throwable)pe);
                    }
                }
            }
        };
    }

    private String _getURL(AssetEntryUsage assetEntryUsage, int previewAssetEntryType, HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String layoutURL = null;
        if (assetEntryUsage.getContainerType() == this._portal.getClassNameId(FragmentEntryLink.class)) {
            Layout layout = this._layoutLocalService.fetchLayout(assetEntryUsage.getPlid());
            layoutURL = this._portal.getLayoutFriendlyURL(layout, themeDisplay);
            layoutURL = this._http.setParameter(layoutURL, "previewAssetEntryId", String.valueOf(assetEntryUsage.getAssetEntryId()));
            layoutURL = this._http.setParameter(layoutURL, "previewAssetEntryType", String.valueOf(previewAssetEntryType));
        } else {
            LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest, (String)assetEntryUsage.getContainerKey(), (long)assetEntryUsage.getPlid(), (String)"RENDER_PHASE");
            portletURL.setParameter("previewAssetEntryId", String.valueOf(assetEntryUsage.getAssetEntryId()));
            portletURL.setParameter("previewAssetEntryType", String.valueOf(previewAssetEntryType));
            layoutURL = portletURL.toString();
        }
        String portletURLString = this._http.setParameter(layoutURL, "p_l_back_url", themeDisplay.getURLCurrent());
        return portletURLString + "#portlet_" + assetEntryUsage.getContainerKey();
    }
}

