/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.asset.model;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseAssetRendererFactory;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.web.asset.model.JournalArticleAssetRenderer;
import com.liferay.journal.web.asset.model.JournalArticleClassTypeReader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={AssetRendererFactory.class})
public class JournalArticleAssetRendererFactory
extends BaseAssetRendererFactory<JournalArticle> {
    public static final String TYPE = "content";
    @Reference
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMStructure)")
    private ModelResourcePermission<DDMStructure> _ddmStructureModelResourcePermission;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    @Reference
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private JournalConverter _journalConverter;
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;
    private ServletContext _servletContext;

    public JournalArticleAssetRendererFactory() {
        this.setClassName(JournalArticle.class.getName());
        this.setLinkable(true);
        this.setPortletId("com_liferay_journal_web_portlet_JournalPortlet");
        this.setSearchable(true);
        this.setSupportsClassTypes(true);
    }

    public AssetRenderer<JournalArticle> getAssetRenderer(JournalArticle journalArticle, int type) throws PortalException {
        JournalArticleAssetRenderer journalArticleAssetRenderer = this.getJournalArticleAssetRenderer(journalArticle);
        journalArticleAssetRenderer.setAssetRendererType(type);
        return journalArticleAssetRenderer;
    }

    public AssetRenderer<JournalArticle> getAssetRenderer(long classPK, int type) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.fetchJournalArticle(classPK);
        if (article == null) {
            JournalArticleResource articleResource = this._journalArticleResourceLocalService.getArticleResource(classPK);
            if (type == 1) {
                article = this._journalArticleLocalService.fetchDisplayArticle(articleResource.getGroupId(), articleResource.getArticleId());
            }
            if (article == null) {
                article = this._journalArticleLocalService.fetchLatestArticle(articleResource.getGroupId(), articleResource.getArticleId(), -1);
            }
            if (article == null && type == 0) {
                article = this._journalArticleLocalService.fetchLatestArticle(classPK, -1);
            }
        }
        JournalArticleAssetRenderer journalArticleAssetRenderer = this.getJournalArticleAssetRenderer(article);
        journalArticleAssetRenderer.setAssetRendererType(type);
        return journalArticleAssetRenderer;
    }

    public AssetRenderer<JournalArticle> getAssetRenderer(long groupId, String urlTitle) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getArticleByUrlTitle(groupId, urlTitle);
        return this.getJournalArticleAssetRenderer(article);
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public ClassTypeReader getClassTypeReader() {
        return new JournalArticleClassTypeReader(this.getClassName());
    }

    public String getIconCssClass() {
        return "web-content";
    }

    public String getSubtypeTitle(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"structures");
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, long subtypeId) {
        try {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(subtypeId);
            return ddmStructure.getName(locale);
        }
        catch (Exception e) {
            return super.getTypeName(locale, subtypeId);
        }
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long classTypeId) {
        DDMStructure ddmStructure;
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, this.getGroup(liferayPortletRequest), "com_liferay_journal_web_portlet_JournalPortlet", 0L, 0L, "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        if (classTypeId > 0L && (ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(classTypeId)) != null) {
            portletURL.setParameter("ddmStructureKey", ddmStructure.getStructureKey());
        }
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {
            // empty catch block
        }
        return liferayPortletURL;
    }

    public boolean hasAddPermission(PermissionChecker permissionChecker, long groupId, long classTypeId) throws Exception {
        if (classTypeId == 0L) {
            return false;
        }
        if (!this._ddmStructureModelResourcePermission.contains(permissionChecker, classTypeId, "VIEW")) {
            return false;
        }
        return this._portletResourcePermission.contains(permissionChecker, groupId, "ADD_ARTICLE");
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return this._journalArticleModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.journal.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    protected JournalArticleAssetRenderer getJournalArticleAssetRenderer(JournalArticle article) {
        JournalArticleAssetRenderer journalArticleAssetRenderer = new JournalArticleAssetRenderer(article);
        journalArticleAssetRenderer.setAssetDisplayPageFriendlyURLProvider(this._assetDisplayPageFriendlyURLProvider);
        journalArticleAssetRenderer.setFieldsToDDMFormValuesConverter(this._fieldsToDDMFormValuesConverter);
        journalArticleAssetRenderer.setJournalContent(this._journalContent);
        journalArticleAssetRenderer.setJournalConverter(this._journalConverter);
        journalArticleAssetRenderer.setServletContext(this._servletContext);
        return journalArticleAssetRenderer;
    }
}

