/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.asset.model;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.display.page.util.AssetDisplayPageHelper;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.asset.model.AssetEntryUsage;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalContentSearchLocalServiceUtil;
import com.liferay.journal.util.JournalContent;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.web.asset.JournalArticleDDMFormValuesReader;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JournalArticleAssetRenderer
extends BaseJSPAssetRenderer<JournalArticle>
implements TrashRenderer {
    public static final String TYPE = "journal_article";
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleAssetRenderer.class);
    private final JournalArticle _article;
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    private JournalContent _journalContent;
    private JournalConverter _journalConverter;
    private JournalServiceConfiguration _journalServiceConfiguration;

    public static long getClassPK(JournalArticle article) {
        if ((article.isDraft() || article.isPending()) && article.getVersion() != 1.0) {
            return article.getPrimaryKey();
        }
        return article.getResourcePrimKey();
    }

    public JournalArticleAssetRenderer(JournalArticle article) {
        this._article = article;
    }

    public JournalArticle getArticle() {
        return this._article;
    }

    public JournalArticle getAssetObject() {
        return this._article;
    }

    public JournalArticle getAssetObject(long versionClassPK) {
        return JournalArticleLocalServiceUtil.fetchArticle((long)versionClassPK);
    }

    public String[] getAvailableLanguageIds() {
        return this._article.getAvailableLanguageIds();
    }

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public long getClassPK() {
        return JournalArticleAssetRenderer.getClassPK(this._article);
    }

    public DDMFormValuesReader getDDMFormValuesReader() {
        JournalArticleDDMFormValuesReader journalArticleDDMFormValuesReader = new JournalArticleDDMFormValuesReader(this._article);
        journalArticleDDMFormValuesReader.setFieldsToDDMFormValuesConverter(this._fieldsToDDMFormValuesConverter);
        journalArticleDDMFormValuesReader.setJournalConverter(this._journalConverter);
        return journalArticleDDMFormValuesReader;
    }

    public String getDefaultLanguageId() throws Exception {
        return this._article.getDefaultLanguageId();
    }

    public String getDiscussionPath() {
        if (this._journalServiceConfiguration == null) {
            try {
                this._journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)this._article.getCompanyId());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        if (this._journalServiceConfiguration.articleCommentsEnabled()) {
            return "edit_article_discussion";
        }
        return null;
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._article.getDisplayDate();
    }

    public long getGroupId() {
        return this._article.getGroupId();
    }

    public String getJspPath(HttpServletRequest httpServletRequest, String template) {
        if (this._article.isInTrash() && template.equals("full_content")) {
            return "/trash/" + template + ".jsp";
        }
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/asset/" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        return "com_liferay_journal_web_portlet_JournalPortlet";
    }

    public int getStatus() {
        return this._article.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        Locale locale = this.getLocale(portletRequest);
        String summary = this._article.getDescription(locale);
        if (Validator.isNotNull((String)summary)) {
            return HtmlUtil.render((String)HtmlUtil.stripHtml((String)summary));
        }
        try {
            PortletRequestModel portletRequestModel = null;
            ThemeDisplay themeDisplay = null;
            if (portletRequest != null && portletResponse != null) {
                portletRequestModel = new PortletRequestModel(portletRequest, portletResponse);
                themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            }
            String ddmTemplateKey = ParamUtil.getString((PortletRequest)portletRequest, (String)"ddmTemplateKey");
            JournalArticleDisplay articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)this._article, (String)ddmTemplateKey, null, (String)LanguageUtil.getLanguageId((Locale)locale), (int)1, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
            summary = HtmlUtil.render((String)HtmlUtil.stripHtml((String)articleDisplay.getContent()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return summary;
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String thumbnailSrc = this._article.getArticleImageURL(themeDisplay);
        if (Validator.isNotNull((String)thumbnailSrc)) {
            return thumbnailSrc;
        }
        return super.getThumbnailPath(portletRequest);
    }

    public String getTitle(Locale locale) {
        return this._article.getTitle(locale);
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(HttpServletRequest httpServletRequest) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._article.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)httpServletRequest, (Group)group, (String)"com_liferay_journal_web_portlet_JournalPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        portletURL.setParameter("version", String.valueOf(this._article.getVersion()));
        return portletURL;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest);
        return this.getURLEdit(httpServletRequest);
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        LiferayPortletURL portletURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL liferayPortletURL = portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"com_liferay_journal_web_portlet_JournalPortlet", (long)themeDisplay.getPlid(), (String)"RESOURCE_PHASE");
        liferayPortletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        liferayPortletURL.setParameter("articleId", this._article.getArticleId());
        liferayPortletURL.setResourceID("exportArticle");
        return liferayPortletURL;
    }

    public String getUrlTitle() {
        return this._article.getUrlTitle();
    }

    public String getUrlTitle(Locale locale) {
        try {
            return this._article.getUrlTitle(locale);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return this.getUrlTitle();
        }
    }

    public PortletURL getURLViewDiffs(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        JournalArticle previousApprovedArticle = JournalArticleLocalServiceUtil.getPreviousApprovedArticle((JournalArticle)this._article);
        if (previousApprovedArticle.getVersion() == this._article.getVersion() || this._article.getVersion() == 1.0) {
            return null;
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_journal_web_portlet_JournalPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/compare_versions.jsp");
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        portletURL.setParameter("sourceVersion", String.valueOf(previousApprovedArticle.getVersion()));
        portletURL.setParameter("targetVersion", String.valueOf(this._article.getVersion()));
        return portletURL;
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws Exception {
        String friendlyURL;
        Group group;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = this._article.getLayout();
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        if (!this._isShowDisplayPage((group = themeDisplay.getScopeGroup()).getGroupId(), this._article)) {
            String hitLayoutURL = this.getHitLayoutURL(layout.isPrivateLayout(), noSuchEntryRedirect, themeDisplay);
            if (Objects.equals(hitLayoutURL, noSuchEntryRedirect)) {
                hitLayoutURL = this.getHitLayoutURL(!layout.isPrivateLayout(), noSuchEntryRedirect, themeDisplay);
            }
            return hitLayoutURL;
        }
        if (group.getGroupId() != this._article.getGroupId()) {
            group = GroupLocalServiceUtil.getGroup((long)this._article.getGroupId());
        }
        if (this._assetDisplayPageFriendlyURLProvider != null && Validator.isNotNull((String)(friendlyURL = this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(this.getClassName(), this.getClassPK(), themeDisplay)))) {
            return friendlyURL;
        }
        String groupFriendlyURL = PortalUtil.getGroupFriendlyURL((LayoutSet)LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)layout.isPrivateLayout()), (ThemeDisplay)themeDisplay);
        StringBundler sb = new StringBundler(5);
        sb.append(groupFriendlyURL);
        sb.append("/-/");
        sb.append(this._article.getUrlTitle(themeDisplay.getLocale()));
        sb.append("/");
        sb.append(this._article.getVersion());
        return PortalUtil.addPreservedParameters((ThemeDisplay)themeDisplay, (String)sb.toString());
    }

    public String getURLViewUsages(HttpServletRequest httpServletRequest) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(JournalArticle.class.getName(), this._article.getResourcePrimKey());
        if (assetEntry == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL viewUsagesURL = PortletProviderUtil.getPortletURL((HttpServletRequest)httpServletRequest, (String)AssetEntryUsage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        viewUsagesURL.setParameter("redirect", themeDisplay.getURLCurrent());
        viewUsagesURL.setParameter("className", String.valueOf(assetEntry.getClassName()));
        viewUsagesURL.setParameter("classPK", String.valueOf(assetEntry.getClassPK()));
        return viewUsagesURL.toString();
    }

    public long getUserId() {
        return this._article.getUserId();
    }

    public String getUserName() {
        return this._article.getUserName();
    }

    public String getUuid() {
        return this._article.getUuid();
    }

    public String getViewInContextMessage() {
        return "view[action]";
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalArticlePermission.contains(permissionChecker, this._article, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalArticlePermission.contains(permissionChecker, this._article, "VIEW");
    }

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        httpServletRequest.setAttribute("JOURNAL_ARTICLE", (Object)this._article);
        httpServletRequest.setAttribute("JOURNAL_ARTICLE_DISPLAY", (Object)this.getArticleDisplay(httpServletRequest, httpServletResponse));
        return super.include(httpServletRequest, httpServletResponse, template);
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isDisplayable() {
        Date now = new Date();
        Date displayDate = this._article.getDisplayDate();
        if (displayDate != null && displayDate.after(now)) {
            return false;
        }
        Date expirationDate = this._article.getExpirationDate();
        return expirationDate == null || !expirationDate.before(now);
    }

    public boolean isLocalizable() {
        return true;
    }

    public boolean isPrintable() {
        return true;
    }

    public void setAssetDisplayPageFriendlyURLProvider(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider) {
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
    }

    public void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    public void setJournalContent(JournalContent journalContent) {
        this._journalContent = journalContent;
    }

    public void setJournalConverter(JournalConverter journalConverter) {
        this._journalConverter = journalConverter;
    }

    protected JournalArticleDisplay getArticleDisplay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        boolean workflowAssetPreview = GetterUtil.getBoolean((Object)httpServletRequest.getAttribute("WORKFLOW_ASSET_PREVIEW"));
        String ddmTemplateKey = (String)httpServletRequest.getAttribute("JOURNAL_TEMPLATE_ID");
        if (Validator.isNull((String)ddmTemplateKey)) {
            ddmTemplateKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"ddmTemplateKey");
        }
        String viewMode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"viewMode", (String)"view");
        String languageId = LanguageUtil.getLanguageId((HttpServletRequest)httpServletRequest);
        int articlePage = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"page", (int)1);
        PortletRequestModel portletRequestModel = this.getPortletRequestModel(httpServletRequest, httpServletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!workflowAssetPreview && this._article.isApproved()) {
            return this._journalContent.getDisplay(this._article.getGroupId(), this._article.getArticleId(), this._article.getVersion(), ddmTemplateKey, viewMode, languageId, articlePage, portletRequestModel, themeDisplay);
        }
        return JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)this._article, (String)ddmTemplateKey, (String)viewMode, (String)languageId, (int)articlePage, (PortletRequestModel)portletRequestModel, (ThemeDisplay)themeDisplay);
    }

    protected String getHitLayoutURL(boolean privateLayout, String noSuchEntryRedirect, ThemeDisplay themeDisplay) throws PortalException {
        List hitLayoutIds = JournalContentSearchLocalServiceUtil.getLayoutIds((long)this._article.getGroupId(), (boolean)privateLayout, (String)this._article.getArticleId());
        for (Long hitLayoutId : hitLayoutIds) {
            Layout hitLayout = LayoutLocalServiceUtil.getLayout((long)this._article.getGroupId(), (boolean)privateLayout, (long)hitLayoutId);
            if (!LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)hitLayout, (String)"VIEW")) continue;
            return PortalUtil.getLayoutURL((Layout)hitLayout, (ThemeDisplay)themeDisplay);
        }
        return noSuchEntryRedirect;
    }

    protected PortletRequestModel getPortletRequestModel(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            return null;
        }
        return new PortletRequestModel(portletRequest, portletResponse);
    }

    @Deprecated
    protected void setJournalServiceConfiguration() {
    }

    private boolean _isShowDisplayPage(long groupId, JournalArticle article) throws PortalException {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        AssetEntry assetEntry = assetRendererFactory.getAssetEntry(JournalArticle.class.getName(), this.getClassPK());
        boolean hasDisplayPage = AssetDisplayPageHelper.hasAssetDisplayPage((long)groupId, (AssetEntry)assetEntry);
        return !Validator.isNull((String)article.getLayoutUuid()) || hasDisplayPage;
    }
}

