Liferay.Loader.define("journal-web@3.0.105/js/MoveEntries.es", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _frontendJsWeb = require("frontend-js-web");

  var _metalState = require("frontend-js-metal-web$metal-state");

  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * @class MoveEntries
   * It adds a listener to a #selectFolderButton DOM element
   * and allows selecting a directory with itemSelector
   * @review
   */
  var MoveEntries = /*#__PURE__*/function (_PortletBase) {
    _inherits(MoveEntries, _PortletBase);

    function MoveEntries() {
      _classCallCheck(this, MoveEntries);

      return _possibleConstructorReturn(this, _getPrototypeOf(MoveEntries).apply(this, arguments));
    }

    _createClass(MoveEntries, [{
      key: "created",

      /**
       * @inheritdoc
       * @review
       */
      value: function created() {
        var selectFolderButton = document.getElementById(this.ns('selectFolderButton'));

        if (selectFolderButton) {
          this._handleSelectFolderButtonClick = this._handleSelectFolderButtonClick.bind(this);
          selectFolderButton.addEventListener('click', this._handleSelectFolderButtonClick);
        }
      }
      /**
       * @inheritdoc
       * @review
       */

    }, {
      key: "disposed",
      value: function disposed() {
        var selectFolderButton = document.getElementById(this.ns('selectFolderButton'));

        if (selectFolderButton) {
          selectFolderButton.removeEventListener('click', this._handleSelectFolderButtonClick);
        }
      }
      /**
       * @private
       * @review
       */

    }, {
      key: "_handleSelectFolderButtonClick",
      value: function _handleSelectFolderButtonClick() {
        var _this = this;

        var itemSelectorDialog = new _frontendJsWeb.ItemSelectorDialog({
          buttonAddLabel: Liferay.Language.get('done'),
          eventName: this.ns('selectFolder'),
          title: Liferay.Language.get('select-folder'),
          url: this.selectFolderURL
        });
        itemSelectorDialog.on('selectedItemChange', function (event) {
          var selectedItem = event.selectedItem;

          if (selectedItem) {
            var folderData = {
              idString: 'newFolderId',
              idValue: selectedItem.folderId,
              nameString: 'folderName',
              nameValue: selectedItem.folderName
            };
            Liferay.Util.selectFolder(folderData, _this.namespace || _this.portletNamespace);
          }
        });
        itemSelectorDialog.open();
      }
    }]);

    return MoveEntries;
  }(_frontendJsWeb.PortletBase);
  /**
   * @memberof MoveEntries
   * @review
   * @static
   */

  MoveEntries.STATE = {
    /**
     * @default undefined
     * @memberof MoveEntries
     * @required
     * @review
     * @type {string}
     */
    selectFolderURL: _metalState.Config.string().required()
  };
  var _default = MoveEntries;
  exports["default"] = _default;
  //# sourceMappingURL=MoveEntries.es.js.map
});
//# sourceMappingURL=MoveEntries.es.js.map