Liferay.Loader.define("journal-web@2.0.94/js/SelectFolder.es", ['module', 'exports', 'require', 'frontend-taglib/cards_treeview/CardsTreeview.es', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-web/liferay/PortletBase.es', 'frontend-js-metal-web$metal-soy', 'frontend-js-metal-web$metal-state', './SelectFolder.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  require("frontend-taglib/cards_treeview/CardsTreeview.es");

  require("frontend-js-metal-web$metal");

  require("frontend-js-metal-web$metal-component");

  var _PortletBase2 = _interopRequireDefault(require("frontend-js-web/liferay/PortletBase.es"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _SelectFolder = _interopRequireDefault(require("./SelectFolder.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * SelectFolder
   *
   * This component shows a list of available folders to move content in and
   * allows to filter them by searching.
   */
  var SelectFolder =
  /*#__PURE__*/
  function (_PortletBase) {
    _inherits(SelectFolder, _PortletBase);

    function SelectFolder() {
      _classCallCheck(this, SelectFolder);

      return _possibleConstructorReturn(this, _getPrototypeOf(SelectFolder).apply(this, arguments));
    }

    _createClass(SelectFolder, [{
      key: "filterSiblingNodes_",

      /**
       * Filters deep nested nodes based on a filtering value
       *
       * @type {Array.<Object>} nodes
       * @type {String} filterVAlue
       * @protected
       */
      value: function filterSiblingNodes_(nodes, filterValue) {
        var _this = this;

        var filteredNodes = [];
        nodes.forEach(function (node) {
          if (node.name.toLowerCase().indexOf(filterValue) !== -1) {
            filteredNodes.push(node);
          }

          if (node.children) {
            filteredNodes = filteredNodes.concat(_this.filterSiblingNodes_(node.children, filterValue));
          }
        });
        return filteredNodes;
      }
      /**
       * Searchs for nodes by name based on a filtering value
       *
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "searchNodes_",
      value: function searchNodes_(event) {
        if (!this.originalNodes) {
          this.originalNodes = this.nodes;
        } else {
          this.nodes = this.originalNodes;
        }

        var filterValue = event.delegateTarget.value.toLowerCase();

        if (filterValue !== '') {
          this.viewType = 'flat';
          this.nodes = this.filterSiblingNodes_(this.nodes, filterValue);
        } else {
          this.viewType = 'tree';
        }
      }
      /**
       * Fires item selector save event on selected node change
       *
       * @param {!Event} event
       * @protected
       */

    }, {
      key: "selectedNodeChange_",
      value: function selectedNodeChange_(event) {
        var node = event.newVal[0];

        if (node) {
          var data = {
            folderId: node.id,
            folderName: node.name
          };
          Liferay.Util.getOpener().Liferay.fire(this.itemSelectorSaveEvent, {
            data: data
          });
        }
      }
    }]);

    return SelectFolder;
  }(_PortletBase2["default"]);

  SelectFolder.STATE = {
    /**
     * Event name to fire on node selection
     * @type {String}
     */
    itemSelectorSaveEvent: _metalState.Config.string(),

    /**
     * List of nodes
     * @type {Array.<Object>}
     */
    nodes: _metalState.Config.array().required(),

    /**
     * Theme images root path
     * @type {String}
     */
    pathThemeImages: _metalState.Config.string().required(),

    /**
     * Type of view to render. Accepted values are 'tree' and 'flat'
     * @type {String}
     */
    viewType: _metalState.Config.string().value('tree')
  };

  _metalSoy["default"].register(SelectFolder, _SelectFolder["default"]);

  var _default = SelectFolder;
  exports["default"] = _default;
  //# sourceMappingURL=SelectFolder.es.js.map
});
//# sourceMappingURL=SelectFolder.es.js.map