Liferay.Loader.define("journal-web@2.0.40/js/SelectFolder.es", ['exports', 'frontend-js-web/liferay/PortletBase.es', 'metal-soy/src/Soy', 'metal-state/src/all/state', './SelectFolder.soy', 'frontend-taglib/cards_treeview/CardsTreeview.es', 'metal/src/metal', 'metal-component/src/all/component'], function (exports, _PortletBase2, _Soy, _state, _SelectFolder) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _PortletBase3 = _interopRequireDefault(_PortletBase2);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _SelectFolder2 = _interopRequireDefault(_SelectFolder);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var SelectFolder = function (_PortletBase) {
		_inherits(SelectFolder, _PortletBase);

		function SelectFolder() {
			_classCallCheck(this, SelectFolder);

			return _possibleConstructorReturn(this, (SelectFolder.__proto__ || Object.getPrototypeOf(SelectFolder)).apply(this, arguments));
		}

		_createClass(SelectFolder, [{
			key: 'filterSiblingNodes_',
			value: function filterSiblingNodes_(nodes, filterValue) {
				var _this2 = this;

				var filteredNodes = [];

				nodes.forEach(function (node) {
					if (node.name.toLowerCase().indexOf(filterValue) !== -1) {
						filteredNodes.push(node);
					}

					if (node.children) {
						filteredNodes = filteredNodes.concat(_this2.filterSiblingNodes_(node.children, filterValue));
					}
				});

				return filteredNodes;
			}
		}, {
			key: 'searchNodes_',
			value: function searchNodes_(event) {
				if (!this.originalNodes) {
					this.originalNodes = this.nodes;
				} else {
					this.nodes = this.originalNodes;
				}

				var filterValue = event.delegateTarget.value.toLowerCase();

				if (filterValue !== '') {
					this.viewType = 'flat';
					this.nodes = this.filterSiblingNodes_(this.nodes, filterValue);
				} else {
					this.viewType = 'tree';
				}
			}
		}, {
			key: 'selectedNodeChange_',
			value: function selectedNodeChange_(event) {
				var node = event.newVal[0];

				if (node) {
					var data = {
						folderId: node.id,
						folderName: node.name
					};

					Liferay.Util.getOpener().Liferay.fire(this.itemSelectorSaveEvent, {
						data: data
					});
				}
			}
		}]);

		return SelectFolder;
	}(_PortletBase3.default);

	SelectFolder.STATE = {

		/**
   * Event name to fire on node selection
   * @type {String}
   */

		itemSelectorSaveEvent: _state.Config.string(),

		/**
   * List of nodes
   * @type {Array.<Object>}
   */

		nodes: _state.Config.array().required(),

		/**
   * Theme images root path
   * @type {String}
   */

		pathThemeImages: _state.Config.string().required(),

		/**
   * Type of view to render. Accepted values are 'tree' and 'flat'
   * @type {String}
   */

		viewType: _state.Config.string().value('tree')
	};

	_Soy2.default.register(SelectFolder, _SelectFolder2.default);

	exports.default = SelectFolder;
});
//# sourceMappingURL=SelectFolder.es.js.map
