/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.configuration.JournalGroupServiceConfiguration;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portal.kernel.diff.DiffVersion;
import com.liferay.portal.kernel.diff.DiffVersionsInfo;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.subscription.service.SubscriptionLocalServiceUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

public class JournalUtil {
    public static final int MAX_STACK_SIZE = 20;
    private static final Log _log = LogFactoryUtil.getLog(JournalUtil.class);

    public static void addRecentArticle(PortletRequest portletRequest, JournalArticle article) {
        if (article != null) {
            Stack<JournalArticle> stack = JournalUtil._getRecentArticles(portletRequest);
            stack.push(article);
        }
    }

    public static DiffVersionsInfo getDiffVersionsInfo(long groupId, String articleId, double sourceVersion, double targetVersion) {
        double previousVersion = 0.0;
        double nextVersion = 0.0;
        List articles = JournalArticleServiceUtil.getArticlesByArticleId((long)groupId, (String)articleId, (int)-1, (int)-1, (OrderByComparator)new ArticleVersionComparator(true));
        for (JournalArticle article : articles) {
            if (article.getVersion() < sourceVersion && article.getVersion() > previousVersion) {
                previousVersion = article.getVersion();
            }
            if (!(article.getVersion() > targetVersion) || !(article.getVersion() < nextVersion) && nextVersion != 0.0) continue;
            nextVersion = article.getVersion();
        }
        ArrayList<DiffVersion> diffVersions = new ArrayList<DiffVersion>();
        for (JournalArticle article : articles) {
            DiffVersion diffVersion = new DiffVersion(article.getUserId(), article.getVersion(), article.getModifiedDate());
            diffVersions.add(diffVersion);
        }
        return new DiffVersionsInfo(diffVersions, nextVersion, previousVersion);
    }

    public static boolean getEmailArticleAnyEventEnabled(JournalGroupServiceConfiguration journalGroupServiceConfiguration) {
        return journalGroupServiceConfiguration.emailArticleAddedEnabled() || journalGroupServiceConfiguration.emailArticleApprovalDeniedEnabled() || journalGroupServiceConfiguration.emailArticleApprovalGrantedEnabled() || journalGroupServiceConfiguration.emailArticleApprovalRequestedEnabled() || journalGroupServiceConfiguration.emailArticleReviewEnabled() || journalGroupServiceConfiguration.emailArticleUpdatedEnabled();
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName) {
        return JournalUtil.getEmailDefinitionTerms(portletRequest, emailFromAddress, emailFromName, "");
    }

    public static Map<String, String> getEmailDefinitionTerms(PortletRequest portletRequest, String emailFromAddress, String emailFromName, String emailType) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String fromAddress = HtmlUtil.escape((String)emailFromAddress);
        String fromName = HtmlUtil.escape((String)emailFromName);
        String toAddress = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-recipient");
        String toName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-recipient");
        if (emailType.equals("requested")) {
            toName = fromName;
            toAddress = fromAddress;
            fromName = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-name-of-the-email-sender");
            fromAddress = LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-address-of-the-email-sender");
        }
        LinkedHashMap<String, String> definitionTerms = new LinkedHashMap<String, String>();
        definitionTerms.put("[$ARTICLE_CONTENT]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content"));
        definitionTerms.put("[$ARTICLE_DIFFS$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-compared-with-the-previous-version-web-content"));
        definitionTerms.put("[$ARTICLE_ID$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-id"));
        definitionTerms.put("[$ARTICLE_TITLE$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-title"));
        definitionTerms.put("[$ARTICLE_URL$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-url"));
        definitionTerms.put("[$ARTICLE_VERSION$]", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"the-web-content-version"));
        definitionTerms.put("[$FROM_ADDRESS$]", fromAddress);
        definitionTerms.put("[$FROM_NAME$]", fromName);
        Company company = themeDisplay.getCompany();
        definitionTerms.put("[$PORTAL_URL$]", company.getVirtualHostname());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        definitionTerms.put("[$PORTLET_NAME$]", HtmlUtil.escape((String)portletDisplay.getTitle()));
        definitionTerms.put("[$TO_ADDRESS$]", toAddress);
        definitionTerms.put("[$TO_NAME$]", toName);
        return definitionTerms;
    }

    public static long getPreviewPlid(JournalArticle article, ThemeDisplay themeDisplay) throws Exception {
        Layout layout;
        if (article != null && (layout = article.getLayout()) != null) {
            return layout.getPlid();
        }
        layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)false, (long)0L);
        if (layout == null) {
            layout = LayoutLocalServiceUtil.fetchFirstLayout((long)themeDisplay.getScopeGroupId(), (boolean)true, (long)0L);
        }
        if (layout != null) {
            return layout.getPlid();
        }
        return themeDisplay.getPlid();
    }

    public static boolean isIncludeVersionHistory() {
        try {
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)CompanyThreadLocal.getCompanyId());
            return journalServiceConfiguration.singleAssetPublishIncludeVersionHistory();
        }
        catch (ConfigurationException ce) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to retrieve journal service configuration", (Throwable)ce);
            }
            return false;
        }
    }

    public static boolean isSubscribedToArticle(long companyId, long groupId, long userId, long articleId) {
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)JournalArticle.class.getName(), (long)articleId);
    }

    public static boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId) throws PortalException {
        return JournalUtil.isSubscribedToFolder(companyId, groupId, userId, folderId, true);
    }

    public static boolean isSubscribedToFolder(long companyId, long groupId, long userId, long folderId, boolean recursive) throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        if (folderId != 0L) {
            JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
            ancestorFolderIds.add(folderId);
            if (recursive) {
                ancestorFolderIds.addAll(folder.getAncestorFolderIds());
                ancestorFolderIds.add(groupId);
            }
        } else {
            ancestorFolderIds.add(groupId);
        }
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)JournalFolder.class.getName(), (long[])ArrayUtil.toLongArray(ancestorFolderIds));
    }

    public static boolean isSubscribedToStructure(long companyId, long groupId, long userId, long ddmStructureId) {
        return SubscriptionLocalServiceUtil.isSubscribed((long)companyId, (long)userId, (String)DDMStructure.class.getName(), (long)ddmStructureId);
    }

    public static void removeRecentArticle(PortletRequest portletRequest, String articleId, double version) {
        Stack<JournalArticle> stack = JournalUtil._getRecentArticles(portletRequest);
        Iterator itr = stack.iterator();
        while (itr.hasNext()) {
            JournalArticle journalArticle = (JournalArticle)itr.next();
            String journalArticleId = journalArticle.getArticleId();
            if (!journalArticleId.equals(articleId) || journalArticle.getVersion() != version && version != 0.0) continue;
            itr.remove();
        }
    }

    private static Stack<JournalArticle> _getRecentArticles(PortletRequest portletRequest) {
        PortletSession portletSession = portletRequest.getPortletSession();
        FiniteUniqueStack recentArticles = (FiniteUniqueStack)portletSession.getAttribute("JOURNAL_RECENT_ARTICLES");
        if (recentArticles == null) {
            recentArticles = new FiniteUniqueStack(20);
            portletSession.setAttribute("JOURNAL_RECENT_ARTICLES", recentArticles);
        }
        return recentArticles;
    }

    public static class FiniteUniqueStack<E>
    extends Stack<E> {
        private final int _maxSize;

        @Override
        public E push(E item) {
            if (this.contains(item)) {
                if (!item.equals(this.peek())) {
                    this.remove(item);
                    super.push(item);
                }
            } else if (this.size() < this._maxSize) {
                super.push(item);
            }
            return item;
        }

        private FiniteUniqueStack(int maxSize) {
            this._maxSize = maxSize;
        }
    }
}

