/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.util;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.util.comparator.ArticleCreateDateComparator;
import com.liferay.journal.util.comparator.ArticleDisplayDateComparator;
import com.liferay.journal.util.comparator.ArticleIDComparator;
import com.liferay.journal.util.comparator.ArticleModifiedDateComparator;
import com.liferay.journal.util.comparator.ArticleReviewDateComparator;
import com.liferay.journal.util.comparator.ArticleTitleComparator;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.journal.web.internal.util.JournalHelperUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalPortletUtil {
    public static void addPortletBreadcrumbEntries(JournalArticle article, HttpServletRequest request, PortletURL portletURL) throws Exception {
        JournalFolder folder = article.getFolder();
        if (folder.getFolderId() != 0L) {
            JournalPortletUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
        }
        JournalArticle unescapedArticle = article.toUnescapedModel();
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        portletURL.setParameter("groupId", String.valueOf(article.getGroupId()));
        portletURL.setParameter("articleId", String.valueOf(article.getArticleId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedArticle.getTitle(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(JournalFolder folder, HttpServletRequest request, PortletURL portletURL) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String mvcPath = ParamUtil.getString((HttpServletRequest)request, (String)"mvcPath");
        portletURL.setParameter("folderId", String.valueOf(0L));
        if (mvcPath.equals("/select_folder.jsp")) {
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", 0L);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        }
        if (folder == null) {
            return;
        }
        List ancestorFolders = folder.getAncestors();
        Collections.reverse(ancestorFolders);
        for (JournalFolder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        portletURL.setParameter("folderId", String.valueOf(folder.getFolderId()));
        if (folder.getFolderId() != 0L) {
            JournalFolder unescapedFolder = folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, PortletURL portletURL) throws Exception {
        if (folderId == 0L) {
            return;
        }
        JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)folderId);
        JournalPortletUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public static String getAddMenuFavItemKey(PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"folderId");
        String key = "journal-add-menu-fav-items-" + themeDisplay.getScopeGroupId();
        if ((folderId = JournalPortletUtil.getAddMenuFavItemFolderId(folderId)) <= 0L) {
            return key;
        }
        return key + "-" + folderId;
    }

    public static OrderByComparator<JournalArticle> getArticleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        ArticleCreateDateComparator orderByComparator = null;
        if (orderByCol.equals("create-date")) {
            orderByComparator = new ArticleCreateDateComparator(orderByAsc);
        } else if (orderByCol.equals("display-date")) {
            orderByComparator = new ArticleDisplayDateComparator(orderByAsc);
        } else if (orderByCol.equals("id")) {
            orderByComparator = new ArticleIDComparator(orderByAsc);
        } else if (orderByCol.equals("modified-date")) {
            orderByComparator = new ArticleModifiedDateComparator(orderByAsc);
        } else if (orderByCol.equals("review-date")) {
            orderByComparator = new ArticleReviewDateComparator(orderByAsc);
        } else if (orderByCol.equals("title")) {
            orderByComparator = new ArticleTitleComparator(orderByAsc);
        } else if (orderByCol.equals("version")) {
            orderByComparator = new ArticleVersionComparator(orderByAsc);
        }
        return orderByComparator;
    }

    protected static long getAddMenuFavItemFolderId(long folderId) throws PortalException {
        if (folderId <= 0L) {
            return 0L;
        }
        for (JournalFolder folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId); folder != null; folder = folder.getParentFolder()) {
            int restrictionType = JournalHelperUtil.getRestrictionType(folder.getFolderId());
            if (restrictionType != 1) continue;
            return folder.getFolderId();
        }
        return 0L;
    }
}

