/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.util;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.ExportArticleHelper;
import com.liferay.journal.util.JournalContent;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExportArticleHelper.class})
public class ExportArticleHelperImpl
implements ExportArticleHelper {
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private Portal _portal;

    public void sendFile(String targetExtension, PortletRequest portletRequest, PortletResponse portletResponse) throws IOException {
        if (Validator.isNull((String)targetExtension)) {
            return;
        }
        HttpServletRequest request = this._portal.getHttpServletRequest(portletRequest);
        HttpServletResponse response = this._portal.getHttpServletResponse(portletResponse);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)portletRequest, (String)"articleId");
        String languageId = LanguageUtil.getLanguageId((PortletRequest)portletRequest);
        PortletRequestModel portletRequestModel = new PortletRequestModel(portletRequest, portletResponse);
        JournalArticle article = this._journalArticleLocalService.fetchLatestArticle(groupId, articleId, 0);
        JournalArticleDisplay articleDisplay = this._journalContent.getDisplay(groupId, articleId, article.getVersion(), null, "export", languageId, 1, portletRequestModel, themeDisplay);
        int pages = articleDisplay.getNumberOfPages();
        StringBundler sb = new StringBundler(pages + 12);
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta content=\"");
        sb.append("text/html; charset=UTF-8");
        sb.append("\" http-equiv=\"content-type\" />");
        sb.append("<base href=\"");
        sb.append(themeDisplay.getPortalURL());
        sb.append("\" />");
        sb.append("</head>");
        sb.append("<body>");
        sb.append(articleDisplay.getContent());
        for (int i = 2; i <= pages; ++i) {
            articleDisplay = this._journalContent.getDisplay(groupId, articleId, "export", languageId, i, themeDisplay);
            sb.append(articleDisplay.getContent());
        }
        sb.append("</body>");
        sb.append("</html>");
        String s = sb.toString();
        Object is = new UnsyncByteArrayInputStream(s.getBytes("UTF-8"));
        String title = articleDisplay.getTitle();
        String sourceExtension = "html";
        String fileName = title.concat(".").concat(sourceExtension);
        String contentType = "text/html";
        sb = new StringBundler(3);
        sb.append(PrincipalThreadLocal.getUserId());
        sb.append("_");
        String tempFileId = DLUtil.getTempFileId((long)articleDisplay.getId(), (String)String.valueOf(articleDisplay.getVersion()), (String)languageId);
        sb.append(tempFileId);
        File convertedFile = DocumentConversionUtil.convert((String)sb.toString(), (InputStream)is, (String)sourceExtension, (String)targetExtension);
        if (convertedFile != null) {
            targetExtension = StringUtil.toLowerCase((String)targetExtension);
            fileName = title.concat(".").concat(targetExtension);
            contentType = MimeTypesUtil.getContentType((String)fileName);
            is = new FileInputStream(convertedFile);
        }
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (String)contentType);
    }
}

