/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.webdav;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.webdav.DDMWebDAV;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.webdav.BaseWebDAVStorageImpl;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "webdav.storage.token=journal"}, service={WebDAVStorage.class})
public class JournalWebDAVStorageImpl
extends BaseWebDAVStorageImpl {
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private DDMWebDAV _ddmWebDAV;
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;

    public int deleteResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.deleteResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(JournalArticle.class));
    }

    public Resource getResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.getResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(JournalArticle.class));
    }

    public List<Resource> getResources(WebDAVRequest webDAVRequest) throws WebDAVException {
        try {
            String[] pathArray = webDAVRequest.getPathArray();
            if (pathArray.length == 2) {
                return this.getFolders(webDAVRequest);
            }
            if (pathArray.length == 3) {
                String type = pathArray[2];
                if (type.equals("Structures")) {
                    return this.getStructures(webDAVRequest);
                }
                if (type.equals("Templates")) {
                    return this.getTemplates(webDAVRequest);
                }
            }
            return new ArrayList<Resource>();
        }
        catch (Exception e) {
            throw new WebDAVException((Throwable)e);
        }
    }

    public int putResource(WebDAVRequest webDAVRequest) throws WebDAVException {
        return this._ddmWebDAV.putResource(webDAVRequest, this.getRootPath(), this.getToken(), this._portal.getClassNameId(JournalArticle.class));
    }

    protected List<Resource> getFolders(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(this._ddmWebDAV.toResource(webDAVRequest, "Structures", this.getRootPath(), true));
        resources.add(this._ddmWebDAV.toResource(webDAVRequest, "Templates", this.getRootPath(), true));
        return resources;
    }

    protected List<Resource> getStructures(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmStructures = this._journalFolderService.getDDMStructures(new long[]{webDAVRequest.getGroupId()}, 0L, 0);
        for (DDMStructure ddmStructure : ddmStructures) {
            Resource resource = this._ddmWebDAV.toResource(webDAVRequest, ddmStructure, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    protected List<Resource> getTemplates(WebDAVRequest webDAVRequest) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List ddmTemplates = this._ddmTemplateLocalService.getTemplatesByStructureClassNameId(webDAVRequest.getGroupId(), this._portal.getClassNameId(JournalArticle.class), 0, -1, -1, null);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            Resource resource = this._ddmWebDAV.toResource(webDAVRequest, ddmTemplate, this.getRootPath(), true);
            resources.add(resource);
        }
        return resources;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMWebDAV(DDMWebDAV ddmWebDAV) {
        this._ddmWebDAV = ddmWebDAV;
    }

    @Reference(unbind="-")
    protected void setJournalFolderService(JournalFolderService journalFolderService) {
        this._journalFolderService = journalFolderService;
    }
}

