/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.upload;

import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.journal.configuration.JournalFileUploadsConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.upload.UniqueFileNameProvider;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.journal.configuration.JournalFileUploadsConfiguration"}, immediate=true, service={ImageJournalUploadFileEntryHandler.class})
public class ImageJournalUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    private static final String _TEMP_FOLDER_NAME = ImageJournalUploadFileEntryHandler.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(ImageJournalUploadFileEntryHandler.class);
    @Reference
    private DLValidator _dlValidator;
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;
    private JournalFileUploadsConfiguration _journalFileUploadsConfiguration;
    private ModelResourcePermission<JournalFolder> _journalFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.journal)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long resourcePrimKey = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"resourcePrimKey");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        if (resourcePrimKey != 0L) {
            this._journalArticleModelResourcePermission.check(themeDisplay.getPermissionChecker(), resourcePrimKey, "UPDATE");
        } else if (folderId != 0L) {
            this._journalFolderModelResourcePermission.check(themeDisplay.getPermissionChecker(), folderId, "ADD_ARTICLE");
        } else {
            this._portletResourcePermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup(), "ADD_ARTICLE");
        }
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        long size = uploadPortletRequest.getSize(_PARAMETER_NAME);
        this._validateFile(fileName, size);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            String uniqueFileName = this._uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay, (String)curFileName));
            FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)uniqueFileName, (InputStream)inputStream, (String)contentType);
            return fileEntry;
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._journalFileUploadsConfiguration = (JournalFileUploadsConfiguration)ConfigurableUtil.createConfigurable(JournalFileUploadsConfiguration.class, properties);
    }

    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)", unbind="-")
    protected void setJournalArticleModelResourcePermission(ModelResourcePermission<JournalArticle> modelResourcePermission) {
        this._journalArticleModelResourcePermission = modelResourcePermission;
    }

    @Reference(target="(model.class.name=com.liferay.journal.model.JournalFolder)", unbind="-")
    protected void setJournalFolderModelResourcePermission(ModelResourcePermission<JournalFolder> modelResourcePermission) {
        this._journalFolderModelResourcePermission = modelResourcePermission;
    }

    private boolean _exists(ThemeDisplay themeDisplay, String curFileName) {
        try {
            return TempFileEntryUtil.getTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)_TEMP_FOLDER_NAME, (String)curFileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }

    private void _validateFile(String fileName, long size) throws PortalException {
        this._dlValidator.validateFileSize(fileName, size);
        String extension = FileUtil.getExtension((String)fileName);
        for (String imageExtension : this._journalFileUploadsConfiguration.imageExtensions()) {
            if (!"*".equals(imageExtension) && !imageExtension.equals("." + extension)) continue;
            return;
        }
        throw new ImageTypeException("Invalid image type for file name " + fileName);
    }
}

