/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.search;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.web.internal.display.context.JournalDisplayContext;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.trash.TrashHelper;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class EntriesChecker
extends EmptyOnClickRowChecker {
    private final JournalDisplayContext _journalDisplayContext;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PermissionChecker _permissionChecker;

    public EntriesChecker(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, TrashHelper trashHelper) {
        super((PortletResponse)liferayPortletResponse);
        this._journalDisplayContext = new JournalDisplayContext(PortalUtil.getHttpServletRequest((PortletRequest)liferayPortletRequest), liferayPortletRequest, liferayPortletResponse, liferayPortletRequest.getPreferences(), trashHelper);
        this._liferayPortletResponse = liferayPortletResponse;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
    }

    public String getAllRowsCheckBox() {
        return null;
    }

    public String getAllRowsCheckBox(HttpServletRequest request) {
        return null;
    }

    public String getRowCheckBox(HttpServletRequest request, boolean checked, boolean disabled, String primaryKey) {
        if (!this._journalDisplayContext.isShowEditActions()) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JournalFolder folder = null;
        String articleId = GetterUtil.getString((String)primaryKey);
        JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)themeDisplay.getScopeGroupId(), (String)articleId);
        if (article == null) {
            long folderId = GetterUtil.getLong((String)primaryKey);
            folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId);
        }
        String name = null;
        boolean showInput = false;
        if (article != null) {
            name = JournalArticle.class.getSimpleName();
            try {
                if (JournalArticlePermission.contains(this._permissionChecker, article, "DELETE") || JournalArticlePermission.contains(this._permissionChecker, article, "EXPIRE") || JournalArticlePermission.contains(this._permissionChecker, article, "UPDATE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {}
        } else if (folder != null) {
            name = JournalFolder.class.getSimpleName();
            try {
                if (JournalFolderPermission.contains(this._permissionChecker, folder, "DELETE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!showInput) {
            return "";
        }
        StringBundler sb = new StringBundler(9);
        sb.append("['");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(JournalFolder.class.getSimpleName());
        sb.append("', '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(JournalArticle.class.getSimpleName());
        sb.append("']");
        String checkBoxRowIds = sb.toString();
        return this.getRowCheckBox(request, checked, disabled, StringBundler.concat((String[])new String[]{this._liferayPortletResponse.getNamespace(), "rowIds", name, ""}), primaryKey, checkBoxRowIds, "'#" + this.getAllRowIds() + "'", "");
    }
}

