/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet.action;

import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.web.util.JournalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "mvc.command.name=/journal/publish_folder"}, service={MVCActionCommand.class})
public class PublishFolderMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishFolderMVCActionCommand.class);
    @Reference
    private ExportImportChangesetMVCActionCommand _exportImportChangesetMVCActionCommand;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        Changeset.Builder builder = Changeset.create();
        Changeset changeset = builder.addStagedModel(() -> this._journalFolderLocalService.fetchJournalFolder(folderId)).addStagedModelHierarchy(() -> this._journalFolderLocalService.fetchJournalFolder(folderId), journalFolder -> this._getFoldersAndArticles((JournalFolder)journalFolder)).build();
        this._exportImportChangesetMVCActionCommand.processPublishAction(actionRequest, actionResponse, changeset);
    }

    private List<StagedModel> _getFoldersAndArticles(JournalFolder journalFolder) {
        ArrayList<StagedModel> stagedModels;
        block9: {
            if (journalFolder == null) {
                return Collections.emptyList();
            }
            stagedModels = new ArrayList<StagedModel>();
            try {
                List childObjects = this._journalFolderLocalService.getFoldersAndArticles(journalFolder.getGroupId(), journalFolder.getFolderId());
                for (Object childObject : childObjects) {
                    if (childObject instanceof JournalFolder) {
                        JournalFolder childJournalFolder = (JournalFolder)childObject;
                        stagedModels.add((StagedModel)childJournalFolder);
                        stagedModels.addAll(this._getFoldersAndArticles(childJournalFolder));
                        continue;
                    }
                    if (childObject instanceof JournalArticle) {
                        JournalArticle journalArticle = (JournalArticle)childObject;
                        boolean includeVersionHistory = JournalUtil.isIncludeVersionHistory();
                        StagedModelDataHandler<JournalArticle> stagedModelDataHandler = this._getStagedModelDataHandler();
                        ArrayList<JournalArticle> journalArticles = new ArrayList<JournalArticle>();
                        if (includeVersionHistory) {
                            journalArticles.addAll(this._journalArticleLocalService.getArticles(journalArticle.getGroupId(), journalArticle.getArticleId()));
                        } else {
                            journalArticles.add(this._journalArticleLocalService.getArticle(journalArticle.getGroupId(), journalArticle.getArticleId()));
                        }
                        for (JournalArticle curJournalArticle : journalArticles) {
                            if (!ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)curJournalArticle.getStatus())) continue;
                            stagedModels.add((StagedModel)curJournalArticle);
                        }
                        continue;
                    }
                    stagedModels.add((StagedModel)childObject);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn((Object)("Unable to get folders and articles for folder " + journalFolder.getFolderId()), (Throwable)pe);
            }
        }
        return stagedModels;
    }

    private StagedModelDataHandler<JournalArticle> _getStagedModelDataHandler() {
        return StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)JournalArticle.class.getName());
    }
}

