/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.portlet.action;

import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.web.util.JournalUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet", "mvc.command.name=/journal/publish_article"}, service={MVCActionCommand.class})
public class PublishArticleMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishArticleMVCActionCommand.class);
    @Reference
    private ExportImportChangesetMVCActionCommand _exportImportChangesetMVCActionCommand;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderLocalService _journalFolderLocalService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        String articleId = ParamUtil.getString((PortletRequest)actionRequest, (String)"articleId");
        Changeset.Builder builder = Changeset.create();
        JournalArticle journalArticle = this._fetchArticle(groupId, articleId);
        Changeset changeset = builder.addStagedModel(() -> journalArticle).addMultipleStagedModel(() -> this._getJournalArticleVersions(journalArticle)).build();
        this._exportImportChangesetMVCActionCommand.processPublishAction(actionRequest, actionResponse, changeset);
    }

    private JournalArticle _fetchArticle(long groupId, String articleId) {
        block3: {
            JournalArticle journalArticle = this._journalArticleLocalService.fetchArticle(groupId, articleId);
            StagedModelDataHandler<JournalArticle> stagedModelDataHandler = this._getStagedModelDataHandler();
            try {
                JournalArticle latestApprovedJournalArticle = this._journalArticleLocalService.getArticle(journalArticle.getGroupId(), journalArticle.getArticleId());
                if (ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)latestApprovedJournalArticle.getStatus())) {
                    return latestApprovedJournalArticle;
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get journal article by group ", groupId, " and article ID ", articleId}), (Throwable)pe);
            }
        }
        return null;
    }

    private List<StagedModel> _getJournalArticleVersions(JournalArticle journalArticle) {
        boolean includeVersionHistory = JournalUtil.isIncludeVersionHistory();
        if (!includeVersionHistory) {
            return Collections.emptyList();
        }
        ArrayList<StagedModel> stagedModels = new ArrayList<StagedModel>();
        StagedModelDataHandler<JournalArticle> stagedModelDataHandler = this._getStagedModelDataHandler();
        ArrayList journalArticles = new ArrayList();
        journalArticles.addAll(this._journalArticleLocalService.getArticles(journalArticle.getGroupId(), journalArticle.getArticleId()));
        for (JournalArticle curJournalArticle : journalArticles) {
            if (!ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)curJournalArticle.getStatus())) continue;
            stagedModels.add((StagedModel)curJournalArticle);
        }
        return stagedModels;
    }

    private StagedModelDataHandler<JournalArticle> _getStagedModelDataHandler() {
        return StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)JournalArticle.class.getName());
    }
}

