/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.notifications;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.asset.JournalArticleAssetRenderer;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={UserNotificationHandler.class})
public class JournalUserNotificationHandler
extends BaseModelUserNotificationHandler {
    @Reference
    private Portal _portal;

    public JournalUserNotificationHandler() {
        this.setPortletId("com_liferay_journal_web_portlet_JournalPortlet");
    }

    protected String getTitle(JSONObject jsonObject, AssetRenderer<?> assetRenderer, ServiceContext serviceContext) {
        String title = "";
        ResourceBundleLoader resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.journal.lang");
        ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(serviceContext.getLocale());
        JournalArticleAssetRenderer journalArticleAssetRenderer = (JournalArticleAssetRenderer)assetRenderer;
        JournalArticle journalArticle = journalArticleAssetRenderer.getArticle();
        long userId = GetterUtil.getLong((Object)jsonObject.getLong("userId"), (long)journalArticle.getUserId());
        String userFullName = HtmlUtil.escape((String)this._portal.getUserName(userId, ""));
        int notificationType = jsonObject.getInt("notificationType");
        if (notificationType == 0) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-added-a-new-web-content-article", (Object[])new Object[]{userFullName});
        } else if (notificationType == 1) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-updated-a-web-content-article", (Object[])new Object[]{userFullName});
        } else if (notificationType == 2) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-moved-a-web-content-from-a-folder", (Object[])new Object[]{userFullName});
        } else if (notificationType == 4) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-restored-a-web-content-from-the-recycle-bin", (Object[])new Object[]{userFullName});
        } else if (notificationType == 3) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-moved-a-web-content-to-a-folder", (Object[])new Object[]{userFullName});
        } else if (notificationType == 5) {
            title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-moved-a-web-content-to-the-recycle-bin", (Object[])new Object[]{userFullName});
        }
        return title;
    }
}

