/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.journal.service.JournalFolderServiceUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalViewMoreMenuItemsDisplayContext {
    private List<DDMStructure> _ddmStructures;
    private SearchContainer _ddmStructuresSearchContainer;
    private String _eventName;
    private final long _folderId;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private final int _restrictionType;

    public JournalViewMoreMenuItemsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, long folderId, int restrictionType) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._folderId = folderId;
        this._restrictionType = restrictionType;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)this._renderRequest);
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        if (ListUtil.isNotEmpty(this._ddmStructures)) {
            return this._ddmStructures;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._ddmStructures = JournalFolderServiceUtil.searchDDMStructures((long)themeDisplay.getCompanyId(), (long[])PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId()), (long)this._folderId, (int)this._restrictionType, (String)this._getKeywords(), (int)-1, (int)-1, (OrderByComparator)this._getOrderByComparator());
        return this._ddmStructures;
    }

    public SearchContainer getDDMStructuresSearchContainer() throws PortalException {
        if (this._ddmStructuresSearchContainer != null) {
            return this._ddmStructuresSearchContainer;
        }
        this._ddmStructuresSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, "no-results-were-found");
        this._ddmStructuresSearchContainer.setOrderByCol(this.getOrderByCol());
        this._ddmStructuresSearchContainer.setOrderByComparator(this._getOrderByComparator());
        this._ddmStructuresSearchContainer.setOrderByType(this.getOrderByType());
        List<DDMStructure> ddmStructures = this.getDDMStructures();
        this._ddmStructuresSearchContainer.setTotal(ddmStructures.size());
        this._ddmStructuresSearchContainer.setResults(ddmStructures);
        return this._ddmStructuresSearchContainer;
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"eventName", (String)(this._renderResponse.getNamespace() + "selectAddMenuItem"));
        return this._eventName;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalViewMoreMenuItemsDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalViewMoreMenuItemsDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalViewMoreMenuItemsDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalViewMoreMenuItemsDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalViewMoreMenuItemsDisplayContext.this._request, (String)"all-menu-items"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_more_menu_items.jsp");
        portletURL.setParameter("folderId", String.valueOf(this._folderId));
        portletURL.setParameter("eventName", this.getEventName());
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect");
        return this._redirect;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() throws PortalException {
        SearchContainer searchContainer = this.getDDMStructuresSearchContainer();
        return searchContainer.getTotal();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)JournalViewMoreMenuItemsDisplayContext.this._renderResponse.createRenderURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalViewMoreMenuItemsDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private OrderByComparator _getOrderByComparator() {
        boolean orderByAsc = false;
        String orderByType = this.getOrderByType();
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        return new StructureModifiedDateComparator(orderByAsc);
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(JournalViewMoreMenuItemsDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalViewMoreMenuItemsDisplayContext.this._request, (String)"modified-date"));
                });
            }
        };
    }
}

