/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMTemplateServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalSelectDDMTemplateDisplayContext {
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private Long _structureId;
    private Long _templateId;
    private SearchContainer _templateSearch;

    public JournalSelectDDMTemplateDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getEventName() {
        return this._renderResponse.getNamespace() + "selectTemplate";
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalSelectDDMTemplateDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMTemplateDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalSelectDDMTemplateDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMTemplateDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_template.jsp");
        portletURL.setParameter("templateId", String.valueOf(this.getTemplateId()));
        portletURL.setParameter("structureId", String.valueOf(this._getStructureId()));
        portletURL.setParameter("eventName", this.getEventName());
        return portletURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this._getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public long getTemplateId() {
        if (this._templateId != null) {
            return this._templateId;
        }
        this._templateId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"templateId");
        return this._templateId;
    }

    public SearchContainer getTemplateSearch() throws Exception {
        if (this._templateSearch != null) {
            return this._templateSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer templateSearch = new SearchContainer((PortletRequest)this._renderRequest, this._getPortletURL(), null, "there-are-no-templates");
        if (templateSearch.isSearch()) {
            templateSearch.setEmptyResultsMessage("no-templates-were-found");
        }
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getTemplateOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        templateSearch.setOrderByCol(orderByCol);
        templateSearch.setOrderByComparator(orderByComparator);
        templateSearch.setOrderByType(orderByType);
        long[] groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId());
        int total = DDMTemplateServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long[])new long[]{PortalUtil.getClassNameId(DDMStructure.class)}, (long[])new long[]{this._getStructureId()}, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (String)"", (String)"", (int)-1);
        templateSearch.setTotal(total);
        List results = DDMTemplateServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])groupIds, (long[])new long[]{PortalUtil.getClassNameId(DDMStructure.class)}, (long[])new long[]{this._getStructureId()}, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (String)"", (String)"", (int)-1, (int)templateSearch.getStart(), (int)templateSearch.getEnd(), (OrderByComparator)templateSearch.getOrderByComparator());
        templateSearch.setResults(results);
        this._templateSearch = templateSearch;
        return this._templateSearch;
    }

    public int getTotalItems() throws Exception {
        SearchContainer searchContainer = this.getTemplateSearch();
        return searchContainer.getTotal();
    }

    public boolean isDisabledManagementBar() throws Exception {
        if (this.isSearch()) {
            return false;
        }
        return this.getTotalItems() <= 0;
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this._getKeywords());
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(JournalSelectDDMTemplateDisplayContext.this._getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMTemplateDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalSelectDDMTemplateDisplayContext.this.getOrderByCol(), "modified-date"));
                    dropdownItem.setHref(JournalSelectDDMTemplateDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMTemplateDisplayContext.this._request, (String)"modified-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalSelectDDMTemplateDisplayContext.this.getOrderByCol(), "id"));
                    dropdownItem.setHref(JournalSelectDDMTemplateDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "id"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMTemplateDisplayContext.this._request, (String)"id"));
                });
            }
        };
    }

    private PortletURL _getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        long structureId;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_template.jsp");
        long templateId = this.getTemplateId();
        if (templateId != 0L) {
            portletURL.setParameter("templateId", String.valueOf(templateId));
        }
        if ((structureId = this._getStructureId()) != 0L) {
            portletURL.setParameter("structureId", String.valueOf(structureId));
        }
        if (Validator.isNotNull((String)(keywords = this._getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    private long _getStructureId() {
        if (this._structureId != null) {
            return this._structureId;
        }
        this._structureId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"structureId");
        return this._structureId;
    }
}

