/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalServiceUtil;
import com.liferay.dynamic.data.mapping.service.DDMStructureServiceUtil;
import com.liferay.dynamic.data.mapping.util.DDMUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalSelectDDMStructureDisplayContext {
    private Long _classPK;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;
    private Boolean _searchRestriction;
    private Long _searchRestrictionClassNameId;
    private Long _searchRestrictionClassPK;
    private SearchContainer _structureSearch;

    public JournalSelectDDMStructureDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public long getClassPK() {
        if (this._classPK != null) {
            return this._classPK;
        }
        this._classPK = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"classPK");
        return this._classPK;
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this._getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public String getEventName() {
        return this._renderResponse.getNamespace() + "selectStructure";
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalSelectDDMStructureDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMStructureDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalSelectDDMStructureDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMStructureDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"modified-date");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_structure.jsp");
        portletURL.setParameter("classPK", String.valueOf(this.getClassPK()));
        portletURL.setParameter("eventName", this.getEventName());
        return portletURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this._getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public SearchContainer getStructureSearch() throws Exception {
        if (this._structureSearch != null) {
            return this._structureSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer structureSearch = new SearchContainer((PortletRequest)this._renderRequest, this._getPortletURL(), null, "there-are-no-structures");
        if (Validator.isNotNull((String)this._getKeywords())) {
            structureSearch.setEmptyResultsMessage("no-structures-were-found");
        }
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        OrderByComparator orderByComparator = DDMUtil.getStructureOrderByComparator((String)this.getOrderByCol(), (String)this.getOrderByType());
        structureSearch.setOrderByCol(orderByCol);
        structureSearch.setOrderByComparator(orderByComparator);
        structureSearch.setOrderByType(orderByType);
        long[] groupIds = PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId());
        int total = 0;
        total = this._isSearchRestriction() ? DDMStructureLinkLocalServiceUtil.getStructureLinksCount((long)this._getSearchRestrictionClassNameId(), (long)this._getSearchRestrictionClassPK()) : DDMStructureServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (int)-1);
        structureSearch.setTotal(total);
        List results = null;
        results = this._isSearchRestriction() ? DDMStructureLinkLocalServiceUtil.getStructureLinkStructures((long)this._getSearchRestrictionClassNameId(), (long)this._getSearchRestrictionClassPK(), (int)structureSearch.getStart(), (int)structureSearch.getEnd()) : DDMStructureServiceUtil.search((long)themeDisplay.getCompanyId(), (long[])groupIds, (long)PortalUtil.getClassNameId((String)JournalArticle.class.getName()), (String)this._getKeywords(), (int)-1, (int)structureSearch.getStart(), (int)structureSearch.getEnd(), (OrderByComparator)structureSearch.getOrderByComparator());
        structureSearch.setResults(results);
        this._structureSearch = structureSearch;
        return structureSearch;
    }

    public int getTotalItems() throws Exception {
        SearchContainer searchContainer = this.getStructureSearch();
        return searchContainer.getTotal();
    }

    public boolean isDisabledManagementBar() throws Exception {
        if (this.isSearch()) {
            return false;
        }
        return this.getTotalItems() <= 0;
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this._getKeywords());
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref(JournalSelectDDMStructureDisplayContext.this._getPortletURL(), new Object[]{"navigation", "all"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMStructureDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalSelectDDMStructureDisplayContext.this.getOrderByCol(), "modified-date"));
                    dropdownItem.setHref(JournalSelectDDMStructureDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMStructureDisplayContext.this._request, (String)"modified-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalSelectDDMStructureDisplayContext.this.getOrderByCol(), "id"));
                    dropdownItem.setHref(JournalSelectDDMStructureDisplayContext.this._getPortletURL(), new Object[]{"orderByCol", "id"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalSelectDDMStructureDisplayContext.this._request, (String)"id"));
                });
            }
        };
    }

    private PortletURL _getPortletURL() {
        String orderByType;
        String orderByCol;
        String keywords;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/select_structure.jsp");
        long classPK = this.getClassPK();
        if (classPK != 0L) {
            portletURL.setParameter("classPK", String.valueOf(classPK));
        }
        if (Validator.isNotNull((String)(keywords = this._getKeywords()))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    private long _getSearchRestrictionClassNameId() {
        if (this._searchRestrictionClassNameId != null) {
            return this._searchRestrictionClassNameId;
        }
        this._searchRestrictionClassNameId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchRestrictionClassNameId");
        return this._searchRestrictionClassNameId;
    }

    private long _getSearchRestrictionClassPK() {
        if (this._searchRestrictionClassPK != null) {
            return this._searchRestrictionClassPK;
        }
        this._searchRestrictionClassPK = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchRestrictionClassPK");
        return this._searchRestrictionClassPK;
    }

    private boolean _isSearchRestriction() {
        if (this._searchRestriction != null) {
            return this._searchRestriction;
        }
        this._searchRestriction = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"searchRestriction");
        return this._searchRestriction;
    }
}

