/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.service.JournalFolderServiceUtil;
import com.liferay.journal.web.asset.JournalArticleAssetRenderer;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalMoveEntriesDisplayContext {
    private final String _currentURL;
    private List<JournalArticle> _invalidMoveArticles;
    private List<JournalFolder> _invalidMoveFolders;
    private AssetRendererFactory _journalArticleAssetRendererFactory;
    private AssetRendererFactory _journalFolderAssetRendererFactory;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private long _newFolderId;
    private String _newFolderName;
    private PermissionChecker _permissionChecker;
    private String _redirect;
    private final HttpServletRequest _servletRequest;
    private List<JournalArticle> _validMoveArticles;
    private List<JournalFolder> _validMoveFolders;

    public JournalMoveEntriesDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String currentURL) throws PortalException {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._currentURL = currentURL;
        this._servletRequest = PortalUtil.getHttpServletRequest((PortletRequest)this._liferayPortletRequest);
        this.processFolders(this.getMoveFolders());
        this.processArticles(this.getMoveArticles());
        this.setViewAttributes();
    }

    public String getIconCssClass(JournalArticle article) throws PortalException {
        if (this._journalArticleAssetRendererFactory == null) {
            this._journalArticleAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        }
        AssetRenderer assetRenderer = this._journalArticleAssetRendererFactory.getAssetRenderer(JournalArticleAssetRenderer.getClassPK(article));
        return assetRenderer.getIconCssClass();
    }

    public String getIconCssClass(JournalFolder folder) throws PortalException {
        if (this._journalFolderAssetRendererFactory == null) {
            this._journalFolderAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalFolder.class);
        }
        AssetRenderer assetRenderer = this._journalFolderAssetRendererFactory.getAssetRenderer(folder.getFolderId());
        return assetRenderer.getIconCssClass();
    }

    public List<JournalArticle> getInvalidMoveArticles() {
        return this._invalidMoveArticles;
    }

    public List<JournalFolder> getInvalidMoveFolders() {
        return this._invalidMoveFolders;
    }

    public List<JournalArticle> getMoveArticles() throws PortalException {
        String[] articleIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<JournalArticle> articles = new ArrayList<JournalArticle>();
        for (String articleId : articleIds = ParamUtil.getStringValues((PortletRequest)this._liferayPortletRequest, (String)"rowIdsJournalArticle")) {
            JournalArticle article = JournalArticleServiceUtil.fetchArticle((long)themeDisplay.getScopeGroupId(), (String)articleId);
            if (article == null) continue;
            articles.add(article);
        }
        return articles;
    }

    public List<JournalFolder> getMoveFolders() throws PortalException {
        long[] folderIds = ParamUtil.getLongValues((PortletRequest)this._liferayPortletRequest, (String)"rowIdsJournalFolder");
        ArrayList<JournalFolder> folders = new ArrayList<JournalFolder>();
        for (long folderId : folderIds) {
            JournalFolder folder = JournalFolderServiceUtil.fetchFolder((long)folderId);
            if (folder == null) continue;
            folders.add(folder);
        }
        return folders;
    }

    public long getNewFolderId() {
        if (this._newFolderId > 0L) {
            return this._newFolderId;
        }
        this._newFolderId = ParamUtil.getLong((PortletRequest)this._liferayPortletRequest, (String)"newFolderId");
        return this._newFolderId;
    }

    public String getNewFolderName() throws PortalException {
        if (Validator.isNotNull((String)this._newFolderName)) {
            return this._newFolderName;
        }
        if (this.getNewFolderId() > 0L) {
            JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)this.getNewFolderId());
            this._newFolderName = folder.getName();
        } else {
            this._newFolderName = LanguageUtil.get((HttpServletRequest)this._servletRequest, (String)"home");
        }
        return this._newFolderName;
    }

    public PermissionChecker getPermissionChecker() {
        if (this._permissionChecker != null) {
            return this._permissionChecker;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
        return this._permissionChecker;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._liferayPortletRequest, (String)"redirect");
        return this._redirect;
    }

    public List<JournalArticle> getValidMoveArticles() {
        return this._validMoveArticles;
    }

    public List<JournalFolder> getValidMoveFolders() {
        return this._validMoveFolders;
    }

    public void processArticles(List<JournalArticle> articles) throws PortalException {
        this._validMoveArticles = new ArrayList<JournalArticle>();
        this._invalidMoveArticles = new ArrayList<JournalArticle>();
        for (JournalArticle curArticle : articles) {
            boolean hasUpdatePermission = JournalArticlePermission.contains(this.getPermissionChecker(), curArticle, "UPDATE");
            if (hasUpdatePermission) {
                this._validMoveArticles.add(curArticle);
                continue;
            }
            this._invalidMoveArticles.add(curArticle);
        }
    }

    public void processFolders(List<JournalFolder> folders) throws PortalException {
        this._validMoveFolders = new ArrayList<JournalFolder>();
        this._invalidMoveFolders = new ArrayList<JournalFolder>();
        for (JournalFolder curFolder : folders) {
            boolean hasUpdatePermission = JournalFolderPermission.contains(this.getPermissionChecker(), curFolder, "UPDATE");
            if (hasUpdatePermission) {
                this._validMoveFolders.add(curFolder);
                continue;
            }
            this._invalidMoveFolders.add(curFolder);
        }
    }

    public void setViewAttributes() {
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)this._servletRequest, (String)LanguageUtil.get((HttpServletRequest)this._servletRequest, (String)"move-web-content"), (String)this._currentURL);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        portletDisplay.setShowBackIcon(true);
        portletDisplay.setURLBack(this.getRedirect());
        if (this._liferayPortletResponse instanceof RenderResponse) {
            RenderResponse renderResponse = (RenderResponse)this._liferayPortletResponse;
            renderResponse.setTitle(LanguageUtil.get((HttpServletRequest)this._servletRequest, (String)"move-web-content"));
        }
    }
}

