/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.web.internal.security.permission.resource.JournalArticlePermission;
import com.liferay.journal.web.util.JournalPortletUtil;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalHistoryDisplayContext {
    private final JournalArticle _article;
    private String _backURL;
    private String _displayStyle;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private String _referringPortletResource;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public JournalHistoryDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse, JournalArticle article) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._article = article;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public List<DropdownItem> getActionItemsDropdownItems() throws PortalException {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new DropdownItemList(){
            {
                if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), JournalHistoryDisplayContext.this._article, "DELETE")) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "deleteArticles");
                        dropdownItem.setIcon("trash");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"delete"));
                        dropdownItem.setQuickAction(true);
                    });
                }
                if (JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), JournalHistoryDisplayContext.this._article, "EXPIRE")) {
                    this.add(dropdownItem -> {
                        dropdownItem.putData("action", "expireArticles");
                        dropdownItem.setIcon("time");
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"expire"));
                        dropdownItem.setQuickAction(true);
                    });
                }
            }
        };
    }

    public SearchContainer getArticleSearchContainer() {
        SearchContainer articleSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, null);
        articleSearchContainer.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        int articleVersionsCount = JournalArticleServiceUtil.getArticlesCountByArticleId((long)this._article.getGroupId(), (String)this._article.getArticleId());
        articleSearchContainer.setTotal(articleVersionsCount);
        OrderByComparator<JournalArticle> orderByComparator = JournalPortletUtil.getArticleOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        List articleVersions = JournalArticleServiceUtil.getArticlesByArticleId((long)this._article.getGroupId(), (String)this._article.getArticleId(), (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), orderByComparator);
        articleSearchContainer.setResults(articleVersions);
        return articleSearchContainer;
    }

    public String getBackURL() {
        if (this._backURL != null) {
            return this._backURL;
        }
        this._backURL = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"backURL");
        return this._backURL;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalHistoryDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalHistoryDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public List<NavigationItem> getNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"versions"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"version");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_article_history.jsp");
        portletURL.setParameter("redirect", this._getRedirect());
        portletURL.setParameter("backURL", this.getBackURL());
        portletURL.setParameter("referringPortletResource", this.getReferringPortletResource());
        portletURL.setParameter("groupId", String.valueOf(this._article.getGroupId()));
        portletURL.setParameter("articleId", this._article.getArticleId());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public String getReferringPortletResource() {
        if (this._referringPortletResource != null) {
            return this._referringPortletResource;
        }
        this._referringPortletResource = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"referringPortletResource");
        return this._referringPortletResource;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        return JournalArticleServiceUtil.getArticlesCountByArticleId((long)this._article.getGroupId(), (String)this._article.getArticleId());
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)JournalHistoryDisplayContext.this._renderResponse.createRenderURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalHistoryDisplayContext.this.getOrderByCol(), "version"));
                    dropdownItem.setHref(JournalHistoryDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "version"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"version"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalHistoryDisplayContext.this.getOrderByCol(), "display-date"));
                    dropdownItem.setHref(JournalHistoryDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "display-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"display-date"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalHistoryDisplayContext.this.getOrderByCol(), "modified-date"));
                    dropdownItem.setHref(JournalHistoryDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "modified-date"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalHistoryDisplayContext.this._request, (String)"modified-date"));
                });
            }
        };
    }

    private String _getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect");
        return this._redirect;
    }
}

