/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.journal.service.JournalFeedLocalServiceUtil;
import com.liferay.journal.web.internal.search.FeedSearch;
import com.liferay.journal.web.internal.search.FeedSearchTerms;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class JournalFeedsDisplayContext {
    private String _displayStyle;
    private FeedSearch _feedSearch;
    private String _keywords;
    private String _orderByCol;
    private String _orderByType;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private final HttpServletRequest _request;

    public JournalFeedsDisplayContext(RenderRequest renderRequest, RenderResponse renderResponse) {
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
    }

    public List<DropdownItem> getActionItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "deleteFeeds");
                    dropdownItem.setIcon("trash");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"delete"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public CreationMenu getCreationMenu() {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new CreationMenu(){
            {
                this.addPrimaryDropdownItem(dropdownItem -> {
                    dropdownItem.setHref(JournalFeedsDisplayContext.this._renderResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_feed.jsp", "redirect", themeDisplay.getURLCurrent()});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"add-feed"));
                });
            }
        };
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public SearchContainer getFeedsSearchContainer() {
        if (this._feedSearch != null) {
            return this._feedSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._feedSearch = new FeedSearch((PortletRequest)this._renderRequest, this.getPortletURL());
        this._feedSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        FeedSearchTerms searchTerms = (FeedSearchTerms)this._feedSearch.getSearchTerms();
        int feedsCount = JournalFeedLocalServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)searchTerms.getGroupId(), (String)searchTerms.getKeywords());
        this._feedSearch.setTotal(feedsCount);
        List feeds = JournalFeedLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)searchTerms.getGroupId(), (String)searchTerms.getKeywords(), (int)this._feedSearch.getStart(), (int)this._feedSearch.getEnd(), (OrderByComparator)this._feedSearch.getOrderByComparator());
        this._feedSearch.setResults(feeds);
        return this._feedSearch;
    }

    public List<DropdownItem> getFilterItemsDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalFeedsDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalFeedsDisplayContext.this._getOrderByDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"order-by"));
                });
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_feeds.jsp");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("displayStyle", this.getDisplayStyle());
        portletURL.setParameter("orderByCol", this.getOrderByCol());
        portletURL.setParameter("orderByType", this.getOrderByType());
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"redirect");
        return this._redirect;
    }

    public String getSearchActionURL() {
        PortletURL searchActionURL = this.getPortletURL();
        return searchActionURL.toString();
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getTotalItems() {
        return this._getTotal();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                this.addCardViewTypeItem();
                this.addListViewTypeItem();
                this.addTableViewTypeItem();
            }
        };
    }

    public boolean isDisabledManagementBar() {
        if (this._getTotal() > 0) {
            return false;
        }
        return !this._isSearch();
    }

    public boolean isShowSearch() {
        if (this._getTotal() > 0) {
            return true;
        }
        return this._isSearch();
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(true);
                    dropdownItem.setHref((Object)JournalFeedsDisplayContext.this._renderResponse.createRenderURL());
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"all"));
                });
            }
        };
    }

    private String _getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"keywords");
        return this._keywords;
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalFeedsDisplayContext.this.getOrderByCol(), "name"));
                    dropdownItem.setHref(JournalFeedsDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "name"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"name"));
                });
                this.add(dropdownItem -> {
                    dropdownItem.setActive(Objects.equals(JournalFeedsDisplayContext.this.getOrderByCol(), "id"));
                    dropdownItem.setHref(JournalFeedsDisplayContext.this.getPortletURL(), new Object[]{"orderByCol", "id"});
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalFeedsDisplayContext.this._request, (String)"id"));
                });
            }
        };
    }

    private int _getTotal() {
        SearchContainer feedSearchContainer = this.getFeedsSearchContainer();
        return feedSearchContainer.getTotal();
    }

    private boolean _isSearch() {
        if (Validator.isNotNull((String)this._getKeywords())) {
            return true;
        }
        return true;
    }
}

