/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.CreationMenu;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.SafeConsumer;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.ViewTypeItemList;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalServiceUtil;
import com.liferay.journal.service.JournalArticleServiceUtil;
import com.liferay.journal.service.JournalFolderLocalServiceUtil;
import com.liferay.journal.service.JournalFolderServiceUtil;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.util.comparator.FolderArticleArticleIdComparator;
import com.liferay.journal.util.comparator.FolderArticleDisplayDateComparator;
import com.liferay.journal.util.comparator.FolderArticleModifiedDateComparator;
import com.liferay.journal.util.comparator.FolderArticleTitleComparator;
import com.liferay.journal.web.asset.JournalArticleAssetRenderer;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.journal.web.internal.portlet.action.ActionUtil;
import com.liferay.journal.web.internal.search.EntriesChecker;
import com.liferay.journal.web.internal.search.EntriesMover;
import com.liferay.journal.web.internal.search.JournalSearcher;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.journal.web.util.JournalPortletUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.RowMover;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.trash.TrashHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class JournalDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(JournalDisplayContext.class);
    private String[] _addMenuFavItems;
    private JournalArticle _article;
    private JournalArticleDisplay _articleDisplay;
    private DDMFormValues _ddmFormValues;
    private String _ddmStructureKey;
    private String _ddmStructureName;
    private List<DDMStructure> _ddmStructures;
    private String _ddmTemplateKey;
    private String _displayStyle;
    private String[] _displayViews;
    private JournalFolder _folder;
    private Long _folderId;
    private final JournalWebConfiguration _journalWebConfiguration;
    private String _keywords;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private Integer _maxAddMenuItems;
    private String _navigation;
    private String _orderByCol;
    private String _orderByType;
    private Long _parentFolderId;
    private final PortalPreferences _portalPreferences;
    private final PortletPreferences _portletPreferences;
    private final HttpServletRequest _request;
    private Integer _restrictionType;
    private Boolean _showEditActions;
    private Integer _status;
    private String _tabs1;
    private final TrashHelper _trashHelper;

    public JournalDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, PortletPreferences portletPreferences, TrashHelper trashHelper) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._portletPreferences = portletPreferences;
        this._trashHelper = trashHelper;
        this._journalWebConfiguration = (JournalWebConfiguration)this._request.getAttribute(JournalWebConfiguration.class.getName());
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                ThemeDisplay themeDisplay = (ThemeDisplay)JournalDisplayContext.this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this.add(SafeConsumer.ignore(dropdownItem -> {
                    dropdownItem.putData("action", "deleteEntries");
                    boolean trashEnabled = JournalDisplayContext.this._trashHelper.isTrashEnabled(themeDisplay.getScopeGroupId());
                    dropdownItem.setIcon(trashEnabled ? "trash" : "times");
                    String label = "delete";
                    if (trashEnabled) {
                        label = "recycle-bin";
                    }
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)label));
                    dropdownItem.setQuickAction(true);
                }));
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "expireEntries");
                    dropdownItem.setIcon("time");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"expire"));
                    dropdownItem.setQuickAction(true);
                });
                this.add(dropdownItem -> {
                    dropdownItem.putData("action", "moveEntries");
                    dropdownItem.setIcon("change");
                    dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"move"));
                    dropdownItem.setQuickAction(true);
                });
            }
        };
    }

    public String[] getAddMenuFavItems() throws PortalException {
        if (this._addMenuFavItems != null) {
            return this._addMenuFavItems;
        }
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        String key = JournalPortletUtil.getAddMenuFavItemKey((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse);
        ArrayList<String> addMenuFavItemsList = new ArrayList<String>();
        Object[] addMenuFavItems = portalPreferences.getValues("com_liferay_journal_web_portlet_JournalPortlet", key, new String[0]);
        for (DDMStructure ddmStructure : this.getDDMStructures()) {
            if (!ArrayUtil.contains((Object[])addMenuFavItems, (Object)ddmStructure.getStructureKey())) continue;
            addMenuFavItemsList.add(ddmStructure.getStructureKey());
        }
        this._addMenuFavItems = ArrayUtil.toStringArray(addMenuFavItemsList);
        return this._addMenuFavItems;
    }

    public int getAddMenuFavItemsLength() throws PortalException {
        String[] addMenuFavItems = this.getAddMenuFavItems();
        return addMenuFavItems.length;
    }

    public JournalArticle getArticle() throws PortalException {
        if (this._article != null) {
            return this._article;
        }
        this._article = ActionUtil.getArticle(this._request);
        return this._article;
    }

    public JournalArticleDisplay getArticleDisplay() throws Exception {
        double version;
        String articleId;
        if (this._articleDisplay != null) {
            return this._articleDisplay;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long groupId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"groupId");
        JournalArticle article = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)(articleId = ParamUtil.getString((HttpServletRequest)this._request, (String)"articleId")), (double)(version = ParamUtil.getDouble((HttpServletRequest)this._request, (String)"version")));
        if (article == null) {
            return this._articleDisplay;
        }
        int page = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"page");
        this._articleDisplay = JournalArticleLocalServiceUtil.getArticleDisplay((JournalArticle)article, null, null, (String)themeDisplay.getLanguageId(), (int)page, (PortletRequestModel)new PortletRequestModel((PortletRequest)this._liferayPortletRequest, (PortletResponse)this._liferayPortletResponse), (ThemeDisplay)themeDisplay);
        return this._articleDisplay;
    }

    public List<Locale> getAvailableArticleLocales() throws PortalException {
        JournalArticle article = this.getArticle();
        if (article == null) {
            return Collections.emptyList();
        }
        ArrayList<Locale> availableLocales = new ArrayList<Locale>();
        for (String languageId : article.getAvailableLanguageIds()) {
            availableLocales.add(LocaleUtil.fromLanguageId((String)languageId));
        }
        return availableLocales;
    }

    public String[] getCharactersBlacklist() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)themeDisplay.getCompanyId());
        return journalServiceConfiguration.charactersblacklist();
    }

    public String getClearResultsURL() {
        PortletURL clearResultsURL = this.getPortletURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public SearchContainer<MBMessage> getCommentsSearchContainer() throws PortalException {
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this._liferayPortletResponse.createRenderURL(), null, null);
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._liferayPortletRequest.getHttpServletRequest());
        searchContext.setAttribute("classNameId", (Serializable)Long.valueOf(PortalUtil.getClassNameId(JournalArticle.class)));
        searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
        ArrayList<MBMessage> mbMessages = new ArrayList<MBMessage>();
        Indexer indexer = IndexerRegistryUtil.getIndexer(MBMessage.class);
        Hits hits = indexer.search(searchContext);
        for (Document document : hits.getDocs()) {
            long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
            MBMessage mbMessage = MBMessageLocalServiceUtil.fetchMBMessage((long)entryClassPK);
            mbMessages.add(mbMessage);
        }
        searchContainer.setResults(mbMessages);
        searchContainer.setTotal(hits.getLength());
        return searchContainer;
    }

    public int getCommentsTotal() throws PortalException {
        SearchContainer<MBMessage> commentsSearchContainer = this.getCommentsSearchContainer();
        return commentsSearchContainer.getTotal();
    }

    public CreationMenu getCreationMenu() throws PortalException {
        return new CreationMenu(){
            {
                ThemeDisplay themeDisplay = (ThemeDisplay)JournalDisplayContext.this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                this.setHelpText(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"you-can-customize-this-menu-or-see-all-you-have-by-clicking-more"));
                if (JournalFolderPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), JournalDisplayContext.this.getFolderId(), "ADD_FOLDER")) {
                    this.addPrimaryDropdownItem(dropdownItem -> {
                        dropdownItem.setHref(JournalDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_folder.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)JournalDisplayContext.this._request), "groupId", String.valueOf(themeDisplay.getScopeGroupId()), "parentFolderId", String.valueOf(JournalDisplayContext.this.getFolderId())});
                        String label = "folder";
                        if (JournalDisplayContext.this.getFolder() != null) {
                            label = "subfolder";
                        }
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)label));
                    });
                }
                if (JournalFolderPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), JournalDisplayContext.this.getFolderId(), "ADD_ARTICLE")) {
                    List<DDMStructure> ddmStructures = JournalDisplayContext.this.getDDMStructures();
                    for (DDMStructure ddmStructure : ddmStructures) {
                        Consumer consumer = SafeConsumer.ignore(dropdownItem -> {
                            dropdownItem.setHref(JournalDisplayContext.this._liferayPortletResponse.createRenderURL(), new Object[]{"mvcPath", "/edit_article.jsp", "redirect", PortalUtil.getCurrentURL((HttpServletRequest)JournalDisplayContext.this._request), "groupId", String.valueOf(themeDisplay.getScopeGroupId()), "folderId", String.valueOf(JournalDisplayContext.this.getFolderId()), "ddmStructureKey", ddmStructure.getStructureKey()});
                            dropdownItem.setLabel(ddmStructure.getUnambiguousName(ddmStructures, themeDisplay.getScopeGroupId(), themeDisplay.getLocale()));
                        });
                        if (ArrayUtil.contains((Object[])JournalDisplayContext.this.getAddMenuFavItems(), (Object)ddmStructure.getStructureKey())) {
                            this.addFavoriteDropdownItem(consumer);
                            continue;
                        }
                        this.addRestDropdownItem(consumer);
                    }
                }
            }
        };
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure) throws PortalException {
        if (this._ddmFormValues != null) {
            return this._ddmFormValues;
        }
        JournalArticle article = this.getArticle();
        if (article == null) {
            return this._ddmFormValues;
        }
        String content = article.getContent();
        if (Validator.isNull((String)content)) {
            return this._ddmFormValues;
        }
        JournalConverter journalConverter = this.getJournalConverter();
        Fields fields = journalConverter.getDDMFields(ddmStructure, content);
        if (fields == null) {
            return this._ddmFormValues;
        }
        this._ddmFormValues = journalConverter.getDDMFormValues(ddmStructure, fields);
        return this._ddmFormValues;
    }

    public String getDDMStructureKey() {
        if (this._ddmStructureKey != null) {
            return this._ddmStructureKey;
        }
        this._ddmStructureKey = ParamUtil.getString((HttpServletRequest)this._request, (String)"ddmStructureKey");
        return this._ddmStructureKey;
    }

    public String getDDMStructureName() {
        if (this._ddmStructureName != null) {
            return this._ddmStructureName;
        }
        this._ddmStructureName = LanguageUtil.get((HttpServletRequest)this._request, (String)"basic-web-content");
        if (Validator.isNull((String)this.getDDMStructureKey())) {
            return this._ddmStructureName;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)themeDisplay.getSiteGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
        if (ddmStructure != null) {
            this._ddmStructureName = ddmStructure.getName(themeDisplay.getLocale());
        }
        return this._ddmStructureName;
    }

    public long getDDMStructurePrimaryKey() {
        String ddmStructureKey = this.getDDMStructureKey();
        if (Validator.isNull((String)ddmStructureKey)) {
            return 0L;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)themeDisplay.getSiteGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)this.getDDMStructureKey(), (boolean)true);
        if (ddmStructure == null) {
            return 0L;
        }
        return ddmStructure.getPrimaryKey();
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        Integer restrictionType = this.getRestrictionType();
        return this.getDDMStructures(restrictionType);
    }

    public List<DDMStructure> getDDMStructures(Integer restrictionType) throws PortalException {
        if (this._ddmStructures != null) {
            return this._ddmStructures;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (restrictionType == null) {
            restrictionType = this.getRestrictionType();
        }
        this._ddmStructures = JournalFolderServiceUtil.getDDMStructures((long[])PortalUtil.getCurrentAndAncestorSiteGroupIds((long)themeDisplay.getScopeGroupId()), (long)this.getFolderId(), (int)restrictionType);
        Locale locale = themeDisplay.getLocale();
        if (this._journalWebConfiguration.journalBrowseByStructuresSortedByName()) {
            this._ddmStructures.sort((ddmStructure1, ddmStructure2) -> {
                String name1 = ddmStructure1.getName(locale);
                String name2 = ddmStructure2.getName(locale);
                return name1.compareTo(name2);
            });
        }
        return this._ddmStructures;
    }

    public String getDDMTemplateKey() {
        if (this._ddmTemplateKey != null) {
            return this._ddmTemplateKey;
        }
        this._ddmTemplateKey = ParamUtil.getString((HttpServletRequest)this._request, (String)"ddmTemplateKey");
        return this._ddmTemplateKey;
    }

    public String getDisplayStyle() {
        if (this._displayStyle != null) {
            return this._displayStyle;
        }
        Object[] displayViews = this.getDisplayViews();
        PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)this._request);
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        if (Validator.isNull((String)this._displayStyle)) {
            this._displayStyle = portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "display-style", this._journalWebConfiguration.defaultDisplayView());
        } else if (ArrayUtil.contains((Object[])displayViews, (Object)this._displayStyle)) {
            portalPreferences.setValue("com_liferay_journal_web_portlet_JournalPortlet", "display-style", this._displayStyle);
            this._request.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        if (!ArrayUtil.contains((Object[])displayViews, (Object)this._displayStyle)) {
            this._displayStyle = displayViews[0];
        }
        return this._displayStyle;
    }

    public String[] getDisplayViews() {
        if (this._displayViews == null) {
            this._displayViews = StringUtil.split((String)PrefsParamUtil.getString((PortletPreferences)this._portletPreferences, (HttpServletRequest)this._request, (String)"displayViews", (String)StringUtil.merge((Object[])this._journalWebConfiguration.displayViews())));
        }
        return this._displayViews;
    }

    public List<DropdownItem> getFilterDropdownItems() {
        return new DropdownItemList(){
            {
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalDisplayContext.this._getFilterNavigationDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"filter-by-navigation"));
                });
                this.addGroup(dropdownGroupItem -> {
                    dropdownGroupItem.setDropdownItems(JournalDisplayContext.this._getFilterStatusDropdownItems());
                    dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"filter-by-status"));
                });
                if (!JournalDisplayContext.this.isNavigationRecent()) {
                    this.addGroup(dropdownGroupItem -> {
                        dropdownGroupItem.setDropdownItems(JournalDisplayContext.this._getOrderByDropdownItems());
                        dropdownGroupItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"order-by"));
                    });
                }
            }
        };
    }

    public JournalFolder getFolder() {
        if (this._folder != null) {
            return this._folder;
        }
        this._folder = (JournalFolder)this._request.getAttribute("JOURNAL_FOLDER");
        if (this._folder != null) {
            return this._folder;
        }
        long folderId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"folderId");
        this._folder = JournalFolderLocalServiceUtil.fetchFolder((long)folderId);
        return this._folder;
    }

    public long getFolderId() {
        if (this._folderId != null) {
            return this._folderId;
        }
        JournalFolder folder = this.getFolder();
        this._folderId = BeanParamUtil.getLong((Object)folder, (HttpServletRequest)this._request, (String)"folderId", (long)0L);
        return this._folderId;
    }

    public JSONArray getFoldersJSONArray() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONArray jsonArray = this._getFoldersJSONArray(themeDisplay.getScopeGroupId(), 0L);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("children", jsonArray);
        jsonObject.put("icon", "folder");
        jsonObject.put("id", 0L);
        jsonObject.put("name", LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"home"));
        JSONArray rootJSONArray = JSONFactoryUtil.createJSONArray();
        rootJSONArray.put(jsonObject);
        return rootJSONArray;
    }

    public String getFolderTitle() {
        JournalFolder folder = this.getFolder();
        if (folder != null) {
            return folder.getName();
        }
        return "";
    }

    public String getFriendlyURLBase() {
        StringBundler sb = new StringBundler(4);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        sb.append(themeDisplay.getPortalURL());
        Group group = themeDisplay.getScopeGroup();
        sb.append(group.getPathFriendlyURL(false, themeDisplay));
        sb.append(group.getFriendlyURL());
        sb.append("/-/");
        return sb.toString();
    }

    public List<NavigationItem> getInfoPanelNavigationItems() {
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(true);
                    navigationItem.setHref((Object)"");
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"details"));
                });
            }
        };
    }

    public JournalConverter getJournalConverter() {
        return (JournalConverter)this._request.getAttribute("JOURNAL_CONVERTER");
    }

    public String getKeywords() {
        if (this._keywords != null) {
            return this._keywords;
        }
        this._keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        return this._keywords;
    }

    public int getMaxAddMenuItems() {
        if (this._maxAddMenuItems != null) {
            return this._maxAddMenuItems;
        }
        this._maxAddMenuItems = this._journalWebConfiguration.maxAddMenuItems();
        return this._maxAddMenuItems;
    }

    public String getNavigation() {
        if (this._navigation != null) {
            return this._navigation;
        }
        this._navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"all");
        return this._navigation;
    }

    public List<NavigationItem> getNavigationBarItems(final String currentItem) {
        final ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return new NavigationItemList(){
            {
                this.add(navigationItem -> {
                    navigationItem.setActive(currentItem.equals("web-content"));
                    navigationItem.setHref((Object)JournalDisplayContext.this._liferayPortletResponse.createRenderURL());
                    navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"web-content"));
                });
                Group group = themeDisplay.getScopeGroup();
                if (!group.isLayout()) {
                    this.add(navigationItem -> {
                        navigationItem.setHref((Object)JournalDisplayContext.this._getStructuresURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"structures"));
                    });
                    this.add(navigationItem -> {
                        navigationItem.setHref((Object)JournalDisplayContext.this._getTemplatesURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"templates"));
                    });
                }
                if (JournalDisplayContext.this._journalWebConfiguration.showFeeds() && PortalUtil.isRSSFeedsEnabled()) {
                    this.add(navigationItem -> {
                        navigationItem.setActive(currentItem.equals("feeds"));
                        navigationItem.setHref((Object)JournalDisplayContext.this._getFeedsURL());
                        navigationItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"feeds"));
                    });
                }
            }
        };
    }

    public String getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol");
        if (Validator.isNull((String)this._orderByCol)) {
            this._orderByCol = this._portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-col", "modified-date");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-col", this._orderByCol);
            }
        }
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        if (this.isNavigationRecent()) {
            return "desc";
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType");
        if (Validator.isNull((String)this._orderByType)) {
            this._orderByType = this._portalPreferences.getValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-type", "asc");
        } else {
            boolean saveOrderBy = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"saveOrderBy");
            if (saveOrderBy) {
                this._portalPreferences.setValue("com_liferay_journal_web_portlet_JournalPortlet", "order-by-type", this._orderByType);
            }
        }
        return this._orderByType;
    }

    public String[] getOrderColumns() {
        Object[] orderColumns = new String[]{"display-date", "modified-date", "title"};
        if (!this._journalWebConfiguration.journalArticleForceAutogenerateId()) {
            orderColumns = (String[])ArrayUtil.append((Object[])orderColumns, (Object)"id");
        }
        return orderColumns;
    }

    public String getOriginalAuthor(JournalArticle article) {
        long classPK = JournalArticleAssetRenderer.getClassPK(article);
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)JournalArticle.class.getName(), (long)classPK);
        if (assetEntry != null) {
            return assetEntry.getUserName();
        }
        return article.getUserName();
    }

    public long getParentFolderId() {
        if (this._parentFolderId != null) {
            return this._parentFolderId;
        }
        this._parentFolderId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"parentFolderId", (long)0L);
        return this._parentFolderId;
    }

    public PortletURL getPortletURL() {
        String tabs1;
        String orderByType;
        String orderByCol;
        String keywords;
        String displayStyle;
        String deltaEntry;
        String delta;
        String status;
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation");
        if (Validator.isNotNull((String)navigation)) {
            portletURL.setParameter("navigation", HtmlUtil.escapeJS((String)this.getNavigation()));
        }
        portletURL.setParameter("folderId", String.valueOf(this.getFolderId()));
        if (this.isNavigationStructure()) {
            portletURL.setParameter("ddmStructureKey", this.getDDMStructureKey());
        }
        if (Validator.isNotNull((String)(status = ParamUtil.getString((HttpServletRequest)this._request, (String)"status")))) {
            portletURL.setParameter("status", String.valueOf(this.getStatus()));
        }
        if (Validator.isNotNull((String)(delta = ParamUtil.getString((HttpServletRequest)this._request, (String)"delta")))) {
            portletURL.setParameter("delta", delta);
        }
        if (Validator.isNotNull((String)(deltaEntry = ParamUtil.getString((HttpServletRequest)this._request, (String)"deltaEntry")))) {
            portletURL.setParameter("deltaEntry", deltaEntry);
        }
        if (Validator.isNotNull((String)(displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle")))) {
            portletURL.setParameter("displayStyle", this.getDisplayStyle());
        }
        if (Validator.isNotNull((String)(keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords")))) {
            portletURL.setParameter("keywords", keywords);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        if (!this.isShowEditActions()) {
            portletURL.setParameter("showEditActions", String.valueOf(this.isShowEditActions()));
        }
        if (Validator.isNotNull((String)(tabs1 = this.getTabs1()))) {
            portletURL.setParameter("tabs1", tabs1);
        }
        return portletURL;
    }

    public int getRestrictionType() {
        if (this._restrictionType != null) {
            return this._restrictionType;
        }
        JournalFolder folder = this.getFolder();
        this._restrictionType = folder != null ? Integer.valueOf(folder.getRestrictionType()) : Integer.valueOf(0);
        return this._restrictionType;
    }

    public String getSearchActionURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("folderId", String.valueOf(this.getFolderId()));
        portletURL.setParameter("showEditActions", String.valueOf(this.isShowEditActions()));
        return portletURL.toString();
    }

    public SearchContainer getSearchContainer(boolean showVersions) throws PortalException {
        ArrayList<Long> folderIds;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer articleSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getPortletURL(), null, null);
        OrderByComparator<JournalArticle> orderByComparator = JournalPortletUtil.getArticleOrderByComparator(this.getOrderByCol(), this.getOrderByType());
        articleSearchContainer.setOrderByCol(this.getOrderByCol());
        articleSearchContainer.setOrderByComparator(orderByComparator);
        articleSearchContainer.setOrderByType(this.getOrderByType());
        if (!showVersions) {
            EntriesChecker entriesChecker = new EntriesChecker(this._liferayPortletRequest, this._liferayPortletResponse, this._trashHelper);
            entriesChecker.setCssClass("entry-selector");
            entriesChecker.setRememberCheckBoxStateURLRegex(StringBundler.concat((Object[])new Object[]{"^(?!.*", this._liferayPortletResponse.getNamespace(), "redirect).*(folderId=", this.getFolderId(), ")"}));
            articleSearchContainer.setRowChecker((RowChecker)entriesChecker);
            EntriesMover entriesMover = new EntriesMover(this._trashHelper.isTrashEnabled(themeDisplay.getScopeGroupId()));
            articleSearchContainer.setRowMover((RowMover)entriesMover);
        }
        if (this.isNavigationMine() || this.isNavigationRecent()) {
            boolean includeOwner = true;
            if (this.isNavigationMine()) {
                includeOwner = false;
            }
            if (this.isNavigationRecent()) {
                articleSearchContainer.setOrderByCol("modified-date");
                articleSearchContainer.setOrderByType(this.getOrderByType());
            }
            int total = JournalArticleServiceUtil.getGroupArticlesCount((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (long)this.getFolderId(), (int)this.getStatus(), (boolean)includeOwner);
            articleSearchContainer.setTotal(total);
            List results = JournalArticleServiceUtil.getGroupArticles((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (long)this.getFolderId(), (int)this.getStatus(), (boolean)includeOwner, (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
            articleSearchContainer.setResults(results);
        } else if (Validator.isNotNull((String)this.getDDMStructureKey())) {
            int total = JournalArticleServiceUtil.getArticlesCountByStructureId((long)themeDisplay.getScopeGroupId(), (String)this.getDDMStructureKey(), (int)this.getStatus());
            articleSearchContainer.setTotal(total);
            List results = JournalArticleServiceUtil.getArticlesByStructureId((long)themeDisplay.getScopeGroupId(), (String)this.getDDMStructureKey(), (int)this.getStatus(), (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
            articleSearchContainer.setResults(results);
        } else if (Validator.isNotNull((String)this.getDDMTemplateKey())) {
            folderIds = new ArrayList<Long>(1);
            if (this.getFolderId() != 0L) {
                folderIds.add(this.getFolderId());
            }
            int total = JournalArticleServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), folderIds, (long)0L, (String)this.getKeywords(), (Double)-1.0, (String)this.getDDMStructureKey(), (String)this.getDDMTemplateKey(), null, null, (int)this.getStatus(), null);
            articleSearchContainer.setTotal(total);
            List results = JournalArticleServiceUtil.search((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), folderIds, (long)0L, (String)this.getKeywords(), (Double)-1.0, (String)this.getDDMStructureKey(), (String)this.getDDMTemplateKey(), null, null, (int)this.getStatus(), null, (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
            articleSearchContainer.setResults(results);
        } else if (this.isSearch()) {
            folderIds = new ArrayList(1);
            if (this.getFolderId() != 0L) {
                folderIds.add(this.getFolderId());
            }
            if (this._journalWebConfiguration.journalArticlesSearchWithIndex()) {
                Document[] documents;
                boolean orderByAsc = false;
                if (Objects.equals(this.getOrderByType(), "asc")) {
                    orderByAsc = true;
                }
                Sort sort = null;
                if (Objects.equals(this.getOrderByCol(), "display-date")) {
                    sort = new Sort("displayDate", 6, orderByAsc);
                } else if (Objects.equals(this.getOrderByCol(), "id")) {
                    sort = new Sort(Field.getSortableFieldName((String)"articleId"), 3, !orderByAsc);
                } else if (Objects.equals(this.getOrderByCol(), "modified-date")) {
                    sort = new Sort("modified", 6, orderByAsc);
                } else if (Objects.equals(this.getOrderByCol(), "title")) {
                    sort = new Sort("title", 3, !orderByAsc);
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("expandoAttributes", this.getKeywords());
                Indexer indexer = null;
                indexer = !showVersions ? JournalSearcher.getInstance() : IndexerRegistryUtil.getIndexer(JournalArticle.class);
                SearchContext searchContext = this.buildSearchContext(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), folderIds, 0L, this.getDDMStructureKey(), this.getDDMTemplateKey(), this.getKeywords(), params, articleSearchContainer.getStart(), articleSearchContainer.getEnd(), sort, showVersions);
                Hits hits = indexer.search(searchContext);
                int total = hits.getLength();
                articleSearchContainer.setTotal(total);
                ArrayList<Object> results = new ArrayList<Object>();
                for (Document document : documents = hits.getDocs()) {
                    String className = document.get("entryClassName");
                    long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
                    if (className.equals(JournalArticle.class.getName())) {
                        JournalArticle article = null;
                        if (!showVersions) {
                            article = JournalArticleLocalServiceUtil.fetchLatestArticle((long)classPK, (int)-1, (boolean)false);
                        } else {
                            String articleId = document.get("articleId");
                            long groupId = GetterUtil.getLong((String)document.get("groupId"));
                            double version = GetterUtil.getDouble((String)document.get("version"));
                            article = JournalArticleLocalServiceUtil.fetchArticle((long)groupId, (String)articleId, (double)version);
                        }
                        results.add(article);
                        continue;
                    }
                    if (!className.equals(JournalFolder.class.getName())) continue;
                    JournalFolder folder = JournalFolderLocalServiceUtil.getFolder((long)classPK);
                    results.add(folder);
                }
                articleSearchContainer.setResults(results);
            } else {
                int total = JournalArticleServiceUtil.searchCount((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), folderIds, (long)0L, (String)this.getKeywords(), (Double)-1.0, (String)this.getDDMStructureKey(), (String)this.getDDMTemplateKey(), null, null, (int)this.getStatus(), null);
                articleSearchContainer.setTotal(total);
                List results = JournalArticleServiceUtil.search((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), folderIds, (long)0L, (String)this.getKeywords(), (Double)-1.0, (String)this.getDDMStructureKey(), (String)this.getDDMTemplateKey(), null, null, (int)this.getStatus(), null, (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)articleSearchContainer.getOrderByComparator());
                articleSearchContainer.setResults(results);
            }
        } else {
            int total = JournalFolderServiceUtil.getFoldersAndArticlesCount((long)themeDisplay.getScopeGroupId(), (long)0L, (long)this.getFolderId(), (int)this.getStatus());
            articleSearchContainer.setTotal(total);
            FolderArticleDisplayDateComparator folderOrderByComparator = null;
            boolean orderByAsc = false;
            if (Objects.equals(this.getOrderByType(), "asc")) {
                orderByAsc = true;
            }
            if (Objects.equals(this.getOrderByCol(), "display-date")) {
                folderOrderByComparator = new FolderArticleDisplayDateComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "id")) {
                folderOrderByComparator = new FolderArticleArticleIdComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "modified-date")) {
                folderOrderByComparator = new FolderArticleModifiedDateComparator(orderByAsc);
            } else if (Objects.equals(this.getOrderByCol(), "title")) {
                folderOrderByComparator = new FolderArticleTitleComparator(orderByAsc);
            }
            List results = JournalFolderServiceUtil.getFoldersAndArticles((long)themeDisplay.getScopeGroupId(), (long)0L, (long)this.getFolderId(), (int)this.getStatus(), (Locale)themeDisplay.getLocale(), (int)articleSearchContainer.getStart(), (int)articleSearchContainer.getEnd(), (OrderByComparator)folderOrderByComparator);
            articleSearchContainer.setResults(results);
        }
        return articleSearchContainer;
    }

    public String getSortingURL() {
        PortletURL sortingURL = this.getPortletURL();
        sortingURL.setParameter("orderByType", Objects.equals(this.getOrderByType(), "asc") ? "desc" : "asc");
        return sortingURL.toString();
    }

    public int getStatus() {
        if (this._status != null) {
            return this._status;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int defaultStatus = 0;
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isContentReviewer(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId()) || this.isNavigationMine()) {
            defaultStatus = -1;
        }
        this._status = ParamUtil.getInteger((HttpServletRequest)this._request, (String)"status", (int)defaultStatus);
        return this._status;
    }

    public String getTabs1() {
        if (this._tabs1 != null) {
            return this._tabs1;
        }
        this._tabs1 = ParamUtil.getString((HttpServletRequest)this._request, (String)"tabs1");
        return this._tabs1;
    }

    public int getTotalItems() throws PortalException {
        SearchContainer articleSearch = this.getSearchContainer(false);
        return articleSearch.getTotal();
    }

    public int getVersionsTotal() throws PortalException {
        SearchContainer articleSearch = this.getSearchContainer(true);
        return articleSearch.getTotal();
    }

    public List<ViewTypeItem> getViewTypeItems() {
        return new ViewTypeItemList(this.getPortletURL(), this.getDisplayStyle()){
            {
                if (ArrayUtil.contains((Object[])JournalDisplayContext.this.getDisplayViews(), (Object)"icon")) {
                    this.addCardViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])JournalDisplayContext.this.getDisplayViews(), (Object)"descriptive")) {
                    this.addListViewTypeItem();
                }
                if (ArrayUtil.contains((Object[])JournalDisplayContext.this.getDisplayViews(), (Object)"list")) {
                    this.addTableViewTypeItem();
                }
            }
        };
    }

    public boolean hasCommentsResults() throws PortalException {
        return this.getCommentsTotal() > 0;
    }

    public boolean hasResults() throws PortalException {
        return this.getTotalItems() > 0;
    }

    public boolean hasVersionsResults() throws PortalException {
        return this.getVersionsTotal() > 0;
    }

    public boolean isDisabled() throws PortalException {
        if (this.hasResults()) {
            return false;
        }
        if (this.isSearch()) {
            return false;
        }
        return this.isNavigationHome() && this.getStatus() == -1;
    }

    public boolean isNavigationHome() {
        return Objects.equals(this.getNavigation(), "all");
    }

    public boolean isNavigationMine() {
        return Objects.equals(this.getNavigation(), "mine");
    }

    public boolean isNavigationRecent() {
        return Objects.equals(this.getNavigation(), "recent");
    }

    public boolean isNavigationStructure() {
        return Objects.equals(this.getNavigation(), "structure");
    }

    public boolean isSearch() {
        return Validator.isNotNull((String)this.getKeywords());
    }

    public boolean isShowAddButton() throws PortalException {
        StagingGroupHelper stagingGroupHelper;
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = themeDisplay.getScopeGroup();
        if (group.isLayout()) {
            group = group.getParentGroup();
        }
        if (((stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper()).isLocalLiveGroup(group) || stagingGroupHelper.isRemoteLiveGroup(group)) && stagingGroupHelper.isStagedPortlet(group, "com_liferay_journal_web_portlet_JournalPortlet")) {
            return false;
        }
        return JournalFolderPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), this.getFolderId(), "ADD_FOLDER") || JournalFolderPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), this.getFolderId(), "ADD_ARTICLE");
    }

    public boolean isShowEditActions() {
        if (this._showEditActions != null) {
            return this._showEditActions;
        }
        this._showEditActions = ParamUtil.getBoolean((HttpServletRequest)this._request, (String)"showEditActions", (boolean)true);
        return this._showEditActions;
    }

    public boolean isShowInfoButton() {
        if (Validator.isNotNull((String)this.getDDMStructureKey())) {
            return false;
        }
        if (this.isNavigationMine()) {
            return false;
        }
        if (this.isNavigationRecent()) {
            return false;
        }
        return !this.isSearch();
    }

    public boolean isShowPublishArticleAction(JournalArticle article) {
        if (article == null) {
            return false;
        }
        StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)JournalArticle.class.getName());
        return this._isShowPublishAction() && ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)article.getStatus());
    }

    public boolean isShowPublishFolderAction(JournalFolder folder) {
        if (folder == null) {
            return false;
        }
        return this._isShowPublishAction();
    }

    public boolean isShowSearch() throws PortalException {
        if (this.hasResults()) {
            return true;
        }
        return this.isSearch();
    }

    protected SearchContext buildSearchContext(long companyId, long groupId, List<Long> folderIds, long classNameId, String ddmStructureKey, String ddmTemplateKey, String keywords, LinkedHashMap<String, Object> params, int start, int end, Sort sort, boolean showVersions) {
        String articleId = null;
        String title = null;
        String description = null;
        String content = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            articleId = keywords;
            title = keywords;
            description = keywords;
            content = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andOperator);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("articleId", articleId);
        attributes.put("classNameId", classNameId);
        attributes.put("content", content);
        attributes.put("description", description);
        attributes.put("status", this.getStatus());
        attributes.put("title", title);
        attributes.put("ddmStructureKey", ddmStructureKey);
        attributes.put("ddmTemplateKey", ddmTemplateKey);
        attributes.put("params", params);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setIncludeDiscussions(GetterUtil.getBoolean((Object)params.get("includeDiscussions"), (boolean)true));
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        searchContext.setAttribute("head", (Serializable)Boolean.valueOf(!showVersions));
        searchContext.setAttribute("latest", (Serializable)Boolean.valueOf(!showVersions));
        searchContext.setAttribute("params", params);
        if (!showVersions) {
            searchContext.setAttribute("showNonindexable", (Serializable)Boolean.TRUE);
        }
        searchContext.setEnd(end);
        searchContext.setFolderIds(folderIds);
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    private String _getFeedsURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/view_feeds.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        return portletURL.toString();
    }

    private Consumer<DropdownItem> _getFilterNavigationDropdownItem(boolean active, String navigation) {
        return dropdownItem -> {
            dropdownItem.setActive(active);
            dropdownItem.setHref(this._liferayPortletResponse.createRenderURL(), new Object[]{"navigation", navigation, "folderId", String.valueOf(0L), "showEditActions", String.valueOf(this.isShowEditActions())});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)navigation));
        };
    }

    private List<DropdownItem> _getFilterNavigationDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(JournalDisplayContext.this._getFilterNavigationDropdownItem(JournalDisplayContext.this.isNavigationHome(), "all"));
                this.add(JournalDisplayContext.this._getFilterNavigationDropdownItem(JournalDisplayContext.this.isNavigationMine(), "mine"));
                this.add(JournalDisplayContext.this._getFilterNavigationDropdownItem(JournalDisplayContext.this.isNavigationRecent(), "recent"));
                StringBundler sb = new StringBundler(JournalDisplayContext.this.isNavigationStructure() ? 4 : 1);
                sb.append(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)"structures"));
                if (JournalDisplayContext.this.isNavigationStructure()) {
                    sb.append(":");
                    sb.append(" ");
                    sb.append(JournalDisplayContext.this.getDDMStructureName());
                }
                this.add(dropdownItem -> {
                    dropdownItem.setActive(JournalDisplayContext.this.isNavigationStructure());
                    dropdownItem.putData("action", "openStructuresSelector");
                    dropdownItem.setLabel(sb.toString());
                });
            }
        };
    }

    private List<DropdownItem> _getFilterStatusDropdownItems() {
        return new DropdownItemList(){
            {
                Iterator iterator = JournalDisplayContext.this._getStatuses().iterator();
                while (iterator.hasNext()) {
                    int status = (Integer)iterator.next();
                    this.add(dropdownItem -> {
                        dropdownItem.setActive(JournalDisplayContext.this.getStatus() == status);
                        dropdownItem.setHref(JournalDisplayContext.this.getPortletURL(), new Object[]{"status", String.valueOf(status)});
                        dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)JournalDisplayContext.this._request, (String)WorkflowConstants.getStatusLabel((int)status)));
                    });
                }
            }
        };
    }

    private JSONArray _getFoldersJSONArray(long groupId, long folderId) {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List folders = JournalFolderLocalServiceUtil.getFolders((long)groupId, (long)folderId);
        for (JournalFolder folder : folders) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            JSONArray childrenJSONArray = this._getFoldersJSONArray(groupId, folder.getFolderId());
            if (childrenJSONArray.length() > 0) {
                jsonObject.put("children", childrenJSONArray);
            }
            jsonObject.put("icon", "folder");
            jsonObject.put("id", folder.getFolderId());
            jsonObject.put("name", folder.getName());
            if (folder.getFolderId() == this.getParentFolderId()) {
                jsonObject.put("selected", true);
            }
            if (folder.getFolderId() == this.getFolderId()) {
                jsonObject.put("disabled", true);
            }
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    private Consumer<DropdownItem> _getOrderByDropdownItem(String orderByCol) {
        return dropdownItem -> {
            dropdownItem.setActive(orderByCol.equals(this.getOrderByCol()));
            dropdownItem.setHref(this.getPortletURL(), new Object[]{"orderByCol", orderByCol});
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._request, (String)orderByCol));
        };
    }

    private List<DropdownItem> _getOrderByDropdownItems() {
        return new DropdownItemList(){
            {
                for (String orderColumn : JournalDisplayContext.this.getOrderColumns()) {
                    this.add(JournalDisplayContext.this._getOrderByDropdownItem(orderColumn));
                }
            }
        };
    }

    private List<Integer> _getStatuses() {
        ArrayList<Integer> statuses = new ArrayList<Integer>();
        statuses.add(-1);
        statuses.add(2);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int workflowDefinitionLinksCount = WorkflowDefinitionLinkLocalServiceUtil.getWorkflowDefinitionLinksCount((long)themeDisplay.getCompanyId(), (long)themeDisplay.getScopeGroupId(), (String)JournalFolder.class.getName());
        if (workflowDefinitionLinksCount > 0) {
            statuses.add(1);
            statuses.add(4);
        }
        statuses.add(7);
        statuses.add(0);
        statuses.add(3);
        return statuses;
    }

    private String _getStructuresURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletDisplay.getId());
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._liferayPortletRequest, (String)PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view.jsp");
        portletURL.setParameter("backURL", themeDisplay.getURLCurrent());
        portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        portletURL.setParameter("refererPortletName", "com_liferay_journal_web_portlet_JournalPortlet");
        portletURL.setParameter("refererWebDAVToken", WebDAVUtil.getStorageToken((Portlet)portlet));
        portletURL.setParameter("scopeTitle", LanguageUtil.get((HttpServletRequest)this._request, (String)"structures"));
        portletURL.setParameter("showAncestorScopes", String.valueOf(this._journalWebConfiguration.showAncestorScopesByDefault()));
        portletURL.setParameter("showCacheableInput", Boolean.TRUE.toString());
        portletURL.setParameter("showManageTemplates", Boolean.TRUE.toString());
        return portletURL.toString();
    }

    private String _getTemplatesURL() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        Portlet portlet = PortletLocalServiceUtil.getPortletById((String)portletDisplay.getId());
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)this._liferayPortletRequest, (String)PortletProviderUtil.getPortletId((String)DDMTemplate.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/view_template.jsp");
        portletURL.setParameter("navigationStartsOn", "VIEW_TEMPLATES");
        portletURL.setParameter("backURL", themeDisplay.getURLCurrent());
        portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
        portletURL.setParameter("classNameId", String.valueOf(PortalUtil.getClassNameId(DDMStructure.class)));
        portletURL.setParameter("resourceClassNameId", String.valueOf(PortalUtil.getClassNameId(JournalArticle.class)));
        portletURL.setParameter("refererPortletName", "com_liferay_journal_web_portlet_JournalPortlet");
        portletURL.setParameter("refererWebDAVToken", WebDAVUtil.getStorageToken((Portlet)portlet));
        portletURL.setParameter("scopeTitle", LanguageUtil.get((HttpServletRequest)this._request, (String)"templates"));
        portletURL.setParameter("showAncestorScopes", String.valueOf(this._journalWebConfiguration.showAncestorScopesByDefault()));
        portletURL.setParameter("showCacheableInput", Boolean.TRUE.toString());
        portletURL.setParameter("showHeader", Boolean.TRUE.toString());
        return portletURL.toString();
    }

    private boolean _isShowPublishAction() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        long scopeGroupId = themeDisplay.getScopeGroupId();
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        try {
            return GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)scopeGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO") && stagingGroupHelper.isStagingGroup(scopeGroupId) && stagingGroupHelper.isStagedPortlet(scopeGroupId, "com_liferay_journal_web_portlet_JournalPortlet");
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"An exception occured when checking if the publish action should be displayed", (Throwable)pe);
            }
            return false;
        }
    }
}

