/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.display.context;

import com.liferay.asset.display.page.item.selector.criterion.AssetDisplayPageSelectorCriterion;
import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalServiceUtil;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalServiceUtil;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.internal.portlet.action.ActionUtil;
import com.liferay.layout.item.selector.criterion.LayoutItemSelectorCriterion;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanParamUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class EditArticleDisplayPageDisplayContext {
    private JournalArticle _article;
    private AssetDisplayPageEntry _assetDisplayPageEntry;
    private Long _assetDisplayPageId;
    private AssetEntry _assetEntry;
    private String _defaultAssetDisplayPageName;
    private Integer _displayPageType;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final HttpServletRequest _request;

    public EditArticleDisplayPageDisplayContext(HttpServletRequest request, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._request = request;
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
    }

    public JournalArticle getArticle() throws PortalException {
        if (this._article != null) {
            return this._article;
        }
        this._article = ActionUtil.getArticle(this._request);
        return this._article;
    }

    public AssetDisplayPageEntry getAssetDisplayPageEntry() throws PortalException {
        if (this._assetDisplayPageEntry != null) {
            return this._assetDisplayPageEntry;
        }
        JournalArticle journalArticle = this.getArticle();
        if (journalArticle == null) {
            return this._assetDisplayPageEntry;
        }
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)journalArticle.getGroupId(), (String)journalArticle.getArticleResourceUuid());
        if (assetEntry == null) {
            return this._assetDisplayPageEntry;
        }
        AssetDisplayPageEntry assetDisplayPageEntry = AssetDisplayPageEntryLocalServiceUtil.fetchAssetDisplayPageEntry((long)assetEntry.getGroupId(), (long)assetEntry.getClassNameId(), (long)assetEntry.getClassPK());
        if (assetDisplayPageEntry != null) {
            this._assetDisplayPageEntry = assetDisplayPageEntry;
        }
        return this._assetDisplayPageEntry;
    }

    public long getAssetDisplayPageId() throws PortalException {
        if (this._assetDisplayPageId != null) {
            return this._assetDisplayPageId;
        }
        long assetDisplayPageId = 0L;
        AssetDisplayPageEntry assetDisplayPageEntry = this.getAssetDisplayPageEntry();
        if (assetDisplayPageEntry != null) {
            assetDisplayPageId = assetDisplayPageEntry.getLayoutPageTemplateEntryId();
        }
        this._assetDisplayPageId = assetDisplayPageId;
        return this._assetDisplayPageId;
    }

    public int getAssetDisplayPageType() throws PortalException {
        if (this._displayPageType != null) {
            return this._displayPageType;
        }
        String articleId = ParamUtil.getString((HttpServletRequest)this._request, (String)"articleId");
        if (Validator.isNull((String)articleId)) {
            this._displayPageType = 1;
            return this._displayPageType;
        }
        AssetDisplayPageEntry assetDisplayPageEntry = this.getAssetDisplayPageEntry();
        int displayPageType = 0;
        if (assetDisplayPageEntry == null) {
            this._displayPageType = displayPageType;
            return this._displayPageType;
        }
        if (Objects.equals(assetDisplayPageEntry.getType(), 2)) {
            displayPageType = 2;
        } else if (Objects.equals(assetDisplayPageEntry.getType(), 1)) {
            displayPageType = 1;
        }
        this._displayPageType = displayPageType;
        return this._displayPageType;
    }

    public String getDefaultAssetDisplayPageName(String ddmStructureKey) throws PortalException {
        if (this._defaultAssetDisplayPageName != null) {
            return this._defaultAssetDisplayPageName;
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = null;
        AssetEntry assetEntry = this._getAssetEntry();
        if (assetEntry != null) {
            layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchDefaultLayoutPageTemplateEntry((long)assetEntry.getGroupId(), (long)assetEntry.getClassNameId(), (long)assetEntry.getClassTypeId());
        }
        if (layoutPageTemplateEntry != null) {
            this._defaultAssetDisplayPageName = layoutPageTemplateEntry.getName();
            return this._defaultAssetDisplayPageName;
        }
        DDMStructure ddmStructure = this._getDDMStructure(ddmStructureKey);
        if (ddmStructure != null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchDefaultLayoutPageTemplateEntry((long)themeDisplay.getScopeGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (long)ddmStructure.getStructureId());
        }
        if (layoutPageTemplateEntry != null) {
            this._defaultAssetDisplayPageName = layoutPageTemplateEntry.getName();
            return this._defaultAssetDisplayPageName;
        }
        return null;
    }

    public String getDisplayPageItemSelectorURL() throws PortalException {
        ItemSelector itemSelector = (ItemSelector)this._request.getAttribute("ITEM_SELECTOR");
        DDMStructure ddmStructure = (DDMStructure)this._request.getAttribute("edit_article.jsp-structure");
        long displayPageClassNameId = PortalUtil.getClassNameId((String)JournalArticle.class.getName());
        AssetDisplayPageSelectorCriterion assetDisplayPageSelectorCriterion = new AssetDisplayPageSelectorCriterion();
        assetDisplayPageSelectorCriterion.setClassNameId(displayPageClassNameId);
        assetDisplayPageSelectorCriterion.setClassTypeId(ddmStructure.getStructureId());
        ArrayList<UUIDItemSelectorReturnType> desiredAssetDisplayPageItemSelectorReturnTypes = new ArrayList<UUIDItemSelectorReturnType>();
        desiredAssetDisplayPageItemSelectorReturnTypes.add(new UUIDItemSelectorReturnType());
        assetDisplayPageSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredAssetDisplayPageItemSelectorReturnTypes);
        LayoutItemSelectorCriterion layoutItemSelectorCriterion = new LayoutItemSelectorCriterion();
        layoutItemSelectorCriterion.setCheckDisplayPage(true);
        ArrayList<UUIDItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<UUIDItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add(new UUIDItemSelectorReturnType());
        layoutItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        String eventName = this._liferayPortletResponse.getNamespace() + "selectDisplayPage";
        PortletURL itemSelectorURL = itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._liferayPortletRequest), eventName, new ItemSelectorCriterion[]{assetDisplayPageSelectorCriterion, layoutItemSelectorCriterion});
        itemSelectorURL.setParameter("layoutUuid", this.getLayoutUuid());
        return itemSelectorURL.toString();
    }

    public String getDisplayPageName() throws Exception {
        String assetDisplayPageName = this._getAssetDisplayPageName();
        if (Validator.isNotNull((String)assetDisplayPageName)) {
            return assetDisplayPageName;
        }
        String layoutUuid = this.getLayoutUuid();
        if (Validator.isNull((String)layoutUuid)) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout selLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)themeDisplay.getSiteGroupId(), (boolean)false);
        if (selLayout == null) {
            selLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)layoutUuid, (long)themeDisplay.getSiteGroupId(), (boolean)true);
        }
        if (selLayout != null) {
            return this._getLayoutBreadcrumb(selLayout);
        }
        return "";
    }

    public String getLayoutUuid() throws PortalException {
        JournalArticle article = this.getArticle();
        String layoutUuid = BeanParamUtil.getString((Object)this.getArticle(), (HttpServletRequest)this._request, (String)"layoutUuid");
        boolean changeStructure = GetterUtil.getBoolean((Object)this._request.getAttribute("edit_article.jsp-changeStructure"));
        if (changeStructure && article != null) {
            layoutUuid = article.getLayoutUuid();
        }
        return layoutUuid;
    }

    public String getURLViewInContext() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        JournalArticle article = this.getArticle();
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(article.getResourcePrimKey());
        return assetRenderer.getURLViewInContext(this._liferayPortletRequest, this._liferayPortletResponse, themeDisplay.getURLCurrent());
    }

    public boolean isAssetDisplayPageTypeDefault() throws PortalException {
        return this.getAssetDisplayPageType() == 1;
    }

    public boolean isAssetDisplayPageTypeNone() throws PortalException {
        return this.getAssetDisplayPageType() == 0;
    }

    public boolean isAssetDisplayPageTypeSpecific() throws PortalException {
        return this.getAssetDisplayPageType() == 2;
    }

    public boolean isURLViewInContext() throws Exception {
        if (this.getArticle() == null) {
            return false;
        }
        if (Validator.isNull((String)this.getLayoutUuid())) {
            return false;
        }
        JournalArticle article = this.getArticle();
        if (article.isNew()) {
            return false;
        }
        long classNameId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"classNameId");
        if (classNameId != 0L) {
            return false;
        }
        return !Validator.isNull((String)this.getURLViewInContext());
    }

    private String _getAssetDisplayPageName() throws PortalException {
        long assetDisplayPageId = this.getAssetDisplayPageId();
        if (assetDisplayPageId == 0L) {
            return "";
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntry((long)assetDisplayPageId);
        if (layoutPageTemplateEntry == null) {
            return "";
        }
        return layoutPageTemplateEntry.getName();
    }

    private AssetEntry _getAssetEntry() throws PortalException {
        if (this._assetEntry != null) {
            return this._assetEntry;
        }
        JournalArticle journalArticle = this.getArticle();
        if (journalArticle == null) {
            return this._assetEntry;
        }
        this._assetEntry = AssetEntryLocalServiceUtil.fetchEntry((long)journalArticle.getGroupId(), (String)journalArticle.getArticleResourceUuid());
        return this._assetEntry;
    }

    private DDMStructure _getDDMStructure(String ddmStructureKey) {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return DDMStructureLocalServiceUtil.fetchStructure((long)themeDisplay.getSiteGroupId(), (long)PortalUtil.getClassNameId(JournalArticle.class), (String)ddmStructureKey, (boolean)true);
    }

    private String _getLayoutBreadcrumb(Layout layout) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        List ancestors = layout.getAncestors();
        StringBundler sb = new StringBundler(4 * ancestors.size() + 5);
        if (layout.isPrivateLayout()) {
            sb.append(LanguageUtil.get((HttpServletRequest)this._request, (String)"private-pages"));
        } else {
            sb.append(LanguageUtil.get((HttpServletRequest)this._request, (String)"public-pages"));
        }
        sb.append(" ");
        sb.append(">");
        sb.append(" ");
        Collections.reverse(ancestors);
        for (Layout ancestor : ancestors) {
            sb.append(HtmlUtil.escape((String)ancestor.getName(locale)));
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
        }
        sb.append(HtmlUtil.escape((String)layout.getName(locale)));
        return sb.toString();
    }
}

