/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.internal.asset.display.contributor;

import com.liferay.asset.display.contributor.AssetDisplayContributor;
import com.liferay.asset.display.contributor.BaseAssetDisplayContributor;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.Value;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalConverter;
import com.liferay.journal.web.asset.JournalArticleDDMFormValuesReader;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={AssetDisplayContributor.class})
public class JournalArticleAssetDisplayContributor
extends BaseAssetDisplayContributor<JournalArticle> {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleAssetDisplayContributor.class);
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private JournalConverter _journalConverter;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    protected Map<String, Object> getClassTypeValues(JournalArticle article, Locale locale) {
        HashMap<String, Object> classTypeValues;
        block4: {
            classTypeValues = new HashMap<String, Object>();
            JournalArticleDDMFormValuesReader journalArticleDDMFormValuesReader = new JournalArticleDDMFormValuesReader(article);
            journalArticleDDMFormValuesReader.setFieldsToDDMFormValuesConverter(this._fieldsToDDMFormValuesConverter);
            journalArticleDDMFormValuesReader.setJournalConverter(this._journalConverter);
            try {
                DDMFormValues ddmFormValues = journalArticleDDMFormValuesReader.getDDMFormValues();
                Map ddmFormFieldsValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
                for (Map.Entry entry : ddmFormFieldsValuesMap.entrySet()) {
                    List ddmFormFieldValues = (List)entry.getValue();
                    DDMFormFieldValue ddmFormFieldValue0 = (DDMFormFieldValue)ddmFormFieldValues.get(0);
                    Value value = ddmFormFieldValue0.getValue();
                    String fieldValue = value.getString(locale);
                    if (Objects.equals(ddmFormFieldValue0.getType(), "ddm-image")) {
                        fieldValue = this._transformFileEntryURL(fieldValue);
                    }
                    classTypeValues.put((String)entry.getKey(), fieldValue);
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        return classTypeValues;
    }

    private String _transformFileEntryURL(String data) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)data);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            if (Validator.isNull((String)uuid) && groupId == 0L) {
                return "";
            }
            FileEntry fileEntry = this._dlAppService.getFileEntryByUuidAndGroupId(uuid, groupId);
            return DLUtil.getImagePreviewURL((FileEntry)fileEntry, null);
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, (Throwable)e);
            }
            return "";
        }
    }
}

