/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.dynamic.data.mapping.util;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.BaseDDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplay;
import com.liferay.dynamic.data.mapping.util.DDMDisplayTabItem;
import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.web.configuration.JournalWebConfiguration;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.journal.web.configuration.JournalWebConfiguration"}, property={"javax.portlet.name=com_liferay_journal_web_portlet_JournalPortlet"}, service={DDMDisplay.class})
public class JournalDDMDisplay
extends BaseDDMDisplay {
    @Reference
    protected Portal portal;
    @Reference
    protected PortletLocalService portletLocalService;
    private static final Log _log = LogFactoryUtil.getLog(JournalDDMDisplay.class);
    private static final Set<String> _templateLanguageTypes = SetUtil.fromArray((Object[])new String[]{"ftl", "vm", "xsl"});
    private static final Set<String> _viewTemplateExcludedColumnNames = SetUtil.fromArray((Object[])new String[]{"mode"});
    private volatile JournalWebConfiguration _journalWebConfiguration;

    public String getAvailableFields() {
        return "Liferay.FormBuilder.AVAILABLE_FIELDS.WCM_STRUCTURE";
    }

    public String getConfirmSelectStructureMessage(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"selecting-a-new-structure-deletes-all-unsaved-content");
    }

    public String getConfirmSelectTemplateMessage(Locale locale) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(locale), (String)"selecting-a-new-template-deletes-all-unsaved-content");
    }

    public String getEditStructureDefaultValuesURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, DDMStructure structure, String redirectURL) throws Exception {
        PortletURL portletURL = this.portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, "com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        portletURL.setParameter("redirect", redirectURL);
        portletURL.setParameter("groupId", String.valueOf(structure.getGroupId()));
        portletURL.setParameter("classNameId", String.valueOf(this.portal.getClassNameId(DDMStructure.class)));
        portletURL.setParameter("classPK", String.valueOf(structure.getStructureId()));
        portletURL.setParameter("ddmStructureKey", structure.getStructureKey());
        return portletURL.toString();
    }

    public String getPortletId() {
        return "com_liferay_journal_web_portlet_JournalPortlet";
    }

    public String getStorageType() {
        String storageType = StorageType.JSON.getValue();
        try {
            long companyId = CompanyThreadLocal.getCompanyId();
            JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(JournalServiceConfiguration.class, (long)companyId);
            storageType = journalServiceConfiguration.journalArticleStorageType();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return storageType;
    }

    public String getStructureType() {
        return JournalArticle.class.getName();
    }

    public List<DDMDisplayTabItem> getTabItems() {
        ArrayList<DDMDisplayTabItem> tabItems = new ArrayList<DDMDisplayTabItem>();
        tabItems.add(this._getWebContentTabItem());
        tabItems.add(this._getStructuresTabItem());
        tabItems.add(this.getTemplatesTabItem());
        if (this._journalWebConfiguration.showFeeds() && this.portal.isRSSFeedsEnabled()) {
            tabItems.add(this._getFeedsTabItem());
        }
        return tabItems;
    }

    public long getTemplateHandlerClassNameId(DDMTemplate template, long classNameId) {
        return this.portal.getClassNameId(JournalArticle.class);
    }

    public Set<String> getTemplateLanguageTypes() {
        return _templateLanguageTypes;
    }

    public String getTemplateType() {
        return "display";
    }

    public Set<String> getViewTemplatesExcludedColumnNames() {
        return _viewTemplateExcludedColumnNames;
    }

    public boolean isShowBackURLInTitleBar() {
        return true;
    }

    public boolean isShowConfirmSelectStructure() {
        return true;
    }

    public boolean isShowConfirmSelectTemplate() {
        return true;
    }

    public boolean isShowStructureSelector() {
        return true;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._journalWebConfiguration = (JournalWebConfiguration)ConfigurableUtil.createConfigurable(JournalWebConfiguration.class, properties);
    }

    protected DDMDisplayTabItem getTemplatesTabItem() {
        return new DDMDisplayTabItem(){

            public String getTitle(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
                ResourceBundle resourceBundle = JournalDDMDisplay.this.getResourceBundle(liferayPortletRequest.getLocale());
                return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"templates");
            }

            public String getURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
                ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
                Portlet portlet = JournalDDMDisplay.this.portletLocalService.getPortletById(portletDisplay.getId());
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)PortletProviderUtil.getPortletId((String)DDMTemplate.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW), (String)"RENDER_PHASE");
                ResourceBundle resourceBundle = JournalDDMDisplay.this.getResourceBundle(liferayPortletRequest.getLocale());
                portletURL.setParameter("mvcPath", "/view_template.jsp");
                portletURL.setParameter("navigationStartsOn", "VIEW_TEMPLATES");
                portletURL.setParameter("backURL", themeDisplay.getURLCurrent());
                portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
                portletURL.setParameter("classNameId", String.valueOf(JournalDDMDisplay.this.portal.getClassNameId(DDMStructure.class)));
                portletURL.setParameter("resourceClassNameId", String.valueOf(JournalDDMDisplay.this.portal.getClassNameId(JournalArticle.class)));
                portletURL.setParameter("refererPortletName", "com_liferay_journal_web_portlet_JournalPortlet");
                portletURL.setParameter("refererWebDAVToken", WebDAVUtil.getStorageToken((Portlet)portlet));
                portletURL.setParameter("scopeTitle", LanguageUtil.get((ResourceBundle)resourceBundle, (String)"templates"));
                portletURL.setParameter("showAncestorScopes", String.valueOf(JournalDDMDisplay.this._journalWebConfiguration.showAncestorScopesByDefault()));
                portletURL.setParameter("showCacheableInput", Boolean.TRUE.toString());
                portletURL.setParameter("showHeader", Boolean.FALSE.toString());
                return portletURL.toString();
            }

            public boolean isShow(LiferayPortletRequest liferayPortletRequest) {
                ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                Group group = themeDisplay.getScopeGroup();
                return !group.isLayout();
            }
        };
    }

    private DDMDisplayTabItem _getFeedsTabItem() {
        return new DDMDisplayTabItem(){

            public String getTitle(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
                ResourceBundle resourceBundle = JournalDDMDisplay.this.getResourceBundle(liferayPortletRequest.getLocale());
                return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"feeds");
            }

            public String getURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
                PortletURL portletURL = JournalDDMDisplay.this.portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, "com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
                portletURL.setParameter("mvcPath", "/view_feeds.jsp");
                ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
                return portletURL.toString();
            }
        };
    }

    private DDMDisplayTabItem _getStructuresTabItem() {
        return new DDMDisplayTabItem(){

            public String getTitle(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
                ResourceBundle resourceBundle = JournalDDMDisplay.this.getResourceBundle(liferayPortletRequest.getLocale());
                return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"structures");
            }

            public String getURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
                ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
                Portlet portlet = JournalDDMDisplay.this.portletLocalService.getPortletById(portletDisplay.getId());
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)PortletProviderUtil.getPortletId((String)DDMStructure.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW), (String)"RENDER_PHASE");
                portletURL.setParameter("mvcPath", "/view.jsp");
                portletURL.setParameter("backURL", themeDisplay.getURLCurrent());
                portletURL.setParameter("groupId", String.valueOf(themeDisplay.getScopeGroupId()));
                portletURL.setParameter("refererPortletName", "com_liferay_journal_web_portlet_JournalPortlet");
                portletURL.setParameter("refererWebDAVToken", WebDAVUtil.getStorageToken((Portlet)portlet));
                portletURL.setParameter("scopeTitle", this.getTitle(liferayPortletRequest, liferayPortletResponse));
                portletURL.setParameter("showAncestorScopes", String.valueOf(JournalDDMDisplay.this._journalWebConfiguration.showAncestorScopesByDefault()));
                portletURL.setParameter("showCacheableInput", Boolean.TRUE.toString());
                portletURL.setParameter("showManageTemplates", Boolean.TRUE.toString());
                return portletURL.toString();
            }

            public boolean isShow(LiferayPortletRequest liferayPortletRequest) {
                ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                Group group = themeDisplay.getScopeGroup();
                return !group.isLayout();
            }
        };
    }

    private DDMDisplayTabItem _getWebContentTabItem() {
        return new DDMDisplayTabItem(){

            public String getTitle(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
                ResourceBundle resourceBundle = JournalDDMDisplay.this.getResourceBundle(liferayPortletRequest.getLocale());
                return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"web-content");
            }

            public String getURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
                PortletURL portletURL = JournalDDMDisplay.this.portal.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, "com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
                portletURL.setParameter("mvcPath", "/view.jsp");
                return portletURL.toString();
            }
        };
    }
}

