/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.web.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.web.internal.security.permission.resource.JournalFolderPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.trash.TrashHelper;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class JournalFolderAssetRenderer
extends BaseJSPAssetRenderer<JournalFolder>
implements TrashRenderer {
    public static final String TYPE = "folder";
    private final JournalFolder _folder;
    private final TrashHelper _trashHelper;

    @Deprecated
    public JournalFolderAssetRenderer(JournalFolder folder) {
        this(folder, null);
    }

    public JournalFolderAssetRenderer(JournalFolder folder, TrashHelper trashHelper) {
        this._folder = folder;
        this._trashHelper = trashHelper;
    }

    public JournalFolder getAssetObject() {
        return this._folder;
    }

    public String getClassName() {
        return JournalFolder.class.getName();
    }

    public long getClassPK() {
        return this._folder.getFolderId();
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._folder.getModifiedDate();
    }

    public long getGroupId() {
        return this._folder.getGroupId();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("full_content")) {
            request.setAttribute("JOURNAL_FOLDER", (Object)this._folder);
            return "/asset/folder_" + template + ".jsp";
        }
        return null;
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._folder.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._folder.getDescription();
    }

    public String getTitle(Locale locale) {
        if (this._trashHelper == null) {
            return this._folder.getName();
        }
        return this._trashHelper.getOriginalTitle(this._folder.getName());
    }

    public String getType() {
        return TYPE;
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._folder.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_journal_web_portlet_JournalPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_folder.jsp");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        return portletURL;
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcPath", "/asset/folder_full_content.jsp");
        portletURL.setParameter("folderId", String.valueOf(this._folder.getFolderId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        try {
            return this.getURLView(liferayPortletResponse, WindowState.MAXIMIZED);
        }
        catch (Exception e) {
            return noSuchEntryRedirect;
        }
    }

    public long getUserId() {
        return this._folder.getUserId();
    }

    public String getUserName() {
        return this._folder.getUserName();
    }

    public String getUuid() {
        return this._folder.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalFolderPermission.contains(permissionChecker, this._folder, "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return JournalFolderPermission.contains(permissionChecker, this._folder, "VIEW");
    }
}

