/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.test.util.search;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.test.util.search.JournalArticleBlueprint;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.test.util.ServiceContextTestUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalArticleSearchFixture {
    private final JournalArticleLocalService _journalArticleLocalService;
    private final List<JournalArticle> _journalArticles = new ArrayList<JournalArticle>();

    public JournalArticleSearchFixture(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    public JournalArticle addArticle(JournalArticleBlueprint journalArticleBlueprint) {
        String ddmStructureKey = "BASIC-WEB-CONTENT";
        String ddmTemplateKey = "BASIC-WEB-CONTENT";
        return this.addArticle(journalArticleBlueprint, ddmStructureKey, ddmTemplateKey);
    }

    public JournalArticle addArticle(JournalArticleBlueprint journalArticleBlueprint, String ddmStructureKey, String ddmTemplateKey) {
        long userId = journalArticleBlueprint.getUserId();
        long groupId = journalArticleBlueprint.getGroupId();
        long folderId = 0L;
        Map<Locale, String> titleMap = journalArticleBlueprint.getTitleMap();
        Map<Locale, String> descriptionMap = journalArticleBlueprint.getDescriptionMap();
        String contentString = journalArticleBlueprint.getContentString();
        ServiceContext serviceContext = this.getServiceContext(groupId, userId);
        serviceContext.setAssetCategoryIds(journalArticleBlueprint.getAssetCategoryIds());
        if (journalArticleBlueprint.isWorkflowEnabled()) {
            serviceContext.setWorkflowAction(journalArticleBlueprint.getWorkflowAction());
        }
        JournalArticle journalArticle = this.addArticle(userId, groupId, folderId, titleMap, descriptionMap, contentString, ddmStructureKey, ddmTemplateKey, serviceContext);
        this._journalArticles.add(journalArticle);
        return journalArticle;
    }

    public List<JournalArticle> getJournalArticles() {
        return this._journalArticles;
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public JournalArticle updateArticle(JournalArticle journalArticle) throws Exception {
        journalArticle = this._journalArticleLocalService.updateArticle(journalArticle.getUserId(), journalArticle.getGroupId(), journalArticle.getFolderId(), journalArticle.getArticleId(), journalArticle.getVersion(), journalArticle.getTitleMap(), journalArticle.getDescriptionMap(), journalArticle.getContent(), journalArticle.getLayoutUuid(), ServiceContextTestUtil.getServiceContext((long)journalArticle.getGroupId()));
        this._journalArticles.add(journalArticle);
        return journalArticle;
    }

    protected JournalArticle addArticle(long userId, long groupId, long folderId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String contentString, String ddmStructureKey, String ddmTemplateKey, ServiceContext serviceContext) {
        try {
            return this._journalArticleLocalService.addArticle(userId, groupId, folderId, titleMap, descriptionMap, contentString, ddmStructureKey, ddmTemplateKey, serviceContext);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    protected ServiceContext getServiceContext(long groupId, long userId) {
        try {
            return ServiceContextTestUtil.getServiceContext((long)groupId, (long)userId);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }
}

