/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.servlet.taglib.clay;

import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.frontend.taglib.clay.servlet.taglib.soy.BaseVerticalCard;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;

public class JournalArticleVerticalCard
extends BaseVerticalCard {
    private final JournalArticle _article;
    private final AssetRenderer<JournalArticle> _assetRenderer;
    private final RenderRequest _renderRequest;
    private final ThemeDisplay _themeDisplay;

    public JournalArticleVerticalCard(JournalArticle article, AssetRenderer<JournalArticle> assetRenderer, RenderRequest renderRequest) {
        super((BaseModel)article, renderRequest, null);
        this._article = article;
        this._assetRenderer = assetRenderer;
        this._renderRequest = renderRequest;
        this._themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public String getIcon() {
        return "web-content";
    }

    public String getImageSrc() {
        try {
            return HtmlUtil.escapeAttribute((String)this._assetRenderer.getThumbnailPath((PortletRequest)this._renderRequest));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTitle() {
        String title = this._assetRenderer.getTitle(this._themeDisplay.getLocale());
        if (this._article.getGroupId() == this._themeDisplay.getScopeGroupId()) {
            return title;
        }
        Group articleGroup = GroupLocalServiceUtil.fetchGroup((long)this._article.getGroupId());
        if (articleGroup == null) {
            return title;
        }
        try {
            StringBundler sb = new StringBundler(5);
            sb.append(title);
            sb.append(" ");
            sb.append("(");
            sb.append(HtmlUtil.escape((String)articleGroup.getDescriptiveName(this._themeDisplay.getLocale())));
            sb.append(")");
            return sb.toString();
        }
        catch (Exception e) {
            return title;
        }
    }

    public boolean isSelectable() {
        return false;
    }
}

