/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.portlet.toolbar.contributor;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.journal.content.web.configuration.JournalContentPortletInstanceConfiguration;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.toolbar.contributor.BasePortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionChecker;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet", "mvc.path=-", "mvc.path=/view.jsp"}, service={JournalContentPortletToolbarContributor.class, PortletToolbarContributor.class})
public class JournalContentPortletToolbarContributor
extends BasePortletToolbarContributor {
    private static final Log _log = LogFactoryUtil.getLog(JournalContentPortletToolbarContributor.class);
    @Reference
    private Http _http;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.journal)", unbind="-")
    private ResourcePermissionChecker _resourcePermissionChecker;

    protected void addPortletTitleAddJournalArticleMenuItems(List<MenuItem> menuItems, ThemeDisplay themeDisplay, PortletRequest portletRequest) throws Exception {
        long plid = themeDisplay.getPlid();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        long scopeGroupId = themeDisplay.getScopeGroupId();
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, "com_liferay_journal_web_portlet_JournalPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_article.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        portletURL.setParameter("portletResource", portletDisplay.getId());
        portletURL.setParameter("refererPlid", String.valueOf(plid));
        portletURL.setParameter("groupId", String.valueOf(scopeGroupId));
        List ddmStructures = this._journalFolderService.getDDMStructures(this._portal.getCurrentAndAncestorSiteGroupIds(scopeGroupId), 0L, 0);
        JournalContentPortletInstanceConfiguration journalContentPortletInstanceConfiguration = (JournalContentPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(JournalContentPortletInstanceConfiguration.class);
        if (journalContentPortletInstanceConfiguration.sortStructuresByByName()) {
            Locale locale = themeDisplay.getLocale();
            ddmStructures.sort((ddmStructure1, ddmStructure2) -> {
                String name1 = ddmStructure1.getName(locale);
                String name2 = ddmStructure2.getName(locale);
                return name1.compareTo(name2);
            });
        }
        for (DDMStructure ddmStructure : ddmStructures) {
            portletURL.setParameter("ddmStructureId", String.valueOf(ddmStructure.getStructureId()));
            URLMenuItem urlMenuItem = new URLMenuItem();
            String ddmStructureName = ddmStructure.getName(themeDisplay.getLocale());
            String title = LanguageUtil.format((Locale)themeDisplay.getLocale(), (String)"new-x", (Object)ddmStructureName);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", HtmlUtil.escape((String)portletDisplay.getNamespace()) + "editAsset");
            data.put("title", HtmlUtil.escape((String)title));
            urlMenuItem.setData(data);
            String label = ddmStructure.getUnambiguousName(ddmStructures, themeDisplay.getScopeGroupId(), themeDisplay.getLocale());
            urlMenuItem.setLabel(label);
            String url = this._http.addParameter(portletURL.toString(), "refererPlid", plid);
            urlMenuItem.setURL(url);
            menuItems.add((MenuItem)urlMenuItem);
        }
    }

    protected List<MenuItem> getPortletTitleMenuItems(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        if (!this._hasAddArticlePermission(themeDisplay) || layout.isLayoutPrototypeLinkActive()) {
            return Collections.emptyList();
        }
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        try {
            this.addPortletTitleAddJournalArticleMenuItems(menuItems, themeDisplay, portletRequest);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to add folder menu item", (Throwable)e);
        }
        return menuItems;
    }

    private boolean _hasAddArticlePermission(ThemeDisplay themeDisplay) {
        boolean hasPortletPermission;
        boolean hasResourcePermission;
        block3: {
            long scopeGroupId = themeDisplay.getScopeGroupId();
            hasResourcePermission = this._resourcePermissionChecker.checkResource(themeDisplay.getPermissionChecker(), scopeGroupId, "ADD_ARTICLE");
            hasPortletPermission = false;
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            try {
                hasPortletPermission = PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)portletDisplay.getId(), (String)"CONFIGURATION");
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)"Unable to check Journal Content portlet permission", (Throwable)pe);
            }
        }
        boolean hasAddArticlePermission = false;
        if (hasResourcePermission && hasPortletPermission) {
            hasAddArticlePermission = true;
        }
        return hasAddArticlePermission;
    }
}

