/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.portlet.action;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.journal.content.web.internal.display.context.JournalContentDisplayContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.util.JournalContent;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet"}, service={ConfigurationAction.class})
public class JournalContentConfigurationAction
extends DefaultConfigurationAction {
    private static final long _CLASS_NAME_ID = PortalUtil.getClassNameId(DDMStructure.class);
    private static final Log _log = LogFactoryUtil.getLog(JournalContentConfigurationAction.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate)")
    private ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission;
    @Reference
    private JournalContent _journalContent;

    public String getJspPath(HttpServletRequest httpServletRequest) {
        return "/configuration.jsp";
    }

    public void include(PortletConfig portletConfig, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        block2: {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
            PortletResponse portletResponse = (PortletResponse)httpServletRequest.getAttribute("javax.portlet.response");
            httpServletRequest.setAttribute("JOURNAL_CONTENT", (Object)this._journalContent);
            try {
                JournalContentDisplayContext journalContentDisplayContext = JournalContentDisplayContext.create(portletRequest, portletResponse, themeDisplay.getPortletDisplay(), _CLASS_NAME_ID, this._ddmTemplateModelResourcePermission);
                httpServletRequest.setAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT", (Object)journalContentDisplayContext);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        super.include(portletConfig, httpServletRequest, httpServletResponse);
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String articleId = this.getArticleId((PortletRequest)actionRequest);
        this.setPreference((PortletRequest)actionRequest, "articleId", articleId);
        long articleGroupId = this.getArticleGroupId((PortletRequest)actionRequest);
        this.setPreference((PortletRequest)actionRequest, "groupId", String.valueOf(articleGroupId));
        super.processAction(portletConfig, actionRequest, actionResponse);
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.journal.content.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected long getArticleGroupId(PortletRequest portletRequest) {
        long assetEntryId = GetterUtil.getLong((String)this.getParameter(portletRequest, "assetEntryId"));
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
        if (assetEntry == null) {
            return 0L;
        }
        return assetEntry.getGroupId();
    }

    protected String getArticleId(PortletRequest portletRequest) throws PortalException {
        long assetEntryId = GetterUtil.getLong((String)this.getParameter(portletRequest, "assetEntryId"));
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetEntryId);
        if (assetEntry == null) {
            return "";
        }
        AssetRendererFactory articleAssetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClass(JournalArticle.class);
        AssetRenderer articleAssetRenderer = articleAssetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
        JournalArticle article = (JournalArticle)articleAssetRenderer.getAssetObject();
        return StringUtil.toUpperCase((String)article.getArticleId());
    }
}

