/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.content.web.internal.portlet;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.journal.content.web.internal.display.context.JournalContentDisplayContext;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.util.ExportArticleHelper;
import com.liferay.journal.util.JournalContent;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PrefsParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.service.TrashEntryService;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.fragment.entry.processor.portlet.alias=web-content", "com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=portlet-journal-content", "com.liferay.portlet.display-category=category.cms", "com.liferay.portlet.display-category=category.highlighted", "com.liferay.portlet.header-portlet-css=/css/main.css", "com.liferay.portlet.icon=/icons/journal_content.png", "com.liferay.portlet.instanceable=true", "com.liferay.portlet.layout-cacheable=true", "com.liferay.portlet.preferences-owned-by-group=true", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.scopeable=true", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Web Content Display", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/view.jsp", "javax.portlet.name=com_liferay_journal_content_web_portlet_JournalContentPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=guest,power-user,user", "javax.portlet.supports.mime-type=application/vnd.wap.xhtml+xml", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class JournalContentPortlet
extends MVCPortlet {
    private static final long _CLASS_NAME_ID = PortalUtil.getClassNameId(DDMStructure.class);
    private static final Log _log = LogFactoryUtil.getLog(JournalContentPortlet.class);
    @Reference(target="(model.class.name=com.liferay.dynamic.data.mapping.model.DDMTemplate)")
    private ModelResourcePermission<DDMTemplate> _ddmTemplateModelResourcePermission;
    @Reference
    private ExportArticleHelper _exportArticleHelper;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalContent _journalContent;
    @Reference
    private TrashEntryService _trashEntryService;

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletPreferences portletPreferences = renderRequest.getPreferences();
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long articleGroupId = PrefsParamUtil.getLong((PortletPreferences)portletPreferences, (PortletRequest)renderRequest, (String)"groupId", (long)themeDisplay.getScopeGroupId());
        String articleId = PrefsParamUtil.getString((PortletPreferences)portletPreferences, (PortletRequest)renderRequest, (String)"articleId");
        JournalArticle article = null;
        JournalArticleDisplay articleDisplay = null;
        JournalContentDisplayContext journalContentDisplayContext = (JournalContentDisplayContext)renderRequest.getAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT");
        if (journalContentDisplayContext != null) {
            try {
                article = journalContentDisplayContext.getArticle();
                articleDisplay = journalContentDisplayContext.getArticleDisplay();
            }
            catch (PortalException pe) {
                _log.error((Object)"Unable to get journal article", (Throwable)pe);
            }
        } else if (articleGroupId > 0L && Validator.isNotNull((String)articleId)) {
            String viewMode = ParamUtil.getString((PortletRequest)renderRequest, (String)"viewMode");
            String languageId = LanguageUtil.getLanguageId((PortletRequest)renderRequest);
            int page = ParamUtil.getInteger((PortletRequest)renderRequest, (String)"page", (int)1);
            article = this._journalArticleLocalService.fetchLatestArticle(articleGroupId, articleId, 0);
            try {
                String ddmTemplateKey;
                if (article == null) {
                    article = this._journalArticleLocalService.getLatestArticle(articleGroupId, articleId, -1);
                }
                if (Validator.isNull((String)(ddmTemplateKey = PrefsParamUtil.getString((PortletPreferences)portletPreferences, (PortletRequest)renderRequest, (String)"ddmTemplateKey")))) {
                    ddmTemplateKey = article.getDDMTemplateKey();
                }
                articleDisplay = this._journalContent.getDisplay(article, ddmTemplateKey, viewMode, languageId, page, new PortletRequestModel((PortletRequest)renderRequest, (PortletResponse)renderResponse), themeDisplay);
            }
            catch (Exception e) {
                renderRequest.removeAttribute("JOURNAL_ARTICLE");
            }
        }
        if (article != null) {
            renderRequest.setAttribute("JOURNAL_ARTICLE", (Object)article);
        }
        if (articleDisplay != null) {
            renderRequest.setAttribute("JOURNAL_ARTICLE_DISPLAY", (Object)articleDisplay);
        } else {
            renderRequest.removeAttribute("JOURNAL_ARTICLE_DISPLAY");
        }
        super.doView(renderRequest, renderResponse);
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        block2: {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            renderRequest.setAttribute("JOURNAL_CONTENT", (Object)this._journalContent);
            try {
                JournalContentDisplayContext journalContentDisplayContext = JournalContentDisplayContext.create((PortletRequest)renderRequest, (PortletResponse)renderResponse, themeDisplay.getPortletDisplay(), _CLASS_NAME_ID, this._ddmTemplateModelResourcePermission);
                renderRequest.setAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT", (Object)journalContentDisplayContext);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)pe, (Throwable)pe);
            }
        }
        super.render(renderRequest, renderResponse);
    }

    public void restoreJournalArticle(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long classPK = ParamUtil.getLong((PortletRequest)actionRequest, (String)"classPK");
        this._trashEntryService.restoreEntry(JournalArticle.class.getName(), classPK);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
        if (resourceID.equals("exportArticle")) {
            String targetExtension = ParamUtil.getString((PortletRequest)resourceRequest, (String)"targetExtension");
            targetExtension = StringUtil.toUpperCase((String)targetExtension);
            PortletPreferences portletPreferences = resourceRequest.getPreferences();
            Object[] allowedExtensions = StringUtil.split((String)portletPreferences.getValue("userToolAssetAddonEntryKeys", null));
            if (ArrayUtil.contains((Object[])allowedExtensions, (Object)("enable" + StringUtil.toUpperCase((String)targetExtension)))) {
                this._exportArticleHelper.sendFile(targetExtension, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            }
        } else {
            block5: {
                ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                resourceRequest.setAttribute("JOURNAL_CONTENT", (Object)this._journalContent);
                try {
                    JournalContentDisplayContext journalContentDisplayContext = JournalContentDisplayContext.create((PortletRequest)resourceRequest, (PortletResponse)resourceResponse, themeDisplay.getPortletDisplay(), _CLASS_NAME_ID, this._ddmTemplateModelResourcePermission);
                    resourceRequest.setAttribute("JOURNAL_CONTENT_DISPLAY_CONTEXT", (Object)journalContentDisplayContext);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block5;
                    _log.debug((Object)pe, (Throwable)pe);
                }
            }
            super.serveResource(resourceRequest, resourceResponse);
        }
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.journal.content.web)(&(release.schema.version>=1.0.0)(!(release.schema.version>=1.1.0))))", unbind="-")
    protected void setRelease(Release release) {
    }
}

